/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.container.PedestalContainer;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class PedestalTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 1;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createInventory);
    public static final float DEFAULT_HEIGHT = 1.25f;
    public static final float DEFAULT_ROTATION = 0.0f;
    public static final float DEFAULT_ROTATION_SPEED = 0.6f;
    public static final float DEFAULT_BOB_SPEED = 0.02f;
    public static final float DEFAULT_SCALE = 1.0f;
    private boolean stationOfAwakeningMarker = false;
    private ItemStack displayStack = ItemStack.f_41583_;
    private float rotationSpeed = 0.6f;
    private float bobSpeed = 0.02f;
    private float scale = 1.0f;
    private float currentRotation = 0.0f;
    private float currentHeight = 0.0f;
    private float savedRotation = 0.0f;
    private float savedHeight = 1.25f;
    private float baseHeight = 1.25f;
    private boolean pause = false;
    private boolean flipped = false;
    public boolean hide = false;
    private static int ticksExisted;
    public static int previousTicks;

    public PedestalTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModEntities.TYPE_PEDESTAL.get(), pos, state);
    }

    private IItemHandler createInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 5.0, 0.0);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag invCompound = compound.m_128469_("inv");
        this.inventory.ifPresent(iih -> ((INBTSerializable)iih).deserializeNBT((Tag)invCompound));
        CompoundTag transformations = compound.m_128469_("transforms");
        this.rotationSpeed = transformations.m_128457_("rotspeed");
        this.bobSpeed = transformations.m_128457_("bobspeed");
        this.savedRotation = transformations.m_128457_("savedrot");
        this.savedHeight = transformations.m_128457_("savedheight");
        this.scale = transformations.m_128457_("scale");
        this.baseHeight = transformations.m_128457_("baseheight");
        this.pause = transformations.m_128471_("pause");
        this.flipped = transformations.m_128471_("flipped");
        this.stationOfAwakeningMarker = compound.m_128471_("soa_marker");
        this.displayStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("display_stack"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.inventory.ifPresent(iih -> {
            CompoundTag invCompound = (CompoundTag)((INBTSerializable)iih).serializeNBT();
            compound.m_128365_("inv", (Tag)invCompound);
        });
        CompoundTag transformations = new CompoundTag();
        transformations.m_128350_("rotspeed", this.rotationSpeed);
        transformations.m_128350_("bobspeed", this.bobSpeed);
        transformations.m_128350_("savedrot", this.savedRotation);
        transformations.m_128350_("savedheight", this.savedHeight);
        transformations.m_128350_("scale", this.scale);
        transformations.m_128350_("baseheight", this.baseHeight);
        transformations.m_128379_("pause", this.pause);
        transformations.m_128379_("flipped", this.flipped);
        compound.m_128365_("transforms", (Tag)transformations);
        compound.m_128379_("soa_marker", this.stationOfAwakeningMarker);
        compound.m_128365_("display_stack", (Tag)this.displayStack.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.pedestal");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player playerEntity) {
        return new PedestalContainer(windowID, playerInventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setStationOfAwakeningMarker(boolean marker) {
        this.stationOfAwakeningMarker = marker;
        this.m_6596_();
    }

    public boolean isStationOfAwakeningMarker() {
        return this.stationOfAwakeningMarker;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void setDisplayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
        this.m_6596_();
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public float getBobSpeed() {
        return this.bobSpeed;
    }

    public float getSavedRotation() {
        return this.savedRotation;
    }

    public float getSavedHeight() {
        return this.savedHeight;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setSpeed(float rotationSpeed, float bobSpeed) {
        this.rotationSpeed = rotationSpeed;
        this.bobSpeed = bobSpeed;
        this.m_6596_();
    }

    public void saveTransforms(float savedRotation, float savedHeight) {
        this.savedRotation = savedRotation;
        this.savedHeight = savedHeight;
        this.m_6596_();
    }

    public void setPause(boolean pause) {
        this.pause = pause;
        this.m_6596_();
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
        this.m_6596_();
    }

    public void setCurrentTransforms(float currentRotation, float currentHeight) {
        this.currentHeight = currentHeight;
        this.currentRotation = currentRotation;
    }

    public float getBaseHeight() {
        return this.baseHeight;
    }

    public void setBaseHeight(float baseHeight) {
        this.baseHeight = baseHeight;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getCurrentHeight() {
        return this.currentHeight;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int ticksExisted() {
        return ticksExisted;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        PedestalTileEntity ped;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof PedestalTileEntity && !(ped = (PedestalTileEntity)blockEntity2).isPaused()) {
            previousTicks = ticksExisted++;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

