/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ThundaraEntity
extends ThrowableProjectile {
    int maxTicks = 35;
    float dmgMult = 1.0f;
    LivingEntity lockedOnEntity;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(ThundaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    List<LivingEntity> list = new ArrayList<LivingEntity>();

    public ThundaraEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public ThundaraEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_THUNDARA.get(), world);
    }

    public ThundaraEntity(Level world, Player player, float dmgMult, LivingEntity lockedOnEntity) {
        super((EntityType)ModEntities.TYPE_THUNDARA.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.dmgMult = dmgMult;
        this.lockedOnEntity = lockedOnEntity;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(Util.f_137441_));
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        float radius = 2.5f;
        if (!this.m_9236_().f_46443_ && this.getCaster() != null) {
            if (this.f_19797_ == 1) {
                this.list = this.lockedOnEntity != null ? Utils.getLivingEntitiesInRadiusExcludingParty(this.getCaster(), (Entity)this.lockedOnEntity, radius, radius, radius) : Utils.getLivingEntitiesInRadiusExcludingParty(this.getCaster(), radius);
                this.list.remove((Object)this);
            }
            if (this.f_19797_ % 8 == 1) {
                if (!this.list.isEmpty()) {
                    int i = this.m_9236_().f_46441_.m_188503_(this.list.size());
                    Entity e = (Entity)this.list.get(i);
                    if (e instanceof LivingEntity) {
                        if (!e.m_6084_()) {
                            this.list.remove(e);
                        }
                        float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.075f : 2.0f;
                        ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().m_9236_(), this.getCaster(), e.m_20185_(), e.m_20186_(), e.m_20189_(), dmg * this.dmgMult);
                        shot.setCaster(this.getCaster().m_20148_());
                        this.m_9236_().m_7967_((Entity)shot);
                        LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                        lightningBoltEntity.m_20874_(true);
                        lightningBoltEntity.m_20219_(Vec3.m_82539_((Vec3i)e.m_20183_()));
                        lightningBoltEntity.m_20879_(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                        this.m_9236_().m_7967_((Entity)lightningBoltEntity);
                    }
                } else {
                    int z;
                    int x;
                    if (this.lockedOnEntity != null) {
                        x = (int)this.lockedOnEntity.m_20185_();
                        z = (int)this.lockedOnEntity.m_20189_();
                    } else {
                        x = (int)this.getCaster().m_20185_();
                        z = (int)this.getCaster().m_20189_();
                    }
                    int posX = (int)((float)(x + this.getCaster().m_9236_().f_46441_.m_188503_((int)(radius * 2.0f))) - radius / 2.0f) - 1;
                    int posZ = (int)((float)(z + this.getCaster().m_9236_().f_46441_.m_188503_((int)(radius * 2.0f))) - radius / 2.0f) - 1;
                    float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.08f : 2.0f;
                    dmg = Math.max(0.25f, dmg);
                    ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().m_9236_(), this.getCaster(), posX, this.getCaster().m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, posX, posZ), posZ, dmg * this.dmgMult);
                    shot.setCaster(this.getCaster().m_20148_());
                    this.m_9236_().m_7967_((Entity)shot);
                    BlockPos pos = new BlockPos(posX, this.getCaster().m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, posX, posZ), posZ);
                    LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    lightningBoltEntity.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    lightningBoltEntity.m_20874_(true);
                    lightningBoltEntity.m_20879_(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                    this.m_9236_().m_7967_((Entity)lightningBoltEntity);
                }
            }
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult result) {
    }
}

