/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import org.joml.Vector3f;

public class MarluxiaGoal
extends TargetGoal {
    private final int MAX_ARMOR_TICKS = 600;
    private final int MAX_ARMOR_USES = 3;
    private int armorTicks = 0;
    private int armorUses = 0;
    private final int MAX_TP_TICKS = 80;
    private int tpTicks = 0;
    public int chasingTicks = 0;
    public int chasedTimes = 0;
    private int ticksToChooseAI = 200;
    double posX;
    double posY;
    double posZ;

    public MarluxiaGoal(PathfinderMob creature) {
        super((Mob)creature, true);
    }

    public boolean m_8045_() {
        if (this.f_26135_.f_19797_ < 100) {
            this.f_26135_.m_20334_(0.0, 0.0, 0.0);
            this.f_26135_.m_20331_(true);
            this.f_26135_.m_21051_(Attributes.f_22281_).m_22100_(0.0);
        }
        if (this.f_26135_.f_19797_ >= 100 && this.f_26135_.f_19797_ <= 101) {
            this.f_26135_.m_20331_(false);
            this.f_26135_.m_21051_(Attributes.f_22281_).m_22100_(11.0);
        }
        if (this.f_26135_.m_5448_() != null) {
            if (this.ticksToChooseAI <= 0 && EntityHelper.getState((Entity)this.f_26135_) == 0) {
                int n = this.f_26135_.m_9236_().f_46441_.m_188502_() * 100;
                if (n < 50) {
                    if ((double)this.f_26135_.m_21223_() < (double)this.f_26135_.m_21233_() * 0.8 && !this.isArmored()) {
                        this.useArmor((MarluxiaEntity)this.f_26135_, false);
                        this.ticksToChooseAI = 200;
                    } else {
                        this.ticksToChooseAI = 100;
                    }
                } else {
                    this.useTP((MarluxiaEntity)this.f_26135_);
                    this.ticksToChooseAI = 150;
                }
            } else if (EntityHelper.getState((Entity)this.f_26135_) == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isArmored()) {
                this.armoredAI();
            }
            if (this.isTeleporting()) {
                this.teleportAI();
            }
            if (this.isChasing()) {
                this.chasingAI();
            }
            return true;
        }
        if (ModConfigs.bossDespawnIfNoTarget) {
            this.f_26135_.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            if (this.f_26135_.m_20068_()) {
                this.f_26135_.m_20242_(false);
            }
            if (EntityHelper.getState((Entity)this.f_26135_) == 0) {
                EntityHelper.setState((Entity)this.f_26135_, 0);
            }
        }
        return false;
    }

    private void teleportAI() {
        this.f_26135_.m_20242_(true);
        if (this.tpTicks % 20 == 0) {
            this.attackWithTP();
        }
        if (this.tpTicks > 80) {
            this.f_26135_.m_20242_(false);
            EntityHelper.setState((Entity)this.f_26135_, 0);
        }
        this.tpTicks += 2;
    }

    private void armoredAI() {
        if (this.armorTicks <= 40) {
            this.f_26135_.m_20334_(0.0, 0.2, 0.0);
            this.f_26135_.m_20331_(true);
        } else if (this.armorTicks < 45) {
            this.f_26135_.m_20334_(0.0, -100.0, 0.0);
        }
        if (this.armorTicks == 48) {
            this.posX = this.f_26135_.m_20185_();
            this.posY = this.f_26135_.m_20186_();
            this.posZ = this.f_26135_.m_20189_();
            this.f_26135_.m_20331_(false);
        }
        if (this.armorTicks > 48 && this.armorTicks < 70) {
            double r = (double)(this.armorTicks - 48) * 0.7;
            for (int a = 1; a <= 360; a += 7) {
                double x = this.posX + r * Math.cos(Math.toRadians(a));
                double z = this.posZ + r * Math.sin(Math.toRadians(a));
                ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.9f, 0.9f), 1.0f), x, this.posY + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            AABB aabb = new AABB(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).m_82377_(r, 0.0, r);
            List list = this.f_26135_.m_9236_().m_45976_(LivingEntity.class, aabb);
            list.remove(this.f_26135_);
            for (LivingEntity enemy : list) {
                this.f_26135_.m_7327_((Entity)enemy);
            }
        }
        this.armorTicks += 2;
        if (this.armorTicks >= 600) {
            this.removeArmor((MarluxiaEntity)this.f_26135_);
            this.armorTicks = 0;
        }
    }

    private void chasingAI() {
        if (this.chasingTicks <= 40) {
            this.f_26135_.m_21051_(Attributes.f_22281_).m_22100_(0.0);
            this.f_26135_.m_20334_(0.0, 0.2, 0.0);
            this.f_26135_.m_20331_(true);
        } else if (this.chasingTicks < 300) {
            this.f_26135_.m_19890_(this.f_26135_.m_5448_().m_20185_(), this.f_26135_.m_5448_().m_20186_(), this.f_26135_.m_5448_().m_20189_(), this.f_26135_.m_5448_().m_146908_(), this.f_26135_.m_5448_().m_146908_());
            RandomSource rand = this.f_26135_.m_9236_().m_213780_();
            ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.6f), 1.0f), this.f_26135_.m_20185_() - 1.0 + rand.m_188500_() * 2.0, this.f_26135_.m_20186_(), this.f_26135_.m_20189_() - 1.0 + rand.m_188500_() * 2.0, 10, 0.0, 0.0, 0.0, 100.0);
            if (this.chasingTicks % 10 == 0) {
                boolean r = true;
                double pX = this.f_26135_.m_5448_().m_20185_() - 3.0 + rand.m_188500_() * 6.0;
                double pY = this.f_26135_.m_5448_().m_20186_();
                double pZ = this.f_26135_.m_5448_().m_20189_() - 3.0 + rand.m_188500_() * 6.0;
                this.f_26135_.m_9236_().m_5594_(null, new BlockPos((int)pX, (int)pY, (int)pZ), (SoundEvent)ModSounds.portal.get(), SoundSource.MASTER, 1.0f, 1.0f);
                for (double i = 0.0; i < 4.0; i += 0.5) {
                    for (int a = 1; a <= 360; a += 7) {
                        double x = pX + (double)r * Math.cos(Math.toRadians(a));
                        double z = pZ + (double)r * Math.sin(Math.toRadians(a));
                        ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.5f), 1.0f), x, pY + i, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                AABB aabb = new AABB(pX, pY, pZ, pX + 1.0, pY + 1.0, pZ + 1.0).m_82377_((double)r, 4.0, (double)r);
                List list = this.f_26135_.m_9236_().m_45976_(LivingEntity.class, aabb);
                list.remove(this.f_26135_);
                for (LivingEntity enemy : list) {
                    enemy.m_6469_(enemy.m_269291_().m_269425_(), 3.0f);
                }
            }
        } else if (this.chasingTicks >= 300) {
            this.f_26135_.m_21051_(Attributes.f_22281_).m_22100_(11.0);
            this.useArmor((MarluxiaEntity)this.f_26135_, true);
        }
        this.chasingTicks += 2;
    }

    private void attackWithTP() {
        RandomSource rand = this.f_26135_.m_9236_().m_213780_();
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.6f), 1.0f), this.f_26135_.m_20185_() - 2.0 + rand.m_188500_() * 4.0, this.f_26135_.m_20186_() + rand.m_188500_() * 4.0, this.f_26135_.m_20189_() - 2.0 + rand.m_188500_() * 4.0, 10, 0.0, 0.0, 0.0, 100.0);
        }
        this.f_26135_.m_6021_(this.f_26135_.m_5448_().m_20185_(), this.f_26135_.m_5448_().m_20186_() + 1.0, this.f_26135_.m_5448_().m_20189_());
        if (this.f_26135_.m_5448_().m_20270_((Entity)this.f_26135_) <= 1.0f) {
            if (this.f_26135_.m_5448_() instanceof Player) {
                ((Player)this.f_26135_.m_5448_()).m_7023_(new Vec3(0.0, 2.0, 0.0));
            }
            this.f_26135_.m_5448_().m_20334_(0.0, 1.2, 0.0);
            this.f_26135_.m_5448_().m_6469_(this.f_26135_.m_5448_().m_269291_().m_269425_(), 2.0f);
        } else {
            EntityHelper.setState((Entity)this.f_26135_, 0);
        }
    }

    public void useArmor(MarluxiaEntity entity, boolean ignoreRestriction) {
        if (this.armorUses < 3 || ignoreRestriction) {
            this.armorTicks = 0;
            EntityHelper.setState((Entity)entity, 1);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2000, 200));
            ++this.armorUses;
        }
    }

    public void removeArmor(MarluxiaEntity entity) {
        EntityHelper.setState((Entity)entity, 0);
        entity.m_21195_(MobEffects.f_19619_);
    }

    public void useTP(MarluxiaEntity entity) {
        EntityHelper.setState((Entity)entity, 2);
        this.tpTicks = 0;
    }

    public void m_8056_() {
        EntityHelper.setState((Entity)this.f_26135_, 0);
        this.f_26135_.m_20331_(false);
    }

    private boolean isArmored() {
        return EntityHelper.getState((Entity)this.f_26135_) == 1;
    }

    private boolean isTeleporting() {
        return EntityHelper.getState((Entity)this.f_26135_) == 2;
    }

    private boolean isChasing() {
        return EntityHelper.getState((Entity)this.f_26135_) == 3;
    }

    public boolean m_8036_() {
        return this.f_26135_.m_5448_() != null;
    }
}

