/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.epicfight.skills;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ComboExtender
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("a42e0198-fdbc-11eb-9a03-0242ac130003");
    private final RegistryObject<SkillDataKey<Integer>> combo = SkillDataKeys.COMBO_COUNTER;
    public static final DeferredRegister<SkillDataKey<?>> DATA_KEYS = DeferredRegister.create((ResourceLocation)new ResourceLocation("epicfight", "skill_data_keys"), (String)"kingdomkeys");
    public static final RegistryObject<SkillDataKey<Integer>> FINISHER_DATA = DATA_KEYS.register("finisher_data", () -> SkillDataKey.createIntKey((int)0, (boolean)false, (Class[])new Class[]{ComboExtender.class}));
    private int numberOfNegativeCombo = 0;
    private int numberOfComboPlus = 0;
    private int numberOfFinishingPlus = 0;
    private int totalComboOffset = 0;
    private int finisherPlacement = 0;
    private final int lastBasicAttackFromEnd = 4;

    public ComboExtender(Skill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerPatch pp = container.getExecuter();
        if (!pp.isLogicalClient()) {
            PlayerEventListener listener = container.getExecuter().getEventListener();
            listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
                PlayerPatch spp = container.getExecuter();
                Player player = (Player)spp.getOriginal();
                if (player.m_20096_() && !player.m_20142_() && event.getSkillContainer().getSkill() == EpicFightSkills.BASIC_ATTACK) {
                    AnimationProvider attackMotion;
                    if (!this.isExecutableState(spp)) {
                        return;
                    }
                    IPlayerCapabilities playerCapabilities = ModCapabilities.getPlayer(player);
                    event.setCanceled(true);
                    this.numberOfComboPlus = playerCapabilities.getNumberOfAbilitiesEquipped("kingdomkeys:ability_combo_plus");
                    this.numberOfNegativeCombo = playerCapabilities.getNumberOfAbilitiesEquipped("kingdomkeys:ability_negative_combo");
                    this.numberOfFinishingPlus = playerCapabilities.getNumberOfAbilitiesEquipped("kingdomkeys:ability_finishing_plus");
                    this.totalComboOffset = this.numberOfComboPlus - this.numberOfNegativeCombo;
                    CapabilityItem cap = spp.getHoldingItemCapability(InteractionHand.MAIN_HAND);
                    List combo = cap.getAutoAttckMotion(spp);
                    SkillDataManager dataManager = spp.getSkill(EpicFightSkills.BASIC_ATTACK).getDataManager();
                    int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)this.combo.get());
                    int comboSize = combo.size();
                    if (comboSize - 4 + this.totalComboOffset < 0) {
                        this.totalComboOffset -= comboSize - 4 + this.totalComboOffset;
                    }
                    if (comboCounter >= comboSize - 4 + this.totalComboOffset) {
                        SkillDataManager finishDataManager = spp.getSkill((Skill)this).getDataManager();
                        if (finishDataManager.getDataValue((SkillDataKey)FINISHER_DATA.get()) == null) {
                            container.getDataManager().registerData((SkillDataKey)FINISHER_DATA.get());
                            container.getDataManager().setData((SkillDataKey)FINISHER_DATA.get(), (Object)0);
                        }
                        this.finisherPlacement = (Integer)finishDataManager.getDataValue((SkillDataKey)FINISHER_DATA.get());
                        int finisher = this.finisherPlacement % 2 + (comboSize - 4);
                        if (comboCounter >= comboSize - 4 + this.totalComboOffset + this.numberOfFinishingPlus) {
                            comboCounter = 0;
                            this.finisherPlacement = 0;
                        } else {
                            ++comboCounter;
                            ++this.finisherPlacement;
                        }
                        attackMotion = (AnimationProvider)combo.get(finisher);
                        finishDataManager.setData((SkillDataKey)FINISHER_DATA.get(), (Object)this.finisherPlacement);
                    } else {
                        attackMotion = (AnimationProvider)combo.get(comboCounter % (comboSize - 4));
                        ++comboCounter;
                    }
                    if (attackMotion != null) {
                        spp.playAnimationSynchronized(attackMotion.get(), 0.0f);
                    }
                    dataManager.setData((SkillDataKey)this.combo.get(), (Object)comboCounter);
                    spp.updateEntityState();
                }
            });
        }
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_5833_() && !executer.isInAir() && playerState.canBasicAttack();
    }
}

