/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.jei;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class TextDrawable
implements IDrawable {
    Component text;
    List<String> lines;
    int colour;

    public TextDrawable(Component text) {
        this(text, 0xFFFFFF);
    }

    public TextDrawable(Component text, int colour) {
        this.text = text;
        this.lines = Arrays.stream(text.getString().split("\\n")).toList();
        this.colour = colour;
    }

    public void draw(@NotNull GuiGraphics guiGraphics) {
        this.draw(guiGraphics, 0, 0);
    }

    public int getWidth() {
        int width = 0;
        for (String line : this.lines) {
            width = Math.max(width, Minecraft.m_91087_().f_91062_.m_92895_(line));
        }
        return Math.min(width, 120);
    }

    public int getHeight() {
        int lineCount = this.lines.size();
        for (String line : this.lines) {
            int wrappedLines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)line), this.getWidth()).size();
            if (wrappedLines <= 1) continue;
            lineCount += wrappedLines - 1;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 * lineCount;
    }

    public void draw(@NotNull GuiGraphics guiGraphics, int xOffset, int yOffset) {
        for (String line : this.lines) {
            yOffset = this.drawWordWrap(guiGraphics, (FormattedText)Component.m_237115_((String)line), xOffset, yOffset, this.getWidth(), this.colour);
        }
    }

    public int drawWordWrap(GuiGraphics guiGraphics, FormattedText pText, int pX, int pY, int pLineWidth, int pColor) {
        for (FormattedCharSequence formattedcharsequence : Minecraft.m_91087_().f_91062_.m_92923_(pText, pLineWidth)) {
            guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, formattedcharsequence, pX, pY, pColor, true);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            pY += 9;
        }
        return pY;
    }
}

