/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.BaseArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorMaterial;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KeybladeArmorItem
extends BaseArmorItem {
    public KeybladeArmorItem(KKArmorMaterial materialIn, ArmorItem.Type slot, String textureName) {
        super(materialIn, slot, textureName);
    }

    @Override
    @Nonnull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "kingdomkeys:textures/models/armor/empty.png";
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemStack droppedItem;
            UUID droppedID;
            if (event.getEntity() instanceof ItemEntity && (droppedID = Utils.getArmorID(droppedItem = ((ItemEntity)event.getEntity()).m_32055_())) != null && droppedItem.m_41720_() instanceof ArmorItem) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                for (ItemStack armour : player.m_6168_()) {
                    Item item = armour.m_41720_();
                    if (!(item instanceof ArmorItem)) continue;
                    ArmorItem armorItem = (ArmorItem)item;
                    if (!Utils.hasArmorID(armour)) continue;
                    ModCapabilities.getPlayer(player).getEquippedKBArmor(0).getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        IItemHandlerModifiable pauldronInventory = (IItemHandlerModifiable)iItemHandler;
                        switch (armorItem.m_266204_()) {
                            case HELMET: {
                                pauldronInventory.setStackInSlot(0, armour);
                                break;
                            }
                            case CHESTPLATE: {
                                pauldronInventory.setStackInSlot(1, armour);
                                break;
                            }
                            case LEGGINGS: {
                                pauldronInventory.setStackInSlot(2, armour);
                                break;
                            }
                            case BOOTS: {
                                pauldronInventory.setStackInSlot(3, armour);
                            }
                        }
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    });
                }
            }
        }

        @SubscribeEvent
        public static void onItemToss(ItemTossEvent event) {
            Item item = event.getEntity().m_32055_().m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                ItemStack droppedItem = event.getEntity().m_32055_();
                if (Utils.hasArmorID(droppedItem)) {
                    ModCapabilities.getPlayer(event.getPlayer()).getEquippedKBArmor(0).getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        IItemHandlerModifiable pauldronInventory = (IItemHandlerModifiable)iItemHandler;
                        switch (armorItem.m_266204_()) {
                            case HELMET: {
                                pauldronInventory.setStackInSlot(0, droppedItem);
                                break;
                            }
                            case CHESTPLATE: {
                                pauldronInventory.setStackInSlot(1, droppedItem);
                                break;
                            }
                            case LEGGINGS: {
                                pauldronInventory.setStackInSlot(2, droppedItem);
                                break;
                            }
                            case BOOTS: {
                                pauldronInventory.setStackInSlot(3, droppedItem);
                            }
                        }
                        event.getPlayer().m_9236_().m_6263_(null, event.getPlayer().m_20182_().m_7096_(), event.getPlayer().m_20182_().m_7098_(), event.getPlayer().m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    });
                }
            }
        }
    }
}

