/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.leveling.Level;
import online.kingdomkeys.kingdomkeys.leveling.ModLevels;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;

public enum SoAState {
    NONE(0),
    CHOICE(1),
    SACRIFICE(2),
    CONFIRM(3),
    COMPLETE(4),
    WARRIOR(5),
    GUARDIAN(6),
    MYSTIC(7);

    private final byte b;

    private SoAState(byte b) {
        this.b = b;
    }

    public byte get() {
        return this.b;
    }

    private boolean Compare(byte b) {
        return this.b == b;
    }

    public static SoAState fromByte(byte b) {
        SoAState[] values = SoAState.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].Compare(b)) continue;
            return values[i];
        }
        return NONE;
    }

    public static void applyStatsForChoices(Player player, IPlayerCapabilities playerData, boolean remove) {
        if (playerData.getSoAState() == COMPLETE) {
            SoAState sacrifice;
            SoAState choice = !remove ? playerData.getChosen() : playerData.getSacrificed();
            SoAState soAState = sacrifice = !remove ? playerData.getSacrificed() : playerData.getChosen();
            if (remove) {
                KingdomKeys.LOGGER.info("Removing old choice? " + String.valueOf((Object)sacrifice));
                SoAState.removeNonStatsData((Level)ModLevels.registry.get().getValue(new ResourceLocation("kingdomkeys:" + sacrifice.toString().toLowerCase())), playerData);
                KingdomKeys.LOGGER.info(playerData.getAbilityMap());
                playerData.getStrengthStat().removeModifier("choice");
                playerData.getMagicStat().removeModifier("choice");
                playerData.getDefenseStat().removeModifier("choice");
                playerData.getMaxAPStat().removeModifier("choice");
                playerData.getStrengthStat().removeModifier("sacrifice");
                playerData.getMagicStat().removeModifier("sacrifice");
                playerData.getDefenseStat().removeModifier("sacrifice");
                playerData.getMaxAPStat().removeModifier("sacrifice");
                playerData.setSoAState(NONE);
            } else {
                Level choiceData = (Level)ModLevels.registry.get().getValue(new ResourceLocation("kingdomkeys:" + choice.toString().toLowerCase()));
                Level sacrificeData = (Level)ModLevels.registry.get().getValue(new ResourceLocation("kingdomkeys:" + sacrifice.toString().toLowerCase()));
                SoAState.addForChoice(1, choiceData, playerData);
                SoAState.addForChoice(0, sacrificeData, playerData);
            }
        }
    }

    public static void addForChoice(int choiceLevel, Level choice, IPlayerCapabilities playerData) {
        Object a;
        String modifier = "choice";
        if (choiceLevel == 0) {
            modifier = "sacrifice";
        }
        if (choice.getStr(choiceLevel) != 0) {
            playerData.getStrengthStat().addModifier(modifier, choice.getStr(choiceLevel), false, false);
        }
        if (choice.getMag(choiceLevel) != 0) {
            playerData.getMagicStat().addModifier(modifier, choice.getMag(choiceLevel), false, false);
        }
        if (choice.getDef(choiceLevel) != 0) {
            playerData.getDefenseStat().addModifier(modifier, choice.getDef(choiceLevel), false, false);
        }
        if (choice.getMaxAP(choiceLevel) != 0) {
            playerData.getMaxAPStat().addModifier(modifier, choice.getMaxAP(choiceLevel), false, false);
        }
        if (choice.getMaxHp(choiceLevel) > 0) {
            playerData.addMaxHP(choice.getMaxHp(choiceLevel));
        }
        if (choice.getMaxMp(choiceLevel) > 0) {
            playerData.addMaxMP(choice.getMaxMp(choiceLevel));
        }
        if (choice.getAbilities(choiceLevel).length > 0) {
            for (String ability : choice.getAbilities(choiceLevel)) {
                if (ability == null || (a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))) == null) continue;
                playerData.addAbility(ability, true);
            }
        }
        if (choice.getShotlocks(choiceLevel).length > 0) {
            for (String shotlock : choice.getShotlocks(choiceLevel)) {
                if (shotlock == null || (a = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlock))) == null) continue;
                playerData.addShotlockToList(shotlock, true);
            }
        }
        if (choice.getSpells(choiceLevel).length > 0) {
            for (String magic : choice.getSpells(choiceLevel)) {
                Magic magicInstance;
                if (magic == null || (magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magic))) == null || playerData == null || playerData.getMagicsMap() == null) continue;
                if (!playerData.getMagicsMap().containsKey(magic)) {
                    playerData.setMagicLevel(new ResourceLocation(magic), playerData.getMagicLevel(new ResourceLocation(magic)), true);
                    continue;
                }
                playerData.setMagicLevel(new ResourceLocation(magic), playerData.getMagicLevel(new ResourceLocation(magic)) + 1, true);
            }
        }
        if (choice.getMaxAccessories(choiceLevel) != 0) {
            playerData.addMaxAccessories(choice.getMaxAccessories(choiceLevel));
        }
        if (choice.getMaxArmors(choiceLevel) != 0) {
            playerData.addMaxArmors(choice.getMaxArmors(choiceLevel));
        }
    }

    public static void removeNonStatsData(Level levelData, IPlayerCapabilities playerData) {
        Magic magicInstance;
        Object a;
        if (levelData.getAbilities(0).length > 0) {
            for (String ability : levelData.getAbilities(0)) {
                if (ability == null || (a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))) == null) continue;
                playerData.removeAbility(ability);
            }
        }
        if (levelData.getShotlocks(0).length > 0) {
            for (String shotlock : levelData.getShotlocks(0)) {
                if (shotlock == null || (a = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlock))) == null) continue;
                playerData.removeShotlockFromList(shotlock);
            }
        }
        if (levelData.getSpells(0).length > 0) {
            for (String magic : levelData.getSpells(0)) {
                if (magic == null || (magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magic))) == null || playerData == null || playerData.getMagicsMap() == null || !playerData.getMagicsMap().containsKey(magic)) continue;
                playerData.setMagicLevel(new ResourceLocation(magic), playerData.getMagicLevel(new ResourceLocation(magic)) - 1, true);
            }
        }
        if (levelData.getAbilities(1).length > 0) {
            for (String ability : levelData.getAbilities(1)) {
                if (ability == null || (a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))) == null) continue;
                playerData.removeAbility(ability);
            }
        }
        if (levelData.getShotlocks(1).length > 0) {
            for (String shotlock : levelData.getShotlocks(1)) {
                if (shotlock == null || (a = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlock))) == null) continue;
                playerData.removeShotlockFromList(shotlock);
            }
        }
        if (levelData.getSpells(1).length > 0) {
            for (String magic : levelData.getSpells(1)) {
                if (magic == null || (magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magic))) == null || playerData == null || playerData.getMagicsMap() == null || !playerData.getMagicsMap().containsKey(magic)) continue;
                playerData.setMagicLevel(new ResourceLocation(magic), playerData.getMagicLevel(new ResourceLocation(magic)) - 1, true);
            }
        }
    }
}

