/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateSavePoints;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record CSCreateSavePoint(BlockPos tileEntity, String name, UUID owner, String ownerName, boolean global) {
    public CSCreateSavePoint(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.m_130277_(), buf.m_130259_(), buf.m_130277_(), buf.readBoolean());
    }

    public CSCreateSavePoint(SavepointTileEntity tileEntity, String name, Player player, boolean global) {
        this(tileEntity.m_58899_(), name, player.m_36316_().getId(), player.m_36316_().getName(), global);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.tileEntity);
        buf.m_130070_(this.name);
        buf.m_130077_(this.owner);
        buf.m_130070_(this.ownerName);
        buf.writeBoolean(this.global);
    }

    public static void handle(CSCreateSavePoint message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.m_9236_();
            SavePointStorage storage = SavePointStorage.getStorage(player.f_8924_);
            SavepointTileEntity te = (SavepointTileEntity)level.m_7702_(message.tileEntity);
            storage.addSavePoint(new SavePointStorage.SavePoint(te.getID(), (SavePointStorage.SavePointType)((Object)((Object)te.m_58900_().m_61143_(SavePointBlock.TIER))), message.name, te.m_58899_(), (Pair<UUID, String>)Pair.of((Object)message.owner, (Object)message.ownerName), (ResourceKey<Level>)level.m_46472_(), message.global, Instant.now()));
            if (!message.global) {
                ModCapabilities.getPlayer((Player)player).addDiscoveredSavePoint(te.getID(), Instant.now());
            }
            MinecraftServer server = level.m_7654_();
            Iterable levels = server.m_129785_();
            for (Level level1 : levels) {
                for (Player playerFromList : level1.m_6907_()) {
                    PacketHandler.sendTo(new SCUpdateSavePoints(SavePointStorage.getStorage(server).getDiscoveredSavePoints(playerFromList)), (ServerPlayer)playerFromList);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

