/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSSummonArmor {
    boolean forceDesummon;

    public CSSummonArmor() {
        this.forceDesummon = false;
    }

    public CSSummonArmor(boolean forceDesummon) {
        this.forceDesummon = forceDesummon;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.forceDesummon);
    }

    public static CSSummonArmor decode(FriendlyByteBuf buffer) {
        CSSummonArmor msg = new CSSummonArmor();
        msg.forceDesummon = buffer.readBoolean();
        return msg;
    }

    public static void handle(CSSummonArmor message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            ItemStack kbArmorItem = playerData.getEquippedKBArmor(0);
            IItemHandler iItemHandler = (IItemHandler)kbArmorItem.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            int checkSlots = iItemHandler.getSlots();
            for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                if (!iItemHandler.getStackInSlot(i).m_41619_()) continue;
                --checkSlots;
            }
            if (kbArmorItem.m_41720_() == Items.f_41852_) {
                return;
            }
            Item patt2213$temp = kbArmorItem.m_41720_();
            if (patt2213$temp instanceof PauldronItem) {
                PauldronItem kbArmor = (PauldronItem)patt2213$temp;
                UUID KBArmorUUID = kbArmorItem.m_41783_().m_128342_("armorID");
                ItemStack[] armor = new ItemStack[]{player.m_150109_().m_36052_(3), player.m_150109_().m_36052_(2), player.m_150109_().m_36052_(1), player.m_150109_().m_36052_(0)};
                int correctArmor = 0;
                for (ItemStack stack : armor) {
                    if (stack.m_41720_() == Items.f_41852_ || !Utils.hasArmorID(stack) || !Utils.getArmorID(stack).equals(KBArmorUUID)) continue;
                    ++correctArmor;
                }
                boolean hasRoom = true;
                if (message.forceDesummon) {
                    CSSummonArmor.checkAllArmorSlots((Player)player, KBArmorUUID, playerData);
                } else if (correctArmor == checkSlots) {
                    for (int i = 36; i < 40; ++i) {
                        Utils.desummonArmour(playerData, (Player)player, player.m_150109_().m_8020_(i), i, true, false);
                    }
                    player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
                } else {
                    if (armor[0].m_41720_() != Items.f_41852_ || armor[1].m_41720_() != Items.f_41852_ || armor[2].m_41720_() != Items.f_41852_ || armor[3].m_41720_() != Items.f_41852_) {
                        int i;
                        if (CSSummonArmor.checkAllArmorSlots((Player)player, KBArmorUUID, playerData)) {
                            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
                        }
                        armor = new ItemStack[]{player.m_150109_().m_36052_(3), player.m_150109_().m_36052_(2), player.m_150109_().m_36052_(1), player.m_150109_().m_36052_(0)};
                        int otherArmor = 0;
                        for (i = 0; i < armor.length; ++i) {
                            if (armor[i].m_41720_() == Items.f_41852_) continue;
                            ++otherArmor;
                        }
                        if (Utils.getFreeSlotsForPlayer((Player)player) >= otherArmor) {
                            for (i = 0; i < armor.length; ++i) {
                                if (armor[i].m_41720_() == Items.f_41852_) continue;
                                Utils.swapStack(player.m_150109_(), player.m_150109_().m_36062_(), 39 - i);
                            }
                        } else {
                            hasRoom = false;
                        }
                        if ((armor = new ItemStack[]{player.m_150109_().m_36052_(3), player.m_150109_().m_36052_(2), player.m_150109_().m_36052_(1), player.m_150109_().m_36052_(0)})[0].m_41720_() != Items.f_41852_ || armor[1].m_41720_() != Items.f_41852_ || armor[2].m_41720_() != Items.f_41852_ || armor[3].m_41720_() != Items.f_41852_) {
                            player.m_5661_((Component)Component.m_237115_((String)"gui.summonarmor.notenoughspace"), true);
                        }
                    }
                    if (hasRoom) {
                        ItemStack newHelmet = CSSummonArmor.getNewItemWithUUID(iItemHandler.getStackInSlot(0), KBArmorUUID);
                        ItemStack newChestplate = CSSummonArmor.getNewItemWithUUID(iItemHandler.getStackInSlot(1), KBArmorUUID);
                        ItemStack newLeggings = CSSummonArmor.getNewItemWithUUID(iItemHandler.getStackInSlot(2), KBArmorUUID);
                        ItemStack newBoots = CSSummonArmor.getNewItemWithUUID(iItemHandler.getStackInSlot(3), KBArmorUUID);
                        player.m_150109_().m_6836_(39, newHelmet);
                        player.m_150109_().m_6836_(38, newChestplate);
                        player.m_150109_().m_6836_(37, newLeggings);
                        player.m_150109_().m_6836_(36, newBoots);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
                        CSSummonArmor.spawnArmorParticles((Player)player);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean checkAllArmorSlots(Player player, UUID KBArmorUUID, IPlayerCapabilities playerData) {
        boolean unequipped = false;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(36, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(37, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(38, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(39, player, KBArmorUUID, playerData) || unequipped;
        return unequipped;
    }

    private static boolean checkAndEmptyArmorSlot(int i, Player player, UUID KBArmorUUID, IPlayerCapabilities playerData) {
        if (Utils.hasArmorID(player.m_150109_().m_8020_(i)) && Utils.getArmorID(player.m_150109_().m_8020_(i)).equals(KBArmorUUID)) {
            Utils.desummonArmour(playerData, player, player.m_150109_().m_8020_(i), i, true, false);
            return true;
        }
        return false;
    }

    private static ItemStack getNewItemWithUUID(ItemStack item, UUID uuid) {
        ItemStack newItem = item.m_41777_();
        newItem.m_41721_(item.m_41773_());
        if (!item.m_41619_()) {
            if (newItem.m_41783_() == null) {
                newItem.m_41751_(new CompoundTag());
            }
            newItem.m_41783_().m_128362_("armorID", uuid);
        }
        return newItem;
    }

    private static void spawnArmorParticles(Player summoner) {
        Vec3 userPos = new Vec3(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_());
        ((ServerLevel)summoner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, userPos.f_82479_, summoner.m_20186_() + 1.0, userPos.f_82481_, 300, 0.0, 0.0, 0.0, 0.2);
    }
}

