/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class CSUseShortcutPacket {
    int index;
    int lockOnTarget;

    public CSUseShortcutPacket() {
    }

    public CSUseShortcutPacket(int index, LivingEntity lockOnTarget) {
        this.index = index;
        this.lockOnTarget = lockOnTarget == null ? -1 : lockOnTarget.m_19879_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.index);
        buffer.writeInt(this.lockOnTarget);
    }

    public static CSUseShortcutPacket decode(FriendlyByteBuf buffer) {
        CSUseShortcutPacket msg = new CSUseShortcutPacket();
        msg.index = buffer.readInt();
        msg.lockOnTarget = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseShortcutPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            IGlobalCapabilities globalData = ModCapabilities.getGlobal((LivingEntity)player);
            if (playerData == null || globalData == null) {
                return;
            }
            if (playerData.getMagicCooldownTicks() <= 0 && !playerData.getRecharge() && !playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") && !globalData.isKO() && playerData.getShortcutsMap().containsKey(message.index)) {
                String[] data = playerData.getShortcutsMap().get(message.index).split(",");
                String magicName = data[0];
                int level = Integer.parseInt(data[1]);
                Magic magic = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magicName));
                double cost = magic.getCost(level, (Player)player);
                if (!(playerData.getMaxMP() == 0.0 || playerData.getRecharge() || cost > playerData.getMaxMP() && cost < 300.0 || cost < 300.0 && cost >= playerData.getMP() && playerData.isAbilityEquipped("kingdomkeys:ability_mp_safety") || playerData.getMagicCooldownTicks() > 0)) {
                    magic.onUse((Player)player, (Player)player, level, (LivingEntity)player.m_9236_().m_6815_(message.lockOnTarget));
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

