/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;

public class ShopListDataDeserializer
implements JsonDeserializer<ShopList> {
    public ShopList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ShopList out = new ShopList();
        JsonArray jsonArray = json.getAsJsonArray();
        boolean setNames = false;
        for (JsonElement e : jsonArray) {
            ShopItem shopItem = new ShopItem();
            JsonObject jsonObj = e.getAsJsonObject();
            if (jsonObj.get("names") != null && !setNames) {
                ResourceLocation namesPath = new ResourceLocation(jsonObj.get("names").getAsString());
                if (NamesListRegistry.getInstance().containsKey(namesPath)) {
                    out.setNames(namesPath);
                }
                setNames = true;
                continue;
            }
            boolean valid = jsonObj.get("item") != null && jsonObj.get("amount") != null;
            if (!valid) continue;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObj.get("item").getAsString()));
            shopItem.setResult(item, jsonObj.get("amount").getAsInt());
            shopItem.setTier(jsonObj.get("tier").getAsInt());
            shopItem.setCost(jsonObj.get("cost").getAsInt());
            out.addToList(shopItem);
        }
        return out;
    }
}

