/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.client.render;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.petemc.zombifiedplayer.Config;
import net.petemc.zombifiedplayer.ZombifiedPlayer;
import net.petemc.zombifiedplayer.client.render.ZombificationFeatureRenderer;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ZombifiedPlayerRenderer
extends AbstractZombieRenderer<ZombifiedPlayerEntity, ZombieModel<ZombifiedPlayerEntity>> {
    private static ResourceLocation TEXTURE_FALLBACK = new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
    private static GameProfile receivedGameProfile = null;
    private static GameProfile inProgress = null;
    private boolean gameProfileReceived = false;
    private final int counterSteps = 40;
    private final int maxSubTries = 5;
    private final int maxTotalTries = 5;
    private final int counterMax = 2200;
    private int counter = 2200;
    private int totalTries = 0;

    public ZombifiedPlayerRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new ZombieModel(ctx.m_174023_(ModelLayers.f_171223_)), new ZombieModel(ctx.m_174023_(ModelLayers.f_171226_)), new ZombieModel(ctx.m_174023_(ModelLayers.f_171227_)));
        this.m_115326_(new ZombificationFeatureRenderer(this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(ZombifiedPlayerEntity entity) {
        if (ZombifiedPlayer.cachedPlayerSkinsByUUID.containsKey(entity.getGameProfile().getId())) {
            return ZombifiedPlayer.cachedPlayerSkinsByUUID.get(entity.getGameProfile().getId());
        }
        if (ZombifiedPlayer.uuidMissmatches.containsKey(entity.getGameProfile().getId()) && (ZombifiedPlayer.cachedPlayerSkinsByName.containsKey(entity.gameProfile.getName()) || ZombifiedPlayer.cachedPlayerSkinsByName.containsKey(entity.gameProfile.getName().toLowerCase()))) {
            return ZombifiedPlayer.cachedPlayerSkinsByUUID.get(ZombifiedPlayer.uuidMissmatches.get(entity.gameProfile.getId()));
        }
        if (entity.getGameProfile() != null) {
            this.getPlayerSkinFromGameProfile(entity.getGameProfile());
        }
        return TEXTURE_FALLBACK;
    }

    public void setTexture(ResourceLocation id) {
        TEXTURE_FALLBACK = id;
    }

    public void getPlayerSkinFromGameProfile(GameProfile profile) {
        try {
            if (inProgress == null) {
                inProgress = profile;
            }
            if (!inProgress.getId().equals(profile.getId())) {
                return;
            }
            if (this.counter % 40 == 0 && this.counter > 2000 && this.totalTries < 5) {
                if (receivedGameProfile == null) {
                    if (this.counter == 2200) {
                        ZombifiedPlayer.LOGGER.info("Trying to get GameProfile for {} UUID: {}", (Object)profile.getName(), (Object)profile.getId());
                    }
                    SkullBlockEntity.m_155738_((GameProfile)profile, owner -> {
                        receivedGameProfile = owner;
                    });
                }
                if (!this.gameProfileReceived && receivedGameProfile != null) {
                    ZombifiedPlayer.LOGGER.info("Successfully received GameProfile for {}, UUID: {}", (Object)receivedGameProfile.getName(), (Object)receivedGameProfile.getId());
                    this.counter = 2200;
                    this.totalTries = 0;
                    this.gameProfileReceived = true;
                }
                if (receivedGameProfile != null) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    ResourceLocation skinTexture = null;
                    skinTexture = minecraft.m_91109_().m_240306_(receivedGameProfile);
                    if (skinTexture != null) {
                        if (!receivedGameProfile.getId().equals(profile.getId())) {
                            ZombifiedPlayer.LOGGER.info("The zombified player for {} has a different UUID, using random default skin!", (Object)receivedGameProfile.getName());
                            ZombifiedPlayer.uuidMissmatches.put(profile.getId(), receivedGameProfile.getId());
                            ZombifiedPlayer.cachedPlayerSkinsByName.put(receivedGameProfile.getName(), skinTexture);
                        }
                        ZombifiedPlayer.cachedPlayerSkinsByUUID.put(receivedGameProfile.getId(), skinTexture);
                        ZombifiedPlayer.LOGGER.info("Successfully received Skin for {}, UUID: {}", (Object)receivedGameProfile.getName(), (Object)receivedGameProfile.getId());
                        ZombifiedPlayer.LOGGER.info("Skin Texture: {}", (Object)skinTexture);
                        this.counter = 2200;
                        this.totalTries = 0;
                        receivedGameProfile = null;
                        inProgress = null;
                        this.gameProfileReceived = false;
                        return;
                    }
                    ZombifiedPlayer.LOGGER.warn("No valid Skin was received for {} yet", (Object)receivedGameProfile.getName());
                }
            }
            if (this.counter > 0) {
                --this.counter;
            } else {
                this.counter = 2200;
                ++this.totalTries;
                if (this.totalTries == 4) {
                    if (Config.getLimitSkinFetchTries()) {
                        ZombifiedPlayer.LOGGER.warn("Could not fetch a valid Skin for {}, will stop trying.", (Object)profile.getName());
                    } else {
                        this.totalTries = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

