/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.entity;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.petemc.zombifiedplayer.Config;
import net.petemc.zombifiedplayer.entity.ModEntities;
import org.jetbrains.annotations.NotNull;

public class ZombifiedPlayerEntity
extends Zombie
implements IEntityAdditionalSpawnData {
    public GameProfile gameProfile;
    public final NonNullList<ItemStack> main = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);

    public ZombifiedPlayerEntity(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_34328_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, Config.getMakeTheZombifiedPlayersStronger() ? 40.0 : 20.0).m_22268_(Attributes.f_22277_, Config.getMakeTheZombifiedPlayersStronger() ? 50.0 : 40.0).m_22268_(Attributes.f_22279_, Config.getMakeTheZombifiedPlayersStronger() ? (double)0.29f : (double)0.23f).m_22268_(Attributes.f_22281_, Config.getMakeTheZombifiedPlayersStronger() ? 4.0 : 2.0).m_22268_(Attributes.f_22284_, Config.getMakeTheZombifiedPlayersStronger() ? 4.0 : 2.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::m_34330_));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_5825_() {
        return Config.getMakeTheZombifiedPlayersImmuneToFire();
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean m_34330_() {
        return Config.getZombifiedPlayersCanBreakDoors();
    }

    protected boolean m_7593_() {
        return false;
    }

    public void m_7572_() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22287_)).m_22100_(0.0);
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    protected void m_7472_(@NotNull DamageSource pDamageSource, int pLooting, boolean pHitByPlayer) {
        super.m_7472_(pDamageSource, pLooting, pHitByPlayer);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            this.m_19983_(itemStack);
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
        this.dropInventory();
    }

    public void dropInventory() {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).m_41619_()) continue;
            this.m_19983_((ItemStack)this.main.get(i));
            this.main.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public static ZombifiedPlayerEntity spawnZombifiedPlayer(Player player) {
        ZombifiedPlayerEntity zombifiedPlayer = null;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            zombifiedPlayer = new ZombifiedPlayerEntity((EntityType<? extends Zombie>)((EntityType)ModEntities.ZOMBIFIED_PLAYER.get()), (Level)serverLevel);
            zombifiedPlayer.setGameProfile(player.m_36316_());
            MutableComponent name = Component.m_237113_((String)("Zombified " + player.m_7755_().getString()));
            zombifiedPlayer.m_6593_((Component)name);
            zombifiedPlayer.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            zombifiedPlayer.m_21530_();
            zombifiedPlayer.transferInventory(player);
            serverLevel.m_7967_((Entity)zombifiedPlayer);
        }
        return zombifiedPlayer;
    }

    public void transferInventory(Player playerEntity) {
        int i;
        if (EnchantmentHelper.m_44924_((ItemStack)playerEntity.m_21205_())) {
            playerEntity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        } else if (Config.getTransferMainandOffHandToZombifiedPlayer()) {
            this.m_21008_(InteractionHand.MAIN_HAND, playerEntity.m_21205_().m_278832_());
        }
        if (EnchantmentHelper.m_44924_((ItemStack)playerEntity.m_21206_())) {
            playerEntity.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        } else if (Config.getTransferMainandOffHandToZombifiedPlayer()) {
            this.m_21008_(InteractionHand.OFF_HAND, playerEntity.m_21206_().m_278832_());
        }
        for (i = 0; i < 4; ++i) {
            if (EnchantmentHelper.m_44924_((ItemStack)((ItemStack)playerEntity.m_150109_().f_35975_.get(i)))) {
                playerEntity.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            if (!Config.getTransferArmorToZombifiedPlayer()) continue;
            this.m_255207_(((ItemStack)playerEntity.m_150109_().f_35975_.get(i)).m_278832_());
        }
        for (i = 0; i < playerEntity.m_150109_().f_35974_.size(); ++i) {
            if (((ItemStack)playerEntity.m_150109_().f_35974_.get(i)).m_41619_()) continue;
            if (EnchantmentHelper.m_44924_((ItemStack)((ItemStack)playerEntity.m_150109_().f_35974_.get(i)))) {
                playerEntity.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
                this.main.set(i, (Object)ItemStack.f_41583_);
            }
            if (!Config.getTransferInventoryToZombifiedPlayer()) continue;
            this.main.set(i, (Object)((ItemStack)playerEntity.m_150109_().f_35974_.get(i)).m_278832_());
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.gameProfile != null) {
            buffer.m_130077_(this.gameProfile.getId());
            buffer.m_130070_(this.gameProfile.getName());
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        try {
            UUID playerUUID = additionalData.m_130259_();
            String playerName = additionalData.m_130277_();
            this.gameProfile = new GameProfile(playerUUID, playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128362_("gameProfileUUID", this.gameProfile.getId());
        nbt.m_128359_("gameProfileName", this.gameProfile.getName());
        nbt.m_128365_("Inventory", (Tag)this.writeInventoryToNbt(new ListTag()));
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        UUID gpUUID = nbt.m_128342_("gameProfileUUID");
        String gpName = nbt.m_128461_("gameProfileName");
        this.gameProfile = new GameProfile(gpUUID, gpName);
        ListTag nbtList = nbt.m_128437_("Inventory", 10);
        this.readInventoryFromNbt(nbtList);
    }

    public ListTag writeInventoryToNbt(ListTag nbtList) {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)i);
            ((ItemStack)this.main.get(i)).m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        return nbtList;
    }

    public void readInventoryFromNbt(ListTag nbtList) {
        this.main.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (itemStack.m_41619_() || j < 0 || j >= this.main.size()) continue;
            this.main.set(j, (Object)itemStack);
        }
    }
}

