/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.mixin;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.petemc.zombifiedplayer.Config;
import net.petemc.zombifiedplayer.event.PlayerDeathEvents;
import net.petemc.zombifiedplayer.util.ModCompatibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerEntityMixin {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V", shift=At.Shift.AFTER)})
    public void die(DamageSource pCause, CallbackInfo ci) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (Config.getSpawnOnAnyDeath() || ModCompatibility.diedFromInfection(serverPlayer) && Config.getSpawnWhenKilledByInfection() || PlayerDeathEvents.attackerIsUndead(pCause.m_7639_()) && Config.getSpawnZombifiedPlayerAfterDeath()) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"zombifiedplayer.spawn.message"));
            if (Config.getPrintSpawnLocationInChat()) {
                BlockPos blockpos = serverPlayer.m_20097_();
                MutableComponent textCoordinates = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_()})).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockpos.m_123341_() + " " + (blockpos.m_123342_() + 1) + " " + blockpos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                serverPlayer.m_240418_((Component)Component.m_237110_((String)"zombifiedplayer.location.message", (Object[])new Object[]{textCoordinates}), false);
            }
        }
    }
}

