/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.util;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.petemc.zombifiedplayer.util.GameProfileData;
import org.jetbrains.annotations.NotNull;

public class StateSaverAndLoader
extends SavedData {
    public HashMap<UUID, GameProfileData> gameProfiles = new HashMap();

    public static StateSaverAndLoader load(CompoundTag tag) {
        StateSaverAndLoader state = new StateSaverAndLoader();
        CompoundTag gameProfilesNbt = tag.m_128469_("gameProfiles");
        gameProfilesNbt.m_128431_().forEach(key -> {
            GameProfileData gameProfileData = new GameProfileData();
            gameProfileData.gameProfileUUID = gameProfilesNbt.m_128469_(key).m_128342_("gameProfileUUID");
            gameProfileData.gameProfileName = gameProfilesNbt.m_128469_(key).m_128461_("gameProfileName");
            UUID uuid = UUID.fromString(key);
            state.gameProfiles.put(uuid, gameProfileData);
        });
        state.m_77762_();
        return state;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag gameProfilesNbt = new CompoundTag();
        this.gameProfiles.forEach((uuid, gameProfileData) -> {
            CompoundTag gameProfileNbt = new CompoundTag();
            gameProfileNbt.m_128362_("gameProfileUUID", gameProfileData.gameProfileUUID);
            gameProfileNbt.m_128359_("gameProfileName", gameProfileData.gameProfileName);
            gameProfilesNbt.m_128365_(uuid.toString(), (Tag)gameProfileNbt);
        });
        tag.m_128365_("gameProfiles", (Tag)gameProfilesNbt);
        return tag;
    }

    public static StateSaverAndLoader getServerState(MinecraftServer server) {
        return (StateSaverAndLoader)server.m_129783_().m_8895_().m_164861_(StateSaverAndLoader::load, StateSaverAndLoader::new, "zombifiedplayer");
    }

    public static GameProfileData getGameProfileState(UUID zombUuid, Level level) {
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(Objects.requireNonNull(level.m_7654_()));
        return serverState.gameProfiles.computeIfAbsent(zombUuid, uuid -> new GameProfileData());
    }
}

