/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.config;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.ModLists;
import cc.cassian.immersiveoverlays.config.fabric.ModConfigImpl;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public boolean compass_enable = true;
    public int compass_vertical_position = 105;
    public List<String> compass_items = List.of("minecraft:compass", "minecraft:recovery_compass", "spelunkery:magnetic_compass");
    public List<String> compass_depth_items = List.of("spelunkery:depth_gauge", "caverns_and_chasms:depth_gauge", "additionaladditions:depth_meter", "supplementaries:altimeter", "depthmeter:depthmeter");
    public boolean compass_hide_when_similar_mods_present = true;
    public String compass_x_colour = "Red";
    public String compass_y_colour = "Green";
    public String compass_z_colour = "Blue";
    public boolean clock_enable = true;
    public int clock_vertical_position = 90;
    public List<String> clock_items = List.of("minecraft:clock");
    public List<String> clock_weather_items = List.of("caverns_and_chasms:barometer");
    public boolean clock_24_hour = true;
    public boolean require_item_in_hand = false;
    public boolean search_containers = true;
    public boolean render_background = true;
    public boolean align_left = false;
    public boolean moved_by_effects = true;
    public boolean map_atlases = false;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to save config file!");
        }
        ModLists.loadLists();
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static Path configPath() {
        return ModConfigImpl.configPath();
    }
}

