/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.ModLists;
import cc.cassian.immersiveoverlays.ModTags;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6862;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final class_2960 TEXTURE = ModClient.locate("textures/gui/overlay.png");

    public static void renderBackground(class_332 guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int textureOffset, int tooltipSize) {
        if (ModConfig.get().render_background) {
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            guiGraphics.method_25291(TEXTURE, xPlacement - xOffset - 4, yPlacementWithOffset, 0, 0.0f, (float)textureOffset, fontWidth + xOffset + 4, tooltipSize, 256, 256);
            guiGraphics.method_25291(TEXTURE, OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth), yPlacementWithOffset, 0, 197.0f, (float)textureOffset, 3, tooltipSize, 256, 256);
        }
    }

    public static void checkInventoryForOverlays(class_310 minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable) && minecraft.field_1687 != null) {
            OverlayHelpers.checkInventoryForItems((class_1657)minecraft.field_1724);
        }
    }

    public static boolean playerHasPotions(class_1657 player) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        return !player.method_6026().isEmpty();
    }

    public static int moveBy(class_1657 player) {
        boolean hasBeneficial = player.method_6026().stream().anyMatch(p -> ((class_1291)p.method_5579().comp_349()).method_5573());
        boolean hasNegative = player.method_6026().stream().anyMatch(p -> !((class_1291)p.method_5579().comp_349()).method_5573());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean debug(class_310 mc) {
        boolean debug = mc.method_53526().method_53536();
        return debug && (Boolean)mc.field_1690.method_42442().method_41753() == false;
    }

    private static void findImportantContainerContents(class_1799 container) {
        List<class_1799> list = OverlayHelpers.getContainerContents(container).toList();
        for (class_1799 itemStack : list) {
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        class_1792 item = itemStack.method_7909();
        if (ModLists.compass_items.contains(item)) {
            CompassOverlay.showXZ = true;
        }
        if (ModLists.compass_depth_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
    }

    public static void checkInventoryForItems(class_1657 player) {
        CompassOverlay.showXZ = false;
        CompassOverlay.showY = false;
        ClockOverlay.showTime = false;
        ClockOverlay.showWeather = false;
        if (player == null) {
            return;
        }
        if (ModConfig.get().compass_enable || ModConfig.get().clock_enable) {
            class_1661 inventory = player.method_31548();
            class_1799 mainhand = player.method_6047();
            class_1799 offhand = player.method_6079();
            OverlayHelpers.isImportantItem(offhand);
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItem(mainhand);
                if (OverlayHelpers.isContainer(mainhand)) {
                    OverlayHelpers.findImportantContainerContents(mainhand);
                }
            } else {
                OverlayHelpers.checkInventoryForItem(inventory);
            }
            if (OverlayHelpers.isContainer(offhand)) {
                OverlayHelpers.findImportantContainerContents(offhand);
            }
        }
    }

    public static Stream<class_1799> getContainerContents(class_1799 stack) {
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            class_9276 bundleContents = (class_9276)components.method_57829(class_9334.field_49650);
            return bundleContents.method_59707();
        }
        if (components.method_57832(class_9334.field_49622)) {
            class_9288 containerContents = (class_9288)components.method_57829(class_9334.field_49622);
            return containerContents.method_57489();
        }
        return Stream.empty();
    }

    public static boolean isContainer(class_1799 stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_31573(ModTags.CONTAINERS)) {
            return true;
        }
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            return true;
        }
        if (components.method_57832(class_9334.field_49622)) {
            return true;
        }
        return true;
    }

    public static void checkInventoryForItem(class_1661 inventory) {
        OverlayHelpers.checkInventoryForStack(inventory);
    }

    public static boolean checkInventoryForItem(class_1661 inventory, class_6862<class_1792> item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, null) != class_1799.field_8037;
    }

    public static boolean checkInventoryForItem(class_1661 inventory, class_1792 item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != class_1799.field_8037;
    }

    public static void checkInventoryForStack(class_1661 inventory) {
        for (class_1799 stack : inventory.field_7547) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static class_1799 checkInventoryForStack(class_1661 inventory, class_1792 item) {
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_31574(item)) {
                return stack;
            }
            if (item != null && stack.method_31574(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<class_1799> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (class_1799 content : contents) {
                if (item == null || !content.method_31574(item)) continue;
                return content;
            }
        }
        return class_1799.field_8037;
    }

    public static int getPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }
}

