/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.shake;

import it.hurts.octostudios.perception.common.modules.shake.data.EntityShakeSource;
import it.hurts.octostudios.perception.common.modules.shake.data.PositionShakeSource;
import it.hurts.octostudios.perception.common.modules.shake.data.base.ShakeSource;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Shake {
    private static final Random RANDOM = new Random();
    private ShakeSource source;
    private Supplier<Float> radius;
    private Supplier<Float> rotationAmplitude;
    private Supplier<Float> offsetAmplitude;
    private Supplier<Float> fovAmplitude;
    private Supplier<Float> rotationSpeed;
    private Supplier<Float> offsetSpeed;
    private Supplier<Float> fovSpeed;
    private Supplier<Integer> duration;
    private Supplier<Integer> fadeInTime;
    private Supplier<Integer> fadeOutTime;
    @Nullable
    private Supplier<Boolean> removeCondition;
    private UUID uuid;
    private final Vec3 frequency = new Vec3((double)(0.8f + RANDOM.nextFloat() * 0.4f), (double)(0.8f + RANDOM.nextFloat() * 0.4f), (double)(0.8f + RANDOM.nextFloat() * 0.4f));
    private final Vector3f lastTickOffset = new Vector3f();
    private final Vector3f currentTickOffset = new Vector3f();
    private final Vector3f lastTickRotation = new Vector3f();
    private final Vector3f currentTickRotation = new Vector3f();
    private int elapsedTime;

    public static ShakeBuilder builder(ShakeSource source) {
        ShakeBuilder builder = new ShakeBuilder();
        builder.source(source);
        return builder;
    }

    public static ShakeBuilder builder(Entity entity) {
        return Shake.builder(new EntityShakeSource(entity));
    }

    public static ShakeBuilder builder(Vec3 position) {
        return Shake.builder(new PositionShakeSource(position));
    }

    public boolean isFinished() {
        return this.removeCondition == null ? this.elapsedTime >= this.getDuration() : this.getRemoveCondition();
    }

    public void update(Player player) {
        ++this.elapsedTime;
        this.lastTickOffset.set((Vector3fc)this.currentTickOffset);
        this.lastTickRotation.set((Vector3fc)this.currentTickRotation);
        float currentTime = (float)this.elapsedTime / 20.0f;
        float rotationAmplitude = this.getCumulativeRotationAmplitude(player);
        float rotationSpeed = this.getCumulativeRotationSpeed(player);
        if (rotationAmplitude > 0.0f && rotationSpeed > 0.0f) {
            this.currentTickRotation.set((Vector3fc)this.computeRotationForTick(player, rotationAmplitude, rotationSpeed, currentTime));
        } else {
            this.currentTickRotation.set(0.0f, 0.0f, 0.0f);
            this.lastTickRotation.set(0.0f, 0.0f, 0.0f);
        }
        float offsetAmplitude = this.getCumulativeOffsetAmplitude(player);
        float offsetSpeed = this.getCumulativeOffsetSpeed(player);
        if (offsetAmplitude > 0.0f && offsetSpeed > 0.0f) {
            this.currentTickOffset.set((Vector3fc)this.computeOffsetForTick(player, offsetAmplitude, offsetSpeed, currentTime));
        } else {
            this.currentTickOffset.set(0.0f, 0.0f, 0.0f);
            this.lastTickOffset.set(0.0f, 0.0f, 0.0f);
        }
    }

    public Vector3f getShakeOffset(Player player, float partialTicks) {
        float x = Mth.m_14179_((float)partialTicks, (float)this.lastTickOffset.x(), (float)this.currentTickOffset.x());
        float y = Mth.m_14179_((float)partialTicks, (float)this.lastTickOffset.y(), (float)this.currentTickOffset.y());
        float z = Mth.m_14179_((float)partialTicks, (float)this.lastTickOffset.z(), (float)this.currentTickOffset.z());
        return new Vector3f(x, y, z);
    }

    public Vector3f getShakeRotation(Player player, float partialTicks) {
        float x = Mth.m_14179_((float)partialTicks, (float)this.lastTickRotation.x(), (float)this.currentTickRotation.x());
        float y = Mth.m_14179_((float)partialTicks, (float)this.lastTickRotation.y(), (float)this.currentTickRotation.y());
        float z = Mth.m_14179_((float)partialTicks, (float)this.lastTickRotation.z(), (float)this.currentTickRotation.z());
        return new Vector3f(x, y, z);
    }

    public float getShakeFOV(Player player, float partialTicks) {
        return this.getCumulativeFovAmplitude(player);
    }

    private Vector3f computeOffsetForTick(Player player, float amplitude, float speed, float currentTime) {
        double wave = Math.sin(Math.PI * 2 * (double)speed * (double)currentTime);
        Vec3 direction = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0).m_82546_(this.source.getPos()).m_82541_();
        float offsetX = (float)(direction.f_82479_ * (double)amplitude * wave);
        float offsetY = (float)(direction.f_82480_ * (double)amplitude * wave);
        float offsetZ = (float)(direction.f_82481_ * (double)amplitude * wave);
        return new Vector3f(offsetX, offsetY, offsetZ);
    }

    private Vector3f computeRotationForTick(Player player, float amplitude, float speed, float currentTime) {
        Vec3 playerView = player.m_20154_();
        float pitchFactor = (float)playerView.m_82526_(new Vec3(0.0, 1.0, 0.0));
        float yawFactor = (float)playerView.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82526_(this.source.getPos().m_82546_(player.m_20182_()).m_82541_());
        float angleX = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.m_7096_() * (double)currentTime) * amplitude * pitchFactor;
        float angleY = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.m_7098_() * (double)currentTime) * amplitude * yawFactor;
        float angleZ = (float)Math.sin(Math.PI * 2 * (double)speed * this.frequency.m_7094_() * (double)currentTime) * amplitude;
        return new Vector3f(angleX, angleY, angleZ);
    }

    public float getCumulativeRotationAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getRotationAmplitude());
    }

    public float getCumulativeOffsetAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getOffsetAmplitude());
    }

    public float getCumulativeFovAmplitude(Player player) {
        return this.getCumulativeAmplitude(player, this.getFovAmplitude());
    }

    private float getCumulativeAmplitude(Player player, float amplitude) {
        double distance = player.m_20182_().m_82554_(this.source.getPos());
        int duration = this.getDuration();
        float radius = this.getRadius();
        int fadeInTime = this.getFadeInTime();
        int fadeOutTime = this.getFadeOutTime();
        if (distance > (double)radius) {
            return 0.0f;
        }
        float distanceFactor = (float)(1.0 - distance / (double)radius);
        float timeFactor = this.elapsedTime < fadeInTime ? (float)this.elapsedTime / (float)fadeInTime : (this.elapsedTime > duration - fadeOutTime ? (float)(duration - this.elapsedTime) / (float)fadeOutTime : 1.0f);
        return amplitude * distanceFactor * timeFactor;
    }

    public float getCumulativeRotationSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getRotationSpeed());
    }

    public float getCumulativeOffsetSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getOffsetSpeed());
    }

    public float getCumulativeFovSpeed(Player player) {
        return this.getCumulativeSpeed(player, this.getFovSpeed());
    }

    private float getCumulativeSpeed(Player player, float speed) {
        float radius;
        double distance = player.m_20182_().m_82554_(this.source.getPos());
        if (distance > (double)(radius = this.getRadius())) {
            return 0.0f;
        }
        float distanceFactor = (float)(1.0 - distance / (double)radius);
        return speed * distanceFactor;
    }

    public float getRadius() {
        return this.radius.get().floatValue();
    }

    public float getRotationAmplitude() {
        return this.rotationAmplitude.get().floatValue();
    }

    public float getOffsetAmplitude() {
        return this.offsetAmplitude.get().floatValue();
    }

    public float getFovAmplitude() {
        return this.fovAmplitude.get().floatValue();
    }

    public float getRotationSpeed() {
        return this.rotationSpeed.get().floatValue();
    }

    public float getOffsetSpeed() {
        return this.offsetSpeed.get().floatValue();
    }

    public float getFovSpeed() {
        return this.fovSpeed.get().floatValue();
    }

    public int getDuration() {
        return this.duration.get();
    }

    public int getFadeInTime() {
        return this.fadeInTime.get();
    }

    public int getFadeOutTime() {
        return this.fadeOutTime.get() == -1 ? this.getDuration() - this.getFadeInTime() : this.fadeOutTime.get();
    }

    public boolean getRemoveCondition() {
        return this.removeCondition == null || this.removeCondition.get() != false;
    }

    private static Supplier<Boolean> $default$removeCondition() {
        return null;
    }

    private static UUID $default$uuid() {
        return UUID.randomUUID();
    }

    Shake(ShakeSource source, Supplier<Float> radius, Supplier<Float> rotationAmplitude, Supplier<Float> offsetAmplitude, Supplier<Float> fovAmplitude, Supplier<Float> rotationSpeed, Supplier<Float> offsetSpeed, Supplier<Float> fovSpeed, Supplier<Integer> duration, Supplier<Integer> fadeInTime, Supplier<Integer> fadeOutTime, @Nullable Supplier<Boolean> removeCondition, UUID uuid, int elapsedTime) {
        this.source = source;
        this.radius = radius;
        this.rotationAmplitude = rotationAmplitude;
        this.offsetAmplitude = offsetAmplitude;
        this.fovAmplitude = fovAmplitude;
        this.rotationSpeed = rotationSpeed;
        this.offsetSpeed = offsetSpeed;
        this.fovSpeed = fovSpeed;
        this.duration = duration;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.removeCondition = removeCondition;
        this.uuid = uuid;
        this.elapsedTime = elapsedTime;
    }

    public ShakeSource getSource() {
        return this.source;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vec3 getFrequency() {
        return this.frequency;
    }

    public Vector3f getLastTickOffset() {
        return this.lastTickOffset;
    }

    public Vector3f getCurrentTickOffset() {
        return this.currentTickOffset;
    }

    public Vector3f getLastTickRotation() {
        return this.lastTickRotation;
    }

    public Vector3f getCurrentTickRotation() {
        return this.currentTickRotation;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setSource(ShakeSource source) {
        this.source = source;
    }

    public void setRadius(Supplier<Float> radius) {
        this.radius = radius;
    }

    public void setRotationAmplitude(Supplier<Float> rotationAmplitude) {
        this.rotationAmplitude = rotationAmplitude;
    }

    public void setOffsetAmplitude(Supplier<Float> offsetAmplitude) {
        this.offsetAmplitude = offsetAmplitude;
    }

    public void setFovAmplitude(Supplier<Float> fovAmplitude) {
        this.fovAmplitude = fovAmplitude;
    }

    public void setRotationSpeed(Supplier<Float> rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public void setOffsetSpeed(Supplier<Float> offsetSpeed) {
        this.offsetSpeed = offsetSpeed;
    }

    public void setFovSpeed(Supplier<Float> fovSpeed) {
        this.fovSpeed = fovSpeed;
    }

    public void setDuration(Supplier<Integer> duration) {
        this.duration = duration;
    }

    public void setFadeInTime(Supplier<Integer> fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public void setFadeOutTime(Supplier<Integer> fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    public void setRemoveCondition(@Nullable Supplier<Boolean> removeCondition) {
        this.removeCondition = removeCondition;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shake)) {
            return false;
        }
        Shake other = (Shake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getElapsedTime() != other.getElapsedTime()) {
            return false;
        }
        ShakeSource this$source = this.getSource();
        ShakeSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (Float.compare(this.getRotationAmplitude(), other.getRotationAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetAmplitude(), other.getOffsetAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getFovAmplitude(), other.getFovAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getRotationSpeed(), other.getRotationSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetSpeed(), other.getOffsetSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getFovSpeed(), other.getFovSpeed()) != 0) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getFadeInTime() != other.getFadeInTime()) {
            return false;
        }
        if (this.getFadeOutTime() != other.getFadeOutTime()) {
            return false;
        }
        if (this.getRemoveCondition() != other.getRemoveCondition()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Vec3 this$frequency = this.getFrequency();
        Vec3 other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        Vector3f this$lastTickOffset = this.getLastTickOffset();
        Vector3f other$lastTickOffset = other.getLastTickOffset();
        if (this$lastTickOffset == null ? other$lastTickOffset != null : !this$lastTickOffset.equals(other$lastTickOffset)) {
            return false;
        }
        Vector3f this$currentTickOffset = this.getCurrentTickOffset();
        Vector3f other$currentTickOffset = other.getCurrentTickOffset();
        if (this$currentTickOffset == null ? other$currentTickOffset != null : !this$currentTickOffset.equals(other$currentTickOffset)) {
            return false;
        }
        Vector3f this$lastTickRotation = this.getLastTickRotation();
        Vector3f other$lastTickRotation = other.getLastTickRotation();
        if (this$lastTickRotation == null ? other$lastTickRotation != null : !this$lastTickRotation.equals(other$lastTickRotation)) {
            return false;
        }
        Vector3f this$currentTickRotation = this.getCurrentTickRotation();
        Vector3f other$currentTickRotation = other.getCurrentTickRotation();
        return !(this$currentTickRotation == null ? other$currentTickRotation != null : !this$currentTickRotation.equals(other$currentTickRotation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Shake;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getElapsedTime();
        ShakeSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + Float.floatToIntBits(this.getRotationAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getOffsetAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getFovAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getRotationSpeed());
        result = result * 59 + Float.floatToIntBits(this.getOffsetSpeed());
        result = result * 59 + Float.floatToIntBits(this.getFovSpeed());
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getFadeInTime();
        result = result * 59 + this.getFadeOutTime();
        result = result * 59 + (this.getRemoveCondition() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Vec3 $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        Vector3f $lastTickOffset = this.getLastTickOffset();
        result = result * 59 + ($lastTickOffset == null ? 43 : $lastTickOffset.hashCode());
        Vector3f $currentTickOffset = this.getCurrentTickOffset();
        result = result * 59 + ($currentTickOffset == null ? 43 : $currentTickOffset.hashCode());
        Vector3f $lastTickRotation = this.getLastTickRotation();
        result = result * 59 + ($lastTickRotation == null ? 43 : $lastTickRotation.hashCode());
        Vector3f $currentTickRotation = this.getCurrentTickRotation();
        result = result * 59 + ($currentTickRotation == null ? 43 : $currentTickRotation.hashCode());
        return result;
    }

    public String toString() {
        return "Shake(source=" + String.valueOf(this.getSource()) + ", radius=" + this.getRadius() + ", rotationAmplitude=" + this.getRotationAmplitude() + ", offsetAmplitude=" + this.getOffsetAmplitude() + ", fovAmplitude=" + this.getFovAmplitude() + ", rotationSpeed=" + this.getRotationSpeed() + ", offsetSpeed=" + this.getOffsetSpeed() + ", fovSpeed=" + this.getFovSpeed() + ", duration=" + this.getDuration() + ", fadeInTime=" + this.getFadeInTime() + ", fadeOutTime=" + this.getFadeOutTime() + ", removeCondition=" + this.getRemoveCondition() + ", uuid=" + String.valueOf(this.getUuid()) + ", frequency=" + String.valueOf(this.getFrequency()) + ", lastTickOffset=" + String.valueOf(this.getLastTickOffset()) + ", currentTickOffset=" + String.valueOf(this.getCurrentTickOffset()) + ", lastTickRotation=" + String.valueOf(this.getLastTickRotation()) + ", currentTickRotation=" + String.valueOf(this.getCurrentTickRotation()) + ", elapsedTime=" + this.getElapsedTime() + ")";
    }

    public static class ShakeBuilder {
        private ShakeSource source;
        private boolean removeCondition$set;
        private Supplier<Boolean> removeCondition$value;
        private boolean uuid$set;
        private UUID uuid$value;
        private int elapsedTime;
        private Supplier<Float> radius = () -> Float.valueOf(10.0f);
        private Supplier<Float> rotationAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> offsetAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> fovAmplitude = () -> Float.valueOf(1.0f);
        private Supplier<Float> rotationSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Float> offsetSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Float> fovSpeed = () -> Float.valueOf(5.0f);
        private Supplier<Integer> duration = () -> 20;
        private Supplier<Integer> fadeInTime = () -> 0;
        private Supplier<Integer> fadeOutTime = () -> -1;

        public ShakeBuilder radius(Supplier<Float> radius) {
            this.radius = radius;
            return this;
        }

        public ShakeBuilder amplitude(Supplier<Float> rotationAmplitude, Supplier<Float> offsetAmplitude, Supplier<Float> fovAmplitude) {
            this.rotationAmplitude = rotationAmplitude;
            this.offsetAmplitude = offsetAmplitude;
            this.fovAmplitude = fovAmplitude;
            return this;
        }

        public ShakeBuilder amplitude(Supplier<Float> amplitude) {
            return this.amplitude(amplitude, amplitude, amplitude);
        }

        public ShakeBuilder rotationAmplitude(Supplier<Float> amplitude) {
            this.rotationAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder offsetAmplitude(Supplier<Float> amplitude) {
            this.offsetAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder fovAmplitude(Supplier<Float> amplitude) {
            this.fovAmplitude = amplitude;
            return this;
        }

        public ShakeBuilder speed(Supplier<Float> rotationSpeed, Supplier<Float> offsetSpeed, Supplier<Float> fovSpeed) {
            this.rotationSpeed = rotationSpeed;
            this.offsetSpeed = offsetSpeed;
            this.fovSpeed = fovSpeed;
            return this;
        }

        public ShakeBuilder speed(Supplier<Float> speed) {
            return this.speed(speed, speed, speed);
        }

        public ShakeBuilder rotationSpeed(Supplier<Float> speed) {
            this.rotationSpeed = speed;
            return this;
        }

        public ShakeBuilder offsetSpeed(Supplier<Float> speed) {
            this.offsetSpeed = speed;
            return this;
        }

        public ShakeBuilder fovSpeed(Supplier<Float> speed) {
            this.fovSpeed = speed;
            return this;
        }

        public ShakeBuilder duration(Supplier<Integer> duration) {
            this.duration = duration;
            return this;
        }

        public ShakeBuilder fadeInTime(Supplier<Integer> fadeInTime) {
            this.fadeInTime = fadeInTime;
            return this;
        }

        public ShakeBuilder fadeOutTime(Supplier<Integer> fadeOutTime) {
            this.fadeOutTime = fadeOutTime;
            return this;
        }

        private ShakeBuilder source(ShakeSource source) {
            this.source = source;
            return this;
        }

        public ShakeBuilder radius(float radius) {
            this.radius = () -> Float.valueOf(radius);
            return this;
        }

        public ShakeBuilder amplitude(float rotationAmplitude, float offsetAmplitude, float fovAmplitude) {
            return this.amplitude(() -> Float.valueOf(rotationAmplitude), () -> Float.valueOf(offsetAmplitude), () -> Float.valueOf(fovAmplitude));
        }

        public ShakeBuilder amplitude(float amplitude) {
            return this.amplitude(amplitude, amplitude, amplitude);
        }

        public ShakeBuilder rotationAmplitude(float amplitude) {
            return this.rotationAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder offsetAmplitude(float amplitude) {
            return this.offsetAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder fovAmplitude(float amplitude) {
            return this.fovAmplitude(() -> Float.valueOf(amplitude));
        }

        public ShakeBuilder speed(float rotationSpeed, float offsetSpeed, float fovSpeed) {
            return this.speed(() -> Float.valueOf(rotationSpeed), () -> Float.valueOf(offsetSpeed), () -> Float.valueOf(fovSpeed));
        }

        public ShakeBuilder speed(float speed) {
            return this.speed(speed, speed, speed);
        }

        public ShakeBuilder rotationSpeed(float speed) {
            return this.rotationSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder offsetSpeed(float speed) {
            return this.offsetSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder fovSpeed(float speed) {
            return this.fovSpeed(() -> Float.valueOf(speed));
        }

        public ShakeBuilder duration(int duration) {
            this.duration = () -> duration;
            return this;
        }

        public ShakeBuilder fadeInTime(int fadeInTime) {
            this.fadeInTime = () -> fadeInTime;
            return this;
        }

        public ShakeBuilder fadeOutTime(int fadeOutTime) {
            this.fadeOutTime = () -> fadeOutTime;
            return this;
        }

        private ShakeBuilder elapsedTime(int elapsedTime) {
            return this;
        }

        ShakeBuilder() {
        }

        public ShakeBuilder removeCondition(@Nullable Supplier<Boolean> removeCondition) {
            this.removeCondition$value = removeCondition;
            this.removeCondition$set = true;
            return this;
        }

        public ShakeBuilder uuid(UUID uuid) {
            this.uuid$value = uuid;
            this.uuid$set = true;
            return this;
        }

        public Shake build() {
            Supplier<Boolean> removeCondition$value = this.removeCondition$value;
            if (!this.removeCondition$set) {
                removeCondition$value = Shake.$default$removeCondition();
            }
            UUID uuid$value = this.uuid$value;
            if (!this.uuid$set) {
                uuid$value = Shake.$default$uuid();
            }
            return new Shake(this.source, this.radius, this.rotationAmplitude, this.offsetAmplitude, this.fovAmplitude, this.rotationSpeed, this.offsetSpeed, this.fovSpeed, this.duration, this.fadeInTime, this.fadeOutTime, removeCondition$value, uuid$value, this.elapsedTime);
        }

        public String toString() {
            return "Shake.ShakeBuilder(source=" + String.valueOf(this.source) + ", radius=" + String.valueOf(this.radius) + ", rotationAmplitude=" + String.valueOf(this.rotationAmplitude) + ", offsetAmplitude=" + String.valueOf(this.offsetAmplitude) + ", fovAmplitude=" + String.valueOf(this.fovAmplitude) + ", rotationSpeed=" + String.valueOf(this.rotationSpeed) + ", offsetSpeed=" + String.valueOf(this.offsetSpeed) + ", fovSpeed=" + String.valueOf(this.fovSpeed) + ", duration=" + String.valueOf(this.duration) + ", fadeInTime=" + String.valueOf(this.fadeInTime) + ", fadeOutTime=" + String.valueOf(this.fadeOutTime) + ", removeCondition$value=" + String.valueOf(this.removeCondition$value) + ", uuid$value=" + String.valueOf(this.uuid$value) + ", elapsedTime=" + this.elapsedTime + ")";
        }
    }
}

