/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.google.common.collect.BiMap;
import com.zephaniahnoah.minersminerals.Mineral;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

@Mod.EventBusSubscriber(modid="minersminerals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Generator {
    private static final String[] fileTypesHand = new String[]{"_axe", "_pickaxe", "_shovel", "_sword", "_spear", "_greatsword"};
    private static final String[] fileTypes = new String[]{"_boots", "_chestplate", "_helmet", "_leggings", "_axe", "_pickaxe", "_shovel", "_sword", "_spear", "_greatsword"};
    private static final String[] itemTypes = new String[]{"ARMOR", "ARMOR", "ARMOR", "ARMOR", "HEAVY_WEAPON", "BREAKER", "BREAKER", "SWORD", "TRIDENT", "SWORD"};

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeClient()) {
            Generator.registerClientProviders(event.getGenerator(), event);
        }
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        ExistingFileHelper helper = event.getExistingFileHelper();
        try {
            String[] dimensions;
            BiMap items = (BiMap)ObfuscationReflectionHelper.getPrivateValue(ForgeRegistry.class, (Object)((ForgeRegistry)ForgeRegistries.ITEMS), (String)"names");
            Mineral[] minerals1 = new Mineral[]{Mineral.JET, Mineral.RHODONITE, Mineral.BRONZITE, Mineral.COPPER, Mineral.TIN, Mineral.ALUMINUM, Mineral.BRASS, Mineral.NICKEL, Mineral.BRONZE, Mineral.LEAD, Mineral.ELECTRUM, Mineral.OSMIUM, Mineral.MAGNETITE, Mineral.BISMUTH, Mineral.ZINC, Mineral.ANTIMONY, Mineral.JASPER, Mineral.SELENITE, Mineral.GARNET, Mineral.RUBY, Mineral.AMETHYST, Mineral.SAPPHIRE, Mineral.QUARTZ, Mineral.ZIRCON, Mineral.PRISMARINE, Mineral.TOPAZ, Mineral.OLIVINE, Mineral.AMBER, Mineral.SALT};
            Mineral[] minerals2 = new Mineral[]{Mineral.SILVER, Mineral.TITANIUM, Mineral.TUNGSTEN, Mineral.PLATINUM, Mineral.STEEL, Mineral.PALLADIUM, Mineral.COBALT, Mineral.MYTHRIL, Mineral.SILICON, Mineral.URANIUM, Mineral.SPINEL, Mineral.TOURMALINE, Mineral.TIGERS_EYE, Mineral.PERIDOT, Mineral.OPAL, Mineral.MOSS_AGATE, Mineral.JADE, Mineral.SUNSTONE, Mineral.ONYX, Mineral.BLOOD_STONE, Mineral.SERPENTINE};
            Mineral[] minerals3 = new Mineral[]{Mineral.COBALT, Mineral.MYTHRIL, Mineral.UNBIHEXIUM, Mineral.HEDERAIUM, Mineral.SHROOMITE, Mineral.DEUTERIUM, Mineral.ADAMANTIUM, Mineral.SPACE_ROCK, Mineral.CHAROITE};
            Generator.genFiles(minerals1, new ResourceLocation("minecraft:overworld"));
            Generator.genFiles(minerals2, new ResourceLocation("minecraft:the_nether"));
            Generator.genFiles(minerals3, new ResourceLocation("minecraft:the_end"));
            List<Mineral> list1 = Arrays.asList(minerals1);
            List<Mineral> list2 = Arrays.asList(minerals2);
            List<Mineral> list3 = Arrays.asList(minerals3);
            ArrayList<Mineral> allMinerals = new ArrayList<Mineral>();
            allMinerals.addAll(list1);
            allMinerals.addAll(list2);
            allMinerals.addAll(list3);
            for (String dimension : dimensions = new String[]{"overworld", "the_nether", "the_end"}) {
                File f = new File("apoth/bosses/" + dimension + "/mixed_gear.json");
                FileWriter writer = new FileWriter(f);
                List<Mineral> minerals = list1;
                if (dimension.equals("the_nether")) {
                    minerals = list2;
                } else if (dimension.equals("the_end")) {
                    minerals = list3;
                }
                writer.append("{\n\t\"weight\": 70,\n");
                if (dimension.equals("overworld")) {
                    writer.append("\t\"quality\": 5,\n");
                }
                writer.append("\t\"mainhands\": [");
                for (Mineral m : minerals) {
                    for (String handItem : fileTypesHand) {
                        writer.append("{\n\t\t\t\"weight\": 1,\n\t\t\t\"stack\": {\n\t\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + handItem + "\"\n\t\t\t}\n\t\t},");
                    }
                }
                writer.append("\n\t],\n\t\"offhands\": [],\n\t\"boots\": [");
                for (Mineral m : minerals) {
                    writer.append("{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_boots\"\n\t\t}\n\t},");
                }
                writer.append("],\n\t\"leggings\": [");
                for (Mineral m : minerals) {
                    writer.append("{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_leggings\"\n\t\t}\n\t},");
                }
                writer.append("],\n\t\"chestplates\": [");
                for (Mineral m : minerals) {
                    writer.append("{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_chestplate\"\n\t\t}\n\t},");
                }
                writer.append("],\n\t\"helmets\": [");
                for (Mineral m : minerals) {
                    writer.append("{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_helmet\"\n\t\t}\n\t},");
                }
                writer.append("],\n\t\"tags\": [\n\t\t\"" + dimension + "\"\n\t]\n}");
                writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void genFiles(Mineral[] minerals, ResourceLocation dimension) throws IOException {
        for (Mineral m : minerals) {
            for (int i = 0; i < fileTypes.length; ++i) {
                String name = m.getLowerName() + fileTypes[i];
                File file = new File("apoth/" + dimension.m_135815_() + "/" + name + ".json");
                float quality = (float)m.m_6604_() + 3.0f;
                int weight = m.frequency + m.size * 5;
                if (m.size == Mineral.JET.size || m.size == 0) {
                    weight = 80;
                }
                if (fileTypes[i].equals("_greatsword")) {
                    weight /= 2;
                }
                if (weight == 0) {
                    weight = 10;
                }
                String item = "minersminerals:" + name;
                FileWriter writer = new FileWriter(file, true);
                writer.append("{\n  \"weight\": " + weight + ",\n  \"quality\": " + quality + ",\n  \"stack\": {\n    \"item\": \"" + item + "\",\n    \"count\": 1,\n    \"nbt\": \"{Damage:0}\"\n  },\n  \"type\": \"" + itemTypes[i] + "\",\n  \"dimensions\": [\n    \"" + String.valueOf(dimension) + "\"\n  ],\n  \"max_rarity\": \"rare\"\n}");
                writer.close();
            }
        }
    }
}

