/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.ezmodlib.ChunkDecorator;
import com.zephaniahnoah.ezmodlib.EzModLib;
import com.zephaniahnoah.ezmodlib.LootTableInjector;
import com.zephaniahnoah.ezmodlib.TagInjector;
import com.zephaniahnoah.ezmodlib.recipe.FurnaceRecipe;
import com.zephaniahnoah.ezmodlib.recipe.ShapedRecipe;
import com.zephaniahnoah.ezmodlib.recipe.ShapelessRecipe;
import com.zephaniahnoah.ezmodlib.recipe.SingleInputRecipe;
import com.zephaniahnoah.ezmodlib.recipe.SmithingRecipe;
import com.zephaniahnoah.ezmodlib.util.SwapMap;
import com.zephaniahnoah.minersminerals.IMineralOre;
import com.zephaniahnoah.minersminerals.Mineral;
import com.zephaniahnoah.minersminerals.Ores;
import com.zephaniahnoah.minersminerals.extras.Extras;
import com.zephaniahnoah.minersminerals.extras.clam.ClamRenderer;
import com.zephaniahnoah.minersminerals.extras.shuriken.Shuriken;
import com.zephaniahnoah.minersminerals.extras.shuriken.ShurikenEntity;
import com.zephaniahnoah.minersminerals.extras.shuriken.ShurikenRenderer;
import com.zephaniahnoah.minersminerals.extras.spear.Spear;
import com.zephaniahnoah.minersminerals.extras.spear.SpearEntity;
import com.zephaniahnoah.minersminerals.extras.spear.SpearRenderer;
import com.zephaniahnoah.minersminerals.extras.trex.TRexSkullRenderer;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="minersminerals")
@Mod.EventBusSubscriber(modid="minersminerals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Main {
    public static final String MODID = "minersminerals";
    public static final Map<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>> spears = new HashMap<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>>();
    public static final Map<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>> shurikens = new HashMap<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>>();
    public static SwapMap<RegistryObject<Block>, IMineralOre> baseMinerals = new SwapMap(new HashMap());
    private static List<ResourceLocation> dimensionBlacklist = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> baseBlocks = new ArrayList<ResourceLocation>();
    public static final Pair<String[], String[][]> armorData = new Pair((Object)new String[]{"_boots", "_leggings", "_chestplate", "_helmet"}, (Object)new String[][]{{"# #", "# #"}, {"###", "# #", "# #"}, {"# #", "###", "###"}, {"###", "# #"}});
    public static final CreativeModeTab creativeTab = new CreativeModeTab("minersminerals"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minersminerals:adamantium_ingot")));
        }
    };
    public static final CreativeModeTab oreTab = new CreativeModeTab("minersminerals.ores"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minersminerals:spinel_andesite_ore")));
        }
    };
    private static final TagKey<Block> tag = ForgeRegistries.BLOCKS.tags().createOptionalTagKey(new ResourceLocation("minecraft:end_stone_ore_replaceables"), Set.of(com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Blocks.f_50259_)));
    private static Map<String, Pair<IMineralOre, RegistryObject<PlacedFeature>>> featuresCache = new HashMap<String, Pair<IMineralOre, RegistryObject<PlacedFeature>>>();

    public Main() {
        String n;
        try {
            Scanner reader;
            Object config;
            Path minersFolder;
            Path configFolder = Paths.get("config", new String[0]);
            if (!Files.exists(configFolder, new LinkOption[0])) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            if (!Files.exists(minersFolder = Paths.get("config/minersminerals", new String[0]), new LinkOption[0])) {
                Files.createDirectories(minersFolder, new FileAttribute[0]);
            }
            if (((File)(config = new File("config/minersminerals/base_blocks.txt"))).exists()) {
                reader = new Scanner((File)config);
                while (reader.hasNextLine()) {
                    ResourceLocation loc = new ResourceLocation(reader.nextLine());
                    Ores.defaultBlocks.add(loc);
                    this.baseBlocks.add(loc);
                }
                reader.close();
            } else {
                ((File)config).createNewFile();
            }
            config = new File("config/minersminerals/dimension_blacklist.txt");
            if (((File)config).exists()) {
                reader = new Scanner((File)config);
                while (reader.hasNextLine()) {
                    dimensionBlacklist.add(new ResourceLocation(reader.nextLine()));
                }
                reader.close();
            } else {
                ((File)config).createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        EzModLib.init((String)MODID);
        String name = null;
        Extras.init();
        ResourceLocation fossilName = new ResourceLocation("minersminerals:fossil_deposit_block");
        Ores.defaultBlocks.add(fossilName);
        for (final Mineral m : Mineral.values()) {
            com.zephaniahnoah.ezmodlib.util.Supplier stupidJava;
            n = m.getLowerName();
            com.zephaniahnoah.ezmodlib.util.Supplier mineralBlock = null;
            com.zephaniahnoah.ezmodlib.util.Supplier mineralItem = null;
            com.zephaniahnoah.ezmodlib.util.Supplier mineralBlockItem = null;
            boolean makeItem = true;
            boolean makeBlock = true;
            boolean alloy = false;
            switch (m) {
                case RHODONITE: 
                case JET: 
                case SERPENTINE: 
                case BLOOD_STONE: 
                case CHAROITE: 
                case SPACE_ROCK: 
                case BRONZITE: {
                    makeItem = false;
                    break;
                }
                case QUARTZ: 
                case PRISMARINE: {
                    makeItem = false;
                    makeBlock = false;
                    break;
                }
                case PETRIFIED_WOOD: {
                    alloy = true;
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, "petrified_log")));
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MODID, "petrified_wood_planks")));
                    break;
                }
                case STEEL: 
                case BRONZE: 
                case BRASS: {
                    alloy = true;
                    break;
                }
                case AMETHYST: {
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Blocks.f_152490_);
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Items.f_151049_);
                    break;
                }
                case COPPER: {
                    alloy = true;
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Blocks.f_152504_);
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Items.f_151052_);
                    break;
                }
            }
            if (makeBlock) {
                float destroyTime = 2.0f;
                float explosionResistance = 6.0f;
                stupidJava = mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Block(BlockBehaviour.Properties.m_60939_((Material)(m.gem ? Material.f_76278_ : Material.f_76279_)).m_60918_(m.gem ? SoundType.f_56742_ : SoundType.f_56743_).m_60999_().m_60913_(destroyTime, explosionResistance)));
                mineralBlockItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new BlockItem((Block)stupidJava.get(), new Item.Properties().m_41491_(creativeTab)){

                    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                        if (m == Mineral.JET) {
                            return 800;
                        }
                        return -1;
                    }
                });
                name = n + "_block";
                Pair blockReg = EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralBlock, null, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralBlockItem, null);
                Main.defaultBlockDrop(name);
                if (makeItem) {
                    TagInjector.blocks.inject("minecraft:beacon_base_blocks", mineralBlock);
                } else {
                    ResourceLocation blockLoc = new ResourceLocation("minersminerals:" + (String)name);
                    baseMinerals.put((Object)((RegistryObject)blockReg.getFirst()), (Object)m);
                    if (m != Mineral.BLOOD_STONE && m != Mineral.CHAROITE && m != Mineral.SPACE_ROCK) {
                        Ores.defaultBlocks.add(blockLoc);
                    }
                    TagInjector.blocks.inject("forge:wg_stone", mineralBlock);
                    TagInjector.items.inject(m.tag, mineralBlockItem);
                }
                TagInjector.blocks.inject("forge:wg_stone", mineralBlock);
                TagInjector.blocks.inject("minecraft:mineable/pickaxe", mineralBlock);
            }
            if (makeItem) {
                mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties().m_41491_(creativeTab)){

                    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                        if (m == Mineral.AMBER) {
                            return 1600;
                        }
                        return -1;
                    }
                });
                name = n + (m.gem ? "" : "_ingot");
                EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralItem, (boolean)false);
                TagInjector.items.inject("minecraft:beacon_payment_items", mineralItem);
                if (!m.gem) {
                    com.zephaniahnoah.ezmodlib.util.Supplier nugget = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties().m_41491_(creativeTab)));
                    EzModLib.register((String)MODID, (String)(n + "_nugget"), (com.zephaniahnoah.ezmodlib.util.Supplier)nugget, (boolean)false);
                    stupidJava = mineralItem;
                    new ShapedRecipe(new ResourceLocation(n + "_ingot_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)stupidJava.get()).getRegistryName().toString()), 1).item('#', "minersminerals:" + n + "_nugget");
                    new ShapelessRecipe(new ResourceLocation(n + "_nugget_recipe"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)nugget.get()).getRegistryName().toString()), 9).item("minersminerals:" + n + "_ingot");
                    TagInjector.items.inject("forge:nuggets/" + n, nugget);
                    if (!alloy) {
                        com.zephaniahnoah.ezmodlib.util.Supplier rawOre = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties().m_41491_(creativeTab)));
                        EzModLib.register((String)MODID, (String)("raw_" + n), (com.zephaniahnoah.ezmodlib.util.Supplier)rawOre, (boolean)false);
                        TagInjector.items.inject("forge:raw_materials/" + n, rawOre);
                        TagInjector.items.inject("forge:raw_materials", rawOre);
                        new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_raw_blast"}, (String)m.getLowerName()))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.BLASTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$13(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)rawOre)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$14(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)100, (double)0.7).group = m.getLowerName() + "_blast";
                        new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_raw_smelt"}, (String)m.getLowerName()))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.SMELTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$15(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)rawOre)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$16(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)200, (double)0.7).group = m.getLowerName() + "_smelt";
                        com.zephaniahnoah.ezmodlib.util.Supplier rawBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(5.0f, 6.0f)));
                        com.zephaniahnoah.ezmodlib.util.Supplier rawBlockItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new BlockItem((Block)rawBlock.get(), new Item.Properties().m_41491_(creativeTab)));
                        EzModLib.register((String)MODID, (String)(n + "_block_raw"), (com.zephaniahnoah.ezmodlib.util.Supplier)rawBlock, null, (com.zephaniahnoah.ezmodlib.util.Supplier)rawBlockItem, null);
                        TagInjector.blocks.inject("minecraft:mineable/pickaxe", rawBlock);
                        new ShapedRecipe(new ResourceLocation(n + "_raw_block_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)rawBlockItem.get()).getRegistryName().toString()), 1).item('#', "minersminerals:raw_" + n);
                        new ShapedRecipe(new ResourceLocation(n + "_raw_ore_recipe"), new String[]{"#"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)rawOre.get()).getRegistryName().toString()), 9).item('#', "minersminerals:" + n + "_block_raw");
                    }
                }
                TagInjector.items.inject(m.tag, mineralItem);
            }
            if (makeBlock && makeItem) {
                com.zephaniahnoah.ezmodlib.util.Supplier stupidJava2 = mineralBlock;
                com.zephaniahnoah.ezmodlib.util.Supplier javaIsStupid = mineralItem;
                new ShapedRecipe(new ResourceLocation(n + "_block_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Block)stupidJava2.get()).getRegistryName().toString()), 1).item('#', "minersminerals:" + (String)name);
                new ShapelessRecipe(new ResourceLocation(n + "_decompress"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)javaIsStupid.get()).getRegistryName().toString()), 9).item("minersminerals:" + n + "_block");
            }
            m.cook();
            for (int j = 0; j < m.baseBlocks.size(); ++j) {
                Material material;
                boolean baseFromConfig;
                Object texture;
                Object blockPath;
                Block base;
                ResourceLocation baseBlock = m.baseBlocks.get(j);
                if ((!makeBlock || !makeItem || alloy) && m != Mineral.AMETHYST) continue;
                Optional<RegistryObject> optional = baseMinerals.keySet().stream().filter(value -> value.getKey().m_135782_().equals((Object)baseBlock)).findFirst();
                if (!optional.isEmpty()) {
                    base = Blocks.f_50069_;
                    blockPath = ((IMineralOre)baseMinerals.get((Object)optional.get())).getLowerName() + "_block";
                    texture = "minersminerals:block/" + (String)blockPath;
                    baseFromConfig = false;
                } else if (this.baseBlocks.contains(baseBlock)) {
                    base = Blocks.f_50069_;
                    blockPath = baseBlock.m_135815_();
                    texture = baseBlock.m_135827_() + ":block/" + (String)blockPath;
                    baseFromConfig = true;
                } else {
                    base = (Block)ForgeRegistries.BLOCKS.getValue(baseBlock);
                    baseFromConfig = false;
                    blockPath = baseBlock.m_135815_();
                    texture = baseBlock.equals((Object)Blocks.f_50137_.getRegistryName()) ? "minecraft:block/basalt_side" : baseBlock.m_135827_() + ":block/" + (String)blockPath;
                }
                String blockModel = "{\"parent\":\"block/block\",\"loader\":\"forge:multi-layer\",\"layers\":{\"solid\":{\"parent\":\"block/cube_all\",\"textures\":{\"all\":\"" + (String)texture + "\"},\"transform\":{\"origin\":\"center\",\"scale\":1}},\"translucent\":{\"parent\":\"block/cube_all\",\"textures\":{\"all\":\"minersminerals:block/" + n + "_ore\"}}},\"textures\":{\"particle\":\"" + (String)texture + "\"}}";
                com.zephaniahnoah.ezmodlib.util.Supplier ore = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new OreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)base).m_60999_().m_60913_((float)m.m_6604_(), 6.0f)));
                com.zephaniahnoah.ezmodlib.util.Supplier blockItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new BlockItem((Block)ore.get(), new Item.Properties().m_41491_(oreTab)){

                    public String m_5524_() {
                        if (baseFromConfig) {
                            return Main.this.toFirstCharUpperAll(this.getRegistryName().m_135815_().replaceAll("_", " "));
                        }
                        return super.m_5524_();
                    }
                });
                TagInjector.blocks.inject("forge:ores/" + m.getLowerName(), ore);
                TagInjector.items.inject("forge:ores/" + m.getLowerName(), blockItem);
                name = n + "_" + (String)blockPath + "_ore";
                EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)ore, (String)blockModel, (com.zephaniahnoah.ezmodlib.util.Supplier)blockItem, null);
                boolean shovelIt = false;
                if (ForgeRegistries.BLOCKS.containsKey(baseBlock) && ((material = (Material)ObfuscationReflectionHelper.getPrivateValue(BlockBehaviour.class, (Object)((Block)((Holder)ForgeRegistries.BLOCKS.getHolder(baseBlock).get()).m_203334_()), (String)"f_60442_")) != null && material == Material.f_76317_ || material == Material.f_76314_)) {
                    TagInjector.blocks.inject("minecraft:mineable/shovel", ore);
                    shovelIt = true;
                }
                if (!shovelIt) {
                    TagInjector.blocks.inject("minecraft:mineable/pickaxe", ore);
                }
                TagInjector.blocks.inject(m.getToolTag(), ore);
                this.oreLootTable(m, name);
                Ores.register(m, (com.zephaniahnoah.ezmodlib.util.Supplier<Block>)ore, j);
                com.zephaniahnoah.ezmodlib.util.Supplier stupidJava3 = mineralItem;
                new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_blast_\u0001"}, (String)m.getLowerName(), (String)blockPath))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.BLASTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$26(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)blockItem)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$27(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava3)), (int)100, (double)0.7).group = m.getLowerName() + "_blast";
                new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_smelt_\u0001"}, (String)m.getLowerName(), (String)blockPath))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.SMELTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$28(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)blockItem)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$29(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava3)), (int)200, (double)0.7).group = m.getLowerName() + "_smelt";
            }
            com.zephaniahnoah.ezmodlib.util.Supplier shovel = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new ShovelItem((Tier)m, 1.5f, -3.0f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_shovel";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)shovel, (boolean)true);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"#", "/", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)shovel.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier pickaxe = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new PickaxeItem((Tier)m, 1, -2.8f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_pickaxe";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)pickaxe, (boolean)true);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"###", " / ", " / "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)pickaxe.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier axe = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new AxeItem((Tier)m, 5.5f, -3.1f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_axe";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)axe, (boolean)true);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"##", "#/", " /"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)axe.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier hoe = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new HoeItem((Tier)m, -2, -3.5f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_hoe";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)hoe, (boolean)true);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"##", " /", " /"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)hoe.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier sword = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new SwordItem((Tier)m, 3, -2.4f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_sword";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)sword, (String)(m == Mineral.ETHERIUM ? "{\"parent\":\"minecraft:item/handheld\",\"textures\":{\"layer0\":\"minersminerals:item/" + n + "_sword\"},\"display\":{\"thirdperson_righthand\":{\"rotation\":[-27,-90,0],\"translation\":[0,0,-4.25]},\"thirdperson_lefthand\":{\"rotation\":[-27,90,0],\"translation\":[0,0,-4.25]},\"firstperson_righthand\":{\"rotation\":[0,-79,0],\"translation\":[7,0,-10.25],\"scale\":[1.1,1.1,1.1]},\"firstperson_lefthand\":{\"rotation\":[0,79,0],\"translation\":[10,0,-10.25],\"scale\":[1.1,1.1,1.1]},\"ground\":{\"rotation\":[0,0,-45],\"translation\":[0,1.5,0],\"scale\":[0.5,0.5,0.5]}}}" : null), (boolean)true);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)sword.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier greatsword = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new SwordItem((Tier)m, 8, -3.2f, new Item.Properties().m_41491_(creativeTab)));
            name = n + "_greatsword";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)greatsword, (String)Main.greatSwordModel(name), (boolean)true);
            ShapedRecipe rec = new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)greatsword.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden");
            if (m == Mineral.QUARTZ) {
                rec.item('#', "minecraft:quartz_block");
            } else if (m == Mineral.PRISMARINE) {
                rec.item('#', "minecraft:prismarine_bricks");
            } else if (baseMinerals.values().contains(m)) {
                rec.item('#', "minersminerals:polished_" + m.getLowerName());
            } else if (m == Mineral.COPPER) {
                rec.item('#', "minecraft:copper_block");
            } else if (m == Mineral.AMETHYST) {
                rec.item('#', "minecraft:amethyst_block");
            } else if (m == Mineral.PETRIFIED_WOOD) {
                rec.item('#', "minersminerals:petrified_log");
            } else {
                rec.item('#', "minersminerals:" + m.getLowerName() + "_block");
            }
            for (int k = 0; k < 4; ++k) {
                int kkk = k;
                com.zephaniahnoah.ezmodlib.util.Supplier armor = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new ArmorItem((ArmorMaterial)m, EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)kkk), new Item.Properties().m_41491_(creativeTab)));
                name = m.getLowerName() + ((String[])armorData.getFirst())[k];
                EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)armor, (boolean)false);
                new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), ((String[][])armorData.getSecond())[k], com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)armor.get()).getRegistryName().toString()), 1).tag('#', m.tag);
            }
            com.zephaniahnoah.ezmodlib.util.Supplier spear = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Spear(m, new Item.Properties().m_41491_(creativeTab).m_41503_(m.m_6609_())));
            name = n + "_spear";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)spear, (String)Main.spearModel(name), (boolean)false);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{"  #", " / ", "/  "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)spear.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden").tag('#', m.tag);
            spears.put(name, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)spear);
            com.zephaniahnoah.ezmodlib.util.Supplier shuriken = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Shuriken(m, new Item.Properties().m_41491_(creativeTab).m_41503_(m.m_6609_())));
            name = n + "_shuriken";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)shuriken, (boolean)false);
            new ShapedRecipe(new ResourceLocation((String)name + "_recipe"), new String[]{" # ", "# #", " # "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)shuriken.get()).getRegistryName().toString()), 1).tag('#', m.tag);
            shurikens.put(name, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)shuriken);
        }
        this.registerEntities();
        for (Tiers tier : Tiers.values()) {
            n = tier.name().toLowerCase();
            Item.Properties prop = new Item.Properties().m_41491_(CreativeModeTab.f_40757_);
            com.zephaniahnoah.ezmodlib.util.Supplier greatsword = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new SwordItem((Tier)tier, 8, -3.2f, prop));
            name = n + "_greatsword";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)greatsword, (String)Main.greatSwordModel(name), (boolean)true);
            ResourceLocation loc = new ResourceLocation(name + "_recipe");
            if (tier == Tiers.NETHERITE) {
                prop.m_41486_();
                new SmithingRecipe(loc, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_greatsword"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)greatsword.get()).getRegistryName().toString()));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc, new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)greatsword.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden");
                switch (tier) {
                    case WOOD: {
                        rec.tag('#', "minecraft:logs");
                        break;
                    }
                    case STONE: {
                        rec.tag('#', "forge:stone");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:storage_blocks/" + tier.name().toLowerCase());
                    }
                }
            }
            Item.Properties prop2 = new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41503_(tier.m_6609_());
            com.zephaniahnoah.ezmodlib.util.Supplier spear = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Spear((Tier)tier, prop2));
            name = n + "_spear";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)spear, (String)Main.spearModel(name), (boolean)true);
            ResourceLocation loc2 = new ResourceLocation(name + "_recipe");
            if (tier == Tiers.NETHERITE) {
                prop2.m_41486_();
                new SmithingRecipe(loc2, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_spear"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)spear.get()).getRegistryName().toString()));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc2, new String[]{"  #", " / ", "/  "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)spear.get()).getRegistryName().toString()), 1).tag('/', "forge:rods/wooden");
                switch (tier) {
                    case WOOD: {
                        rec.tag('#', "minecraft:planks");
                        break;
                    }
                    case STONE: {
                        rec.tag('#', "forge:cobblestone").tag('#', "forge:stone");
                        break;
                    }
                    case DIAMOND: {
                        rec.tag('#', "forge:gems/diamond");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:ingots/" + tier.name().toLowerCase());
                    }
                }
            }
            spears.put(name, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)spear);
            Item.Properties prop4 = new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41503_(tier.m_6609_());
            com.zephaniahnoah.ezmodlib.util.Supplier shuriken = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Shuriken((Tier)tier, prop4));
            name = n + "_shuriken";
            EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)shuriken, (boolean)true);
            ResourceLocation loc3 = new ResourceLocation(name + "_recipe");
            if (tier == Tiers.NETHERITE) {
                prop4.m_41486_();
                new SmithingRecipe(loc3, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_shuriken"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)shuriken.get()).getRegistryName().toString()));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc3, new String[]{" # ", "# #", " # "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ((Item)shuriken.get()).getRegistryName().toString()), 1);
                switch (tier) {
                    case WOOD: {
                        rec.tag('#', "minecraft:planks");
                        break;
                    }
                    case STONE: {
                        rec.tag('#', "forge:cobblestone").tag('#', "forge:stone");
                        break;
                    }
                    case DIAMOND: {
                        rec.tag('#', "forge:gems/diamond");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:ingots/" + tier.name().toLowerCase());
                    }
                }
            }
            shurikens.put(name, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)shuriken);
        }
        ChunkDecorator.decorators.add(new ChunkDecorator(){

            public void decorate(ChunkAccess chunk, Random rand) {
                for (ResourceLocation dimension : dimensionBlacklist) {
                    if (chunk.getWorldForge().m_5962_().m_175515_(Registry.f_122818_).m_7745_(dimension) != chunk.getWorldForge().m_6042_()) continue;
                    return;
                }
                LevelAccessor world = chunk.getWorldForge();
                float worldArea = world.m_141928_() - world.m_6042_().m_156732_();
                for (Mineral m : Mineral.values()) {
                    com.zephaniahnoah.ezmodlib.util.Supplier<Block>[] b;
                    Holder biome = chunk.m_203495_(8, 70, 8);
                    if (m.biomes() != null) {
                        boolean match = false;
                        for (Biome.BiomeCategory c : m.biomes()) {
                            if (!c.equals((Object)Biome.m_204183_((Holder)biome))) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                    }
                    if ((b = Ores.ores.get(m)) == null) continue;
                    float oreArea = m.maxHeight - m.minHeight;
                    float orePercent = oreArea / worldArea;
                    int veinsPerChunk = rand.nextInt(m.frequency) + m.frequency / 2;
                    veinsPerChunk = Math.round((float)veinsPerChunk * orePercent);
                    block3: for (int i = 0; i < veinsPerChunk; ++i) {
                        int x = rand.nextInt(15);
                        int y = rand.nextInt(m.maxHeight - m.minHeight) + m.minHeight;
                        int z = rand.nextInt(15);
                        for (int k = 0; k < m.size; ++k) {
                            Direction d = Direction.values()[rand.nextInt(Direction.values().length)];
                            BlockPos pos = new BlockPos(x += d.m_122429_(), y += d.m_122430_(), z += d.m_122431_());
                            ResourceLocation replacing = chunk.m_8055_(pos).m_60734_().getRegistryName();
                            boolean first = true;
                            boolean found = false;
                            for (int stoneIndex = 0; stoneIndex < m.baseBlocks.size(); ++stoneIndex) {
                                if (replacing.equals((Object)m.baseBlocks.get(stoneIndex))) {
                                    chunk.m_6978_(pos, ((Block)b[stoneIndex].get()).m_49966_(), false);
                                    found = true;
                                    break;
                                }
                                first = false;
                            }
                            if (!found && first) continue block3;
                        }
                    }
                }
            }
        });
        DeferredRegister cfgFeat = DeferredRegister.create((ResourceKey)BuiltinRegistries.f_123861_.m_123023_(), (String)MODID);
        DeferredRegister plcFeat = DeferredRegister.create((ResourceKey)BuiltinRegistries.f_194653_.m_123023_(), (String)MODID);
        cfgFeat.register(FMLJavaModLoadingContext.get().getModEventBus());
        plcFeat.register(FMLJavaModLoadingContext.get().getModEventBus());
        for (Map.Entry p : baseMinerals.entrySet()) {
            Object prop = p.getValue();
            if (!(prop instanceof Mineral)) continue;
            Mineral m = (Mineral)prop;
            int dimension = 0;
            if (m.baseBlocks.contains(Blocks.f_50134_.getRegistryName())) {
                dimension = -1;
            } else if (m.baseBlocks.contains(Blocks.f_50259_.getRegistryName())) {
                dimension = 1;
            }
            this.registerFeature(m, dimension, (RegistryObject<Block>)((RegistryObject)p.getKey()), cfgFeat, (DeferredRegister<PlacedFeature>)plcFeat, m.getLowerName(), m.size, m.minHeight, m.maxHeight, m.frequency);
        }
        this.registerFeature(Extras.ExtraMineral.FOSSIL_DEPOSIT, 0, (RegistryObject<Block>)((RegistryObject)baseMinerals.swap().get(Extras.ExtraMineral.FOSSIL_DEPOSIT)), cfgFeat, (DeferredRegister<PlacedFeature>)plcFeat, "fossil_deposit2", 64, 20, 50, 1);
        this.registerFeature(Extras.ExtraMineral.FOSSIL_DEPOSIT, 0, (RegistryObject<Block>)((RegistryObject)baseMinerals.swap().get(Extras.ExtraMineral.FOSSIL_DEPOSIT)), cfgFeat, (DeferredRegister<PlacedFeature>)plcFeat, "fossil_deposit", 32, 20, 50, 1);
    }

    private void registerFeature(IMineralOre m, int dimension, RegistryObject<Block> block, DeferredRegister<ConfiguredFeature<?, ?>> cfgFeat, DeferredRegister<PlacedFeature> plcFeat, String mineralName, int size, int minHeight, int maxHeight, int frequency) {
        com.zephaniahnoah.ezmodlib.util.Supplier toReplace = dimension == -1 ? com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((Block)block.get()).m_49966_()))) : (dimension == 0 ? com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)block.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)block.get()).m_49966_()))) : com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)new TagMatchTest(tag), (BlockState)((Block)block.get()).m_49966_()))));
        com.zephaniahnoah.ezmodlib.util.Supplier cfg = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)toReplace.get(), size)));
        cfgFeat.register(mineralName + "_cfg", (Supplier)cfg);
        RegistryObject ro = plcFeat.register(mineralName + "_plc", (Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)cfg.get())), List.of(RarityFilter.m_191900_((int)frequency), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight)), BiomeFilter.m_191561_()))));
        featuresCache.put(mineralName, (Pair<IMineralOre, RegistryObject<PlacedFeature>>)new Pair((Object)m, (Object)ro));
    }

    public static void defaultBlockDrop(String name) {
        Main.tableInject(name, "{\"type\":\"minecraft:block\",\"pools\":[{\"rolls\":1,\"entries\":[{\"type\":\"minecraft:item\",\"name\":\"minersminerals:" + name + "\"}],\"conditions\":[{\"condition\":\"minecraft:survives_explosion\"}]}]}");
    }

    private static void tableInject(String name, String table) {
        JsonObject element = new JsonParser().parse(table).getAsJsonObject();
        LootTableInjector.tablesToInject.put(new ResourceLocation(MODID, "blocks/" + name), element);
    }

    private void registerEntities() {
        Pair shuriken = EzModLib.register((String)MODID, (String)"shuriken", ShurikenEntity::new, (MobCategory)MobCategory.MISC);
        ((EntityType.Builder)shuriken.getFirst()).m_20699_(0.3f, 0.3f).m_20702_(4).m_20717_(20);
        Pair spear = EzModLib.register((String)MODID, (String)"spear", SpearEntity::new, (MobCategory)MobCategory.MISC);
        ((EntityType.Builder)spear.getFirst()).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerRenders((RegistryObject)shuriken.getSecond(), (RegistryObject)spear.getSecond());
        }
        SpearEntity.spearType = (RegistryObject)spear.getSecond();
        ShurikenEntity.shurikenType = (RegistryObject)shuriken.getSecond();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenders(RegistryObject<?> shuriken, RegistryObject<?> spear) {
        EzModLib.registerRender((String)MODID, (String)"shuriken", ShurikenRenderer::new, shuriken);
        EzModLib.registerRender((String)MODID, (String)"spear", SpearRenderer::new, spear);
        EzModLib.blockEntityRenderers.put(Extras.trexTileEntity, TRexSkullRenderer::new);
        EzModLib.blockEntityRenderers.put(Extras.clamTileEntity, ClamRenderer::new);
    }

    public static String spearModel(String name) {
        return "{\"parent\":\"minecraft:item/handheld\",\"textures\":{\"layer0\":\"minersminerals:item/" + name + "\"},\"display\":{\"thirdperson_righthand\":{\"rotation\":[-90,90,0],\"translation\":[0,0,3],\"scale\":[1.625,1.625,1.625]},\"thirdperson_lefthand\":{\"rotation\":[-180,90,0],\"translation\":[0,0,3],\"scale\":[1.625,1.625,1.625]},\"firstperson_righthand\":{\"rotation\":[0,95,0],\"translation\":[7,0,0],\"scale\":[1.25,1.25,1.25]},\"firstperson_lefthand\":{\"rotation\":[0,-85,0],\"translation\":[7,0,0],\"scale\":[1.5,1.25,1.25]}}}";
    }

    public static String greatSwordModel(String name) {
        return "{\"parent\":\"item/generated\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[0,-90,55],\"translation\":[0,13.0,0],\"scale\":[1.7,1.7,0.85]},\"thirdperson_lefthand\":{\"rotation\":[0,90,-55],\"translation\":[0,13,0],\"scale\":[1.7,1.7,0.85]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[1.36,1.36,0.68]},\"firstperson_lefthand\":{\"rotation\":[0,90,-25],\"translation\":[1.13,3.2,1.13],\"scale\":[1.36,1.36,0.68]},\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,0,0],\"scale\":[1.0,1.0,0.5]},\"fixed\":{\"rotation\":[0,0,0],\"translation\":[0,0,0],\"scale\":[2.0,2.0,1.0]}},\"textures\":{\"layer0\":\"minersminerals:item/" + name + "\"}}";
    }

    private void oreLootTable(Mineral m, String oreName) {
        String table = "{\"type\":\"minecraft:block\",\"pools\":[{\"rolls\":1,\"entries\":[{\"type\":\"minecraft:alternatives\",\"children\":[{\"type\":\"minecraft:item\",\"conditions\":[{\"condition\":\"minecraft:match_tool\",\"predicate\":{\"enchantments\":[{\"enchantment\":\"minecraft:silk_touch\",\"levels\":{\"min\":1}}]}}],\"name\":\"minersminerals:" + oreName + "\"},{\"type\":\"minecraft:item\",\"functions\":[{\"function\":\"minecraft:set_count\",\"count\":{\"min\":" + m.minDrops + ",\"max\":" + m.maxDrops + ",\"type\":\"minecraft:uniform\"}},{\"function\":\"minecraft:apply_bonus\",\"enchantment\":\"minecraft:fortune\",\"formula\":\"minecraft:ore_drops\"},{\"function\":\"minecraft:explosion_decay\"}],\"name\":\"" + (String)(m == Mineral.AMETHYST ? "minecraft:amethyst_shard" : "minersminerals:" + (m.gem ? "" : "raw_") + m.getLowerName()) + "\"}]}]}]}";
        Main.tableInject(oreName, table);
    }

    public String toFirstCharUpperAll(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        for (com.zephaniahnoah.ezmodlib.util.Supplier<Block>[] supplierArray : Ores.ores.values()) {
            for (com.zephaniahnoah.ezmodlib.util.Supplier<Block> block : supplierArray) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110466_());
            }
        }
        for (com.zephaniahnoah.ezmodlib.util.Supplier supplier : Extras.transparentBlocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)supplier.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)supplier.get()), (RenderType)RenderType.m_110457_());
        }
    }

    private static /* synthetic */ String lambda$new$29(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ((Item)stupidJava.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$28(com.zephaniahnoah.ezmodlib.util.Supplier blockItem) {
        return ((Item)blockItem.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$27(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ((Item)stupidJava.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$26(com.zephaniahnoah.ezmodlib.util.Supplier blockItem) {
        return ((Item)blockItem.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$16(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ((Item)stupidJava.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$15(com.zephaniahnoah.ezmodlib.util.Supplier rawOre) {
        return ((Item)rawOre.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$14(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ((Item)stupidJava.get()).getRegistryName().toString();
    }

    private static /* synthetic */ String lambda$new$13(com.zephaniahnoah.ezmodlib.util.Supplier rawOre) {
        return ((Item)rawOre.get()).getRegistryName().toString();
    }

    static {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onEntityDie(LivingDeathEvent e) {
                if (e.getEntity() instanceof EnderDragon) {
                    ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minersminerals:dragon_scale")));
                    Vec3 p = e.getEntity().m_20182_();
                    BlockPos blockPos = new BlockPos((double)Math.round(p.f_82479_), (double)Math.round(p.f_82480_), (double)Math.round(p.f_82481_));
                    Block.m_49840_((Level)e.getEntity().m_183503_(), (BlockPos)blockPos, (ItemStack)stack);
                }
            }

            @SubscribeEvent
            public void onServerTick(TickEvent.ServerTickEvent e) {
                if (Shuriken.ticks >= 600) {
                    for (ServerPlayer p : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                        for (ItemStack i : p.m_150109_().f_35974_) {
                            int count;
                            CompoundTag nbt;
                            if (!(i.m_41720_() instanceof Shuriken) || (nbt = i.m_41783_()) == null || !nbt.m_128441_("ShurikenCount") || (count = nbt.m_128451_("ShurikenCount")) >= 16) continue;
                            nbt.m_128405_("ShurikenCount", ++count);
                            i.m_41751_(nbt);
                        }
                    }
                    Shuriken.ticks = 0;
                }
                ++Shuriken.ticks;
            }

            @SubscribeEvent
            public void generateStoneBlobs(BiomeLoadingEvent e) {
                for (Map.Entry<String, Pair<IMineralOre, RegistryObject<PlacedFeature>>> feat : featuresCache.entrySet()) {
                    boolean found = false;
                    if (feat.getValue().getFirst() instanceof Extras.ExtraMineral && feat.getKey().equals("fossil_deposit")) {
                        found = true;
                    }
                    if (((IMineralOre)feat.getValue().getFirst()).biomes() == null) {
                        found = true;
                    } else if (Arrays.asList(((IMineralOre)feat.getValue().getFirst()).biomes()).contains(e.getCategory())) {
                        found = true;
                    }
                    if (!found) continue;
                    e.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Holder.m_205709_((Object)((PlacedFeature)((RegistryObject)feat.getValue().getSecond()).get())));
                }
            }
        });
    }
}

