/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras;

import com.zephaniahnoah.minersminerals.extras.shuriken.Shuriken;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StarfishItem
extends Shuriken {
    private Block block;

    public StarfishItem(Tier mineral, Item.Properties properties, Block block) {
        super(mineral, properties);
        this.block = block;
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        InteractionResult actionresulttype = this.place(new BlockPlaceContext(useContext));
        if (!actionresulttype.m_19077_() && this.m_41472_()) {
            actionresulttype = this.m_7203_(useContext.m_43725_(), useContext.m_43723_(), useContext.m_43724_()).m_19089_();
        }
        return actionresulttype;
    }

    public InteractionResult place(BlockPlaceContext blockitemusecontext) {
        if (!blockitemusecontext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level world = blockitemusecontext.m_43725_();
        Player playerentity = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)world, blockpos, (Entity)blockitemusecontext.m_43723_());
        world.m_5594_(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, blockitemusecontext.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (playerentity == null || !playerentity.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return false;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext useContext) {
        BlockState blockstate = this.getBlock().m_5573_(useContext);
        return blockstate != null && this.canPlace(useContext, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos blockPos, Level world, ItemStack itemStack, BlockState blockState) {
        BlockState blockstate = blockState;
        CompoundTag compoundnbt = itemStack.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = blockState.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = this.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != blockState) {
            world.m_7731_(blockPos, blockstate, 2);
        }
        return blockstate;
    }

    private <T extends Comparable<T>> BlockState updateState(BlockState blockState, Property<T> property, String string) {
        return property.m_6215_(string).map(p_219986_2_ -> (BlockState)blockState.m_61124_(property, p_219986_2_)).orElse(blockState);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState blockState) {
        Player playerentity = context.m_43723_();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerentity);
        return (!this.mustSurvive() || blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(blockState, context.m_8083_(), iselectioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState blockState) {
        return context.m_43725_().m_7731_(context.m_8083_(), blockState, 11);
    }

    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> textComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, world, textComponents, tooltipFlag);
        this.getBlock().m_5871_(itemStack, (BlockGetter)world, textComponents, tooltipFlag);
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)this.getBlockRaw().delegate.get();
    }

    private Block getBlockRaw() {
        return this.block;
    }
}

