/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.shuriken;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zephaniahnoah.minersminerals.extras.shuriken.ShurikenEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class Shuriken
extends TridentItem {
    private static final List<Enchantment> enchants = Arrays.asList(Enchantments.f_44959_, Enchantments.f_44986_, Enchantments.f_44955_, Enchantments.f_44962_, Enchantments.f_44989_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44990_);
    public static final String shurikenCount = "ShurikenCount";
    public final Multimap<Attribute, AttributeModifier> f_43379_;
    public final Tier tier;
    public static int ticks = 0;
    public static final String prismarine = "prismarine_shuriken";
    public static final int lifeTime = 600;
    public static final int stackSize = 16;

    public Shuriken(Tier mineral, Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)mineral.m_6631_() / 1.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.f_43379_ = builder.build();
        this.tier = mineral;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.f_43379_ : super.m_7167_(slot);
    }

    public void m_5551_(ItemStack shuriken, Level world, LivingEntity user, int timer) {
        if (user instanceof Player) {
            Player playerentity = (Player)user;
            if (!world.f_46443_) {
                int count = 16;
                CompoundTag nbt = shuriken.m_41783_();
                if (nbt != null && nbt.m_128441_(shurikenCount)) {
                    count = nbt.m_128451_(shurikenCount);
                }
                if (count > 0 || playerentity.m_150110_().f_35937_) {
                    shuriken.m_41622_(1, (LivingEntity)playerentity, player -> player.m_21190_(user.m_7655_()));
                    int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)shuriken);
                    ShurikenEntity shurikenEntity = null;
                    int length = multishotLevel == 0 ? 1 : (count > 3 ? 3 : count);
                    for (int i = 0; i < length; ++i) {
                        shurikenEntity = new ShurikenEntity(world, (LivingEntity)playerentity, shuriken);
                        shurikenEntity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - (float)(10 * multishotLevel * i) + (float)(length == 1 ? 0 : 10), 0.0f, 1.5f, 1.0f);
                        if (playerentity.m_150110_().f_35937_) {
                            shurikenEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        } else {
                            --count;
                            if (nbt != null) {
                                nbt.m_128405_(shurikenCount, count);
                                shuriken.m_41751_(nbt);
                            }
                        }
                        int k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)shuriken);
                        if (k > 0) {
                            shurikenEntity.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)shuriken) > 0) {
                            shurikenEntity.m_20254_(100);
                        }
                        world.m_7967_((Entity)shurikenEntity);
                    }
                    world.m_6269_((Player)null, (Entity)shurikenEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return enchants.contains(ench);
    }

    public int m_6473_() {
        return this.tier.m_6601_();
    }

    public boolean m_6832_(ItemStack item1, ItemStack item2) {
        return this.tier.m_6282_().test(item2) || super.m_6832_(item1, item2);
    }
}

