/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.shuriken;

import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.extras.shuriken.Shuriken;
import com.zephaniahnoah.minersminerals.extras.spear.SpearEntity;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class ShurikenEntity
extends AbstractArrow {
    private static final String defaultShuriken = "copper_shuriken";
    private static final EntityDataAccessor<Byte> ID_LOYALTY = (EntityDataAccessor)ObfuscationReflectionHelper.getPrivateValue(ThrownTrident.class, null, (String)"f_37558_");
    private static final EntityDataAccessor<Boolean> ID_FOIL = (EntityDataAccessor)ObfuscationReflectionHelper.getPrivateValue(ThrownTrident.class, null, (String)"f_37554_");
    private static final EntityDataAccessor<String> ID_OWNER = SynchedEntityData.m_135353_(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> ITEM = SynchedEntityData.m_135353_(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static RegistryObject shurikenType;
    private int life;
    private ItemStack tridentItem = new ItemStack((ItemLike)Items.f_42713_);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;
    private String cacaheNameLookup = null;

    public ShurikenEntity(EntityType<?> shuriken, Level world) {
        super(shuriken, world);
    }

    public ShurikenEntity(Level world, LivingEntity thrower, ItemStack shuriken) {
        super((EntityType)shurikenType.get(), world);
        this.m_5602_((Entity)thrower);
        this.m_6034_(thrower.m_20185_(), thrower.m_20188_() - (double)0.1f, thrower.m_20189_());
        this.tridentItem = shuriken;
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)shuriken)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)shuriken.m_41790_());
        this.f_19804_.m_135381_(ID_OWNER, (Object)(thrower instanceof Player ? ((Player)thrower).m_7755_().m_6111_() : ""));
        this.f_19804_.m_135381_(ITEM, (Object)this.shurikenName(shuriken));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ShurikenEntity(Level world_, double x, double y, double z) {
        super(EntityType.f_20487_, x, y, z, world_);
    }

    private String shurikenName(ItemStack shuriken) {
        return shuriken.m_41720_().getRegistryName().m_135815_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)defaultShuriken);
        this.f_19804_.m_135372_(ID_OWNER, (Object)"");
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)Main.shurikens.get(this.f_19804_.m_135370_(ITEM)).get());
    }

    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    protected void m_5790_(EntityHitResult result) {
        BlockPos blockpos;
        Entity entity1;
        float f;
        Entity entity = result.m_82443_();
        ItemStack shuriken = this.m_7941_();
        if (shuriken.m_41720_() instanceof Shuriken) {
            Shuriken item = (Shuriken)shuriken.m_41720_();
            f = item.tier.m_6631_();
        } else {
            f = 2.5f;
        }
        f += 1.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)shuriken, (MobType)livingentity.m_6336_());
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            Vec3 vector3d;
            if (flag) {
                return;
            }
            int knockback = (Integer)ObfuscationReflectionHelper.getPrivateValue(AbstractArrow.class, (Object)((Object)this), (String)"f_36699_");
            if (knockback > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
                entity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        } else {
            entity.m_7311_(k);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.f_19853_ instanceof Level && this.f_19853_.m_46470_() && EnchantmentHelper.m_44936_((ItemStack)shuriken) && this.f_19853_.m_45527_(blockpos = entity.m_142538_())) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
            lightningboltentity.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
            this.f_19853_.m_7967_((Entity)lightningboltentity);
            soundevent = SoundEvents.f_12521_;
            f1 = 5.0f;
        }
        this.m_5496_(soundevent, f1, 1.0f);
    }

    public void m_8119_() {
        byte i;
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null && ((i = ((Byte)this.f_19804_.m_135370_(ID_LOYALTY)).byteValue()) <= 0 || this.isAcceptibleReturnOwner()) && i > 0) {
            this.m_36790_(true);
            Vec3 vector3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
            this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
            if (this.f_19853_.f_46443_) {
                this.f_19791_ = this.m_20186_();
            }
            double d0 = 0.05 * (double)i;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
            if (this.clientSideReturnTridentTickCount == 0) {
                this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
            }
            ++this.clientSideReturnTridentTickCount;
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public void m_6123_(Player player) {
        Entity entity = this.m_37282_();
        if (!(entity != null && entity.m_142081_() != player.m_142081_() || this.f_19853_.f_46443_ || !this.f_36703_ && !this.m_36797_() || this.f_36706_ > 0)) {
            boolean pickupsAllowed;
            if (player.m_150110_().f_35937_) {
                player.m_7938_((Entity)this, 1);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            boolean bl = pickupsAllowed = this.f_36705_ == AbstractArrow.Pickup.ALLOWED;
            if (pickupsAllowed || this.m_36797_() && this.m_37282_().m_142081_() == player.m_142081_()) {
                this.pickup(player, false);
                player.m_7938_((Entity)this, 1);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean pickup(Player player, boolean defaultValue) {
        for (ItemStack i : player.m_150109_().f_35974_) {
            if (!this.check(i, false)) continue;
            return true;
        }
        return this.check((ItemStack)player.m_150109_().f_35976_.get(0), defaultValue);
    }

    private boolean check(ItemStack i, boolean defaultValue) {
        if (i.m_41720_() == this.m_7941_().m_41720_() && i.m_41785_().equals((Object)this.m_7941_().m_41785_())) {
            CompoundTag tag = i.m_41783_();
            if (tag == null) {
                return false;
            }
            int count = 16;
            if (tag.m_128441_("ShurikenCount")) {
                count = tag.m_128451_("ShurikenCount");
            }
            if (count < 16) {
                tag.m_128405_("ShurikenCount", ++count);
                i.m_41751_(tag);
                return true;
            }
        }
        return defaultValue;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Trident", 10)) {
            this.tridentItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Trident"));
        }
        this.dealtDamage = nbt.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentItem)));
        this.f_19804_.m_135381_(ITEM, (Object)nbt.m_128461_("Shuriken"));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Trident", (Tag)this.tridentItem.m_41739_(new CompoundTag()));
        nbt.m_128379_("DealtDamage", this.dealtDamage);
        nbt.m_128359_("Shuriken", this.shurikenName(this.m_7941_()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_6882_() {
        if (this.cacaheNameLookup == null) {
            this.cacaheNameLookup = (String)this.f_19804_.m_135370_(ITEM);
        }
        return this.cacaheNameLookup.equals("prismarine_shuriken") || this.cacaheNameLookup.equals("starfish_shuriken") ? 0.99f : super.m_6882_();
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            ++this.life;
            if (this.life >= 600) {
                Player p;
                String owner = (String)this.f_19804_.m_135370_(ID_OWNER);
                Iterator iterator = this.m_20193_().m_6907_().iterator();
                while (iterator.hasNext() && (!(p = (Player)iterator.next()).m_7755_().m_6111_().equals(owner) || !((String)this.f_19804_.m_135370_(ITEM)).equals("starfish_shuriken") && !this.pickup(p, false))) {
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

