/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.trex;

import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.minersminerals.extras.Extras;
import com.zephaniahnoah.minersminerals.extras.HorizontalFossilBlock;
import com.zephaniahnoah.minersminerals.extras.trex.TRexSkullTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TRexSkull
extends HorizontalFossilBlock
implements EntityBlock {
    private static final Pair<Integer, Integer> sideA = new Pair((Object)2, (Object)8);
    private static final Pair<Integer, Integer> sideB = new Pair((Object)-2, (Object)-16);
    private static final Pair<Integer, Integer> topA = new Pair((Object)0, (Object)8);
    private static final Pair<Integer, Integer> topB = new Pair((Object)-16, (Object)-19);
    private static final Pair<Integer, Integer> noseA = new Pair((Object)0, (Object)-18);
    private static final Pair<Integer, Integer> noseB = new Pair((Object)-16, (Object)-24);
    private static final Pair<Integer, Integer> movementBase = new Pair((Object)-1, (Object)0);
    private final VoxelShape N = TRexSkull.getMirroredModel(true, false);
    private final VoxelShape S = TRexSkull.getMirroredModel(false, false);
    private final VoxelShape E = TRexSkull.getMirroredModel(false, true);
    private final VoxelShape W = TRexSkull.getMirroredModel(true, true);

    public TRexSkull(BlockBehaviour.Properties properties) {
        super(properties, Shapes.m_83144_(), Shapes.m_83144_());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return this.N;
            }
            case SOUTH: {
                return this.S;
            }
            case EAST: {
                return this.E;
            }
            case WEST: {
                return this.W;
            }
        }
        return Shapes.m_83144_();
    }

    private static VoxelShape getMirroredModel(boolean mirrorX, boolean mirrorZ) {
        int m = mirrorX ? 1 : -1;
        Pair A = mirrorZ ? sideA.swap() : sideA;
        Pair B = mirrorZ ? sideB.swap() : sideB;
        VoxelShape side = TRexSkull.boxReOrder((Integer)A.getFirst() * m, 0, (Integer)A.getSecond() * m, (Integer)B.getFirst() * m, 24, (Integer)B.getSecond() * m);
        Pair A2 = mirrorZ ? topA.swap() : topA;
        Pair B2 = mirrorZ ? topB.swap() : topB;
        Pair C = mirrorZ ? noseA.swap() : noseA;
        Pair D = mirrorZ ? noseB.swap() : noseB;
        Pair base = mirrorZ ? movementBase.swap() : movementBase;
        VoxelShape whole = Shapes.m_83124_((VoxelShape)side, (VoxelShape[])new VoxelShape[]{side.m_83216_((double)((Integer)base.getFirst() * m), 0.0, (double)((Integer)base.getSecond() * m)), TRexSkull.boxReOrder((Integer)A2.getFirst() * m, 24, (Integer)A2.getSecond() * m, (Integer)B2.getFirst() * m, 28, (Integer)B2.getSecond() * m), TRexSkull.boxReOrder((Integer)C.getFirst() * m, 14, (Integer)C.getSecond() * m, (Integer)D.getFirst() * m, 24, (Integer)D.getSecond() * m)});
        return whole.m_83216_(mirrorX ? 1.0 : 0.0, 0.0, mirrorX ? 1.0 : 0.0);
    }

    private static VoxelShape boxReOrder(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return TRexSkull.m_49796_((double)(fromX > toX ? (double)toX : (double)fromX), (double)(fromY > toY ? (double)toY : (double)fromY), (double)(fromZ > toZ ? (double)toZ : (double)fromZ), (double)(fromX < toX ? (double)toX : (double)fromX), (double)(fromY < toY ? (double)toY : (double)fromY), (double)(fromZ < toZ ? (double)toZ : (double)fromZ));
    }

    public void m_6810_(BlockState blockState, Level world, BlockPos blockPos, BlockState otherBlockState, boolean bool) {
        if (!blockState.m_60713_(otherBlockState.m_60734_())) {
            BlockEntity tileEntity = world.m_7702_(blockPos);
            if (tileEntity instanceof TRexSkullTileEntity) {
                ItemStack stack = new ItemStack((ItemLike)Extras.trexSkull.get());
                stack.m_41751_(((TRexSkullTileEntity)tileEntity).getItemStackFromData().m_41783_());
                Block.m_49840_((Level)world, (BlockPos)blockPos, (ItemStack)stack);
            }
            super.m_6810_(blockState, world, blockPos, otherBlockState, bool);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Extras.trexTileEntity.get()).m_155264_(pos, state);
    }
}

