/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.trex;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zephaniahnoah.minersminerals.extras.Extras;
import com.zephaniahnoah.minersminerals.extras.trex.TRexSkullItemRenderer;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class TRexSkullItem
extends BlockItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private EquipmentSlot slot;

    public TRexSkullItem(Block block, Item.Properties properties) {
        super(block, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = (UUID[])ObfuscationReflectionHelper.getPrivateValue(ArmorItem.class, null, (String)"f_40380_");
        this.slot = EquipmentSlot.HEAD;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[this.slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", 6.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new TRexSkullItemRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slotType) {
        return slotType == this.slot ? this.defaultModifiers : super.m_7167_(slotType);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = itemStack.m_41783_();
        CompoundTag compoundnbt = itemStack.m_41737_("BlockEntityTag");
        if (compoundnbt != null) {
            tag.m_128473_("BlockEntityTag");
        }
        CompoundTag skullData = new CompoundTag();
        skullData.m_128365_("TrexSkullData", (Tag)tag.m_6426_());
        tag.m_128365_("BlockEntityTag", (Tag)skullData);
        return super.m_40576_(context);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.HEAD;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return Extras.skullEnchants.contains(ench);
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return true;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return true;
    }

    public int m_6473_() {
        return 5;
    }
}

