/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.zephaniahnoah.ezmodlib.EzModLib;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class ChunkDecorator {
    public static final String tag = "EzModLibGenTag";
    private static final HashSet<ChunkPos> markedForTagging = new HashSet();
    public static List<ChunkDecorator> decorators = new ArrayList<ChunkDecorator>();

    protected abstract void decorate(ChunkAccess var1, Random var2);

    public static void dec(ChunkAccess chunk) {
        for (ChunkDecorator dec : decorators) {
            dec.decorate(chunk, EzModLib.rand);
        }
        markedForTagging.add(chunk.m_7697_());
    }

    static {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onChunkDataLoad(ChunkDataEvent.Load e) {
                if (e.getWorld() instanceof ServerLevel) {
                    try {
                        CompoundTag data = e.getData();
                        if (!data.m_128441_(ChunkDecorator.tag)) {
                            ChunkDecorator.dec(e.getChunk());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void onChunkLoad(ChunkEvent.Load e) {
                if (e.getWorld() instanceof ServerLevel) {
                    try {
                        CompoundTag nbt = ((ServerLevel)e.getChunk().getWorldForge()).m_7726_().f_8325_.m_63512_(e.getChunk().m_7697_());
                        if (nbt == null || !nbt.m_128441_(ChunkDecorator.tag)) {
                            ChunkDecorator.dec(e.getChunk());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @SubscribeEvent
            public void onChunkDataSave(ChunkDataEvent.Save e) {
                if (e.getWorld() instanceof ServerLevel) {
                    if (markedForTagging.contains(e.getChunk().m_7697_())) {
                        e.getData().m_128379_(ChunkDecorator.tag, false);
                        markedForTagging.remove(e.getChunk().m_7697_());
                    } else {
                        try {
                            CompoundTag nbt = ((ServerLevel)e.getWorld()).m_7726_().f_8325_.m_63512_(e.getChunk().m_7697_());
                            if (nbt != null && nbt.m_128441_(ChunkDecorator.tag)) {
                                e.getData().m_128379_(ChunkDecorator.tag, false);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

