/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.ezmodlib.EzModLib;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicBucketModel;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.SeparatePerspectiveModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.io.IOUtils;

public class ModelInjector {
    private static Set<ResourceLocation> loadingStack;
    private static Map<ResourceLocation, UnbakedModel> unbakedCache;
    private static boolean loadModelLoaders;

    public static void init() {
        if (loadModelLoaders) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("minecraft", "elements"), (IModelLoader)ModelLoaderRegistry.VanillaProxy.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "obj"), (IModelLoader)OBJLoader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "bucket"), (IModelLoader)DynamicBucketModel.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "composite"), (IModelLoader)CompositeModel.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "multi-layer"), (IModelLoader)MultiLayerModel.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "item-layers"), (IModelLoader)ItemLayerModel.Loader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forge", "separate-perspective"), (IModelLoader)SeparatePerspectiveModel.Loader.INSTANCE);
            loadModelLoaders = false;
        }
        unbakedCache = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)ForgeModelBakery.instance(), (String)"f_119212_");
        loadingStack = (Set)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)ForgeModelBakery.instance(), (String)"f_119210_");
        for (Map.Entry<ResourceLocation, Pair<String, Boolean>> entry : EzModLib.itemModels.entrySet()) {
            ModelInjector.model(entry.getKey(), (String)entry.getValue().getFirst(), (Boolean)entry.getValue().getSecond(), false);
        }
        for (Map.Entry<ResourceLocation, Object> entry : EzModLib.blockModels.entrySet()) {
            ModelInjector.model(entry.getKey(), (String)entry.getValue(), false, true);
        }
    }

    private static void model(ResourceLocation loc, String json, boolean tool, boolean block) {
        if (json == "DONT_INJECT") {
            return;
        }
        if (json == "INJECT_EXISTING_MODEL") {
            json = ModelInjector.getExistingModel(loc);
        }
        ResourceLocation resourceLocation = new ResourceLocation(loc.m_135827_(), (block ? "block" : "item") + "/" + loc.m_135815_());
        BlockModel model = BlockModel.m_111463_((String)(json == null ? ModelInjector.json(resourceLocation.toString(), block, tool) : json));
        ModelResourceLocation modelresourcelocation = new ModelResourceLocation(String.valueOf(loc) + "#" + (block ? "" : "inventory"));
        unbakedCache.put((ResourceLocation)modelresourcelocation, (UnbakedModel)model);
        loadingStack.addAll(model.m_7970_());
        unbakedCache.put(resourceLocation, (UnbakedModel)model);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getExistingModel(ResourceLocation res) {
        ResourceLocation location = new ResourceLocation(res.m_135827_(), "models/block/" + res.m_135815_() + ".json");
        try (Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(location);){
            String string;
            block14: {
                InputStream in = resource.m_6679_();
                try {
                    string = IOUtils.toString((InputStream)in, (String)"UTF-8");
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        catch (Exception e) {
            System.out.println("Failed to load " + String.valueOf(res));
            e.printStackTrace();
            return null;
        }
    }

    private static String json(String textureName, boolean block, boolean tool) {
        JsonObject model = new JsonObject();
        JsonObject layer = new JsonObject();
        layer.addProperty(block ? "all" : "layer0", textureName);
        model.addProperty("parent", (String)(block ? "minecraft:block/cube_all" : "minecraft:item/" + (tool ? "handheld" : "generated")));
        model.add("textures", (JsonElement)layer);
        return model.toString();
    }

    static {
        loadModelLoaders = true;
    }
}

