/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SwapMap<A, B>
implements Map<A, B> {
    private final Map<A, B> internalMap;
    private Map<B, A> swap;

    public SwapMap(Map<A, B> map) {
        this.internalMap = map;
    }

    public Map<A, B> getInternalMap() {
        return this.internalMap;
    }

    public Map<B, A> swap() {
        return this.swap == null ? (this.swap = this.internalMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey))) : this.swap;
    }

    private void reset() {
        this.swap = null;
        this.swap();
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public B get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public B put(A key, B value) {
        B map = this.internalMap.put(key, value);
        this.reset();
        return map;
    }

    @Override
    public B remove(Object key) {
        B map = this.internalMap.remove(key);
        this.reset();
        return map;
    }

    @Override
    public void putAll(Map<? extends A, ? extends B> m) {
        this.internalMap.putAll(m);
        this.reset();
    }

    @Override
    public void clear() {
        this.internalMap.clear();
        this.reset();
    }

    @Override
    public Set<A> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<B> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<A, B>> entrySet() {
        return this.internalMap.entrySet();
    }
}

