function initializeCoreMod() {
    return {
        'ezmodlib': {
            'target': {
                'type': 'METHOD',
                'class': 'net.minecraft.world.level.storage.loot.LootTables',
                'methodName': 'm_5787_',
                'methodDesc': '(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V'
            },
            'transformer': function(method) {
                var owner = "com/zephaniahnoah/ezmodlib/LootTableInjector";
                var name = "injectLootTableManager";
                var desc = "(Lnet/minecraft/world/level/storage/loot/LootTables;)V";
                var instr = method.instructions;

                var ASMAPI = Java.type('net.minecraftforge.coremod.api.ASMAPI');
                var Opcodes = Java.type('org.objectweb.asm.Opcodes');
                var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');
                var InsnList = Java.type('org.objectweb.asm.tree.InsnList');
				ASMAPI.log('INFO', 'Patching LootTables#apply');

				var list = new InsnList();
				list.add(new VarInsnNode(Opcodes.ALOAD, 0));
                var methodInsn = ASMAPI.buildMethodCall(
                    owner,
                    name,
                    desc,
                    ASMAPI.MethodType.STATIC);
				list.add(methodInsn);
                var node = instr.getLast().getPrevious();
                instr.insertBefore(node, list);

                return method;
            }
        }
    }
}
