var Opcodes = Java.type("org.objectweb.asm.Opcodes");
var VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
var MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");

function initializeCoreMod() {
    return {
        'ezmodlib': {
            'target': {
                'type': 'CLASS',
                'name': 'net.minecraft.tags.TagManager$LoadResult'
            },
            'transformer': function (classNode) {
                var methods = classNode.methods;
                for (m in methods) {
                    var method = methods[m];
                    if (method.name === "<init>") {
                        var instructions = method.instructions;
                        var firstInstruction = instructions.get(0);

                        // Parameters
                        instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 1));
						instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 2));

                        // Method
                        var injectRecipeMethod = new MethodInsnNode(Opcodes.INVOKESTATIC, "com/zephaniahnoah/ezmodlib/TagInjector", "LoadResult", 
							"(Lnet/minecraft/resources/ResourceKey;Ljava/util/Map;)V", false);
                        instructions.insertBefore(firstInstruction, injectRecipeMethod);
                        break;
                    }
                }
                return classNode;
            }
        }
    }
}