/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.threetag.palladiumcore.event.EntityEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.venturecraft.gliders.common.GliderDamageSource;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.item.ItemRegistry;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class GliderEvents
implements LivingEntityEvents.Attack,
PlayerEvents.Tracking,
LivingEntityEvents.Tick,
EntityEvents.LightningStrike,
LivingEntityEvents.Hurt,
LivingEntityEvents.ItemUse,
PlayerEvents.AnvilUpdate {
    public static void initEvents() {
        GliderEvents instance = new GliderEvents();
        EntityEvents.LIGHTNING_STRIKE.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        LivingEntityEvents.ITEM_USE_START.register((Object)instance);
        LivingEntityEvents.ITEM_USE_TICK.register((Object)instance);
        LivingEntityEvents.ITEM_USE_STOP.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        PlayerEvents.ANVIL_UPDATE.register((Object)instance);
        PlayerEvents.START_TRACKING.register((Object)instance);
        LivingEntityEvents.TICK.register((Object)instance);
    }

    public void lightningStrike(List<Entity> entities, LightningBolt lightningBolt) {
        for (Entity entity : entities) {
            Level level;
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
            if (!hasCopperMod && isGliding) {
                GliderItem.setBroken(chestItem, true);
                return;
            }
            if (!hasCopperMod || !isGliding) continue;
            GliderItem.setStruck(chestItem, true);
            if (!GliderItem.hasBeenStruck(chestItem) || !((level = player.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            player.m_6469_(GliderDamageSource.getSource(serverLevel, GliderDamageSource.ZAP_EXPERIMENT), 2.0f);
        }
    }

    public EventResult livingEntityItemUse(LivingEntity entity, @NotNull ItemStack stack, AtomicInteger duration) {
        return GliderUtil.isGlidingWithActiveGlider(entity) ? EventResult.cancel() : EventResult.pass();
    }

    public EventResult anvilUpdate(Player player, ItemStack left, ItemStack right, String name, AtomicInteger cost, AtomicInteger materialCost, AtomicReference<ItemStack> output) {
        Item item = left.m_41720_();
        if (item instanceof GliderItem) {
            ItemStack data;
            GliderItem gliderItem = (GliderItem)item;
            if (gliderItem.m_6832_(left, right)) {
                data = left.m_41777_();
                GliderItem.setBroken(data, false);
                data.m_41721_(0);
                cost.set(5);
                output.set(data);
            }
            if (right.m_41720_() == ItemRegistry.COPPER_UPGRADE.get()) {
                data = left.m_41777_();
                data = GliderEvents.makeResult(data, "copper");
                cost.set(10);
                output.set(data);
            }
            if (right.m_41720_() == ItemRegistry.NETHER_UPGRADE.get()) {
                data = left.m_41777_();
                data = GliderEvents.makeResult(data, "nether");
                cost.set(10);
                output.set(data);
            }
        }
        return EventResult.pass();
    }

    public static ItemStack makeResult(ItemStack base, String upgrade) {
        ItemStack result = base.m_41777_();
        result.m_41784_().m_128379_(upgrade + "_upgrade", true);
        return result;
    }

    public void livingEntityTick(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GliderData.get((LivingEntity)player).ifPresent(data -> data.tick((LivingEntity)player));
        }
    }

    public void playerTracking(Player tracker, Entity trackedEntity) {
        if (trackedEntity instanceof Player) {
            Player trackedPlayer = (Player)trackedEntity;
            if (tracker instanceof ServerPlayer) {
                ServerPlayer trackerPlayer = (ServerPlayer)tracker;
                GliderData.get((LivingEntity)trackedPlayer).ifPresent(data -> data.syncTo(trackerPlayer));
            }
        }
    }

    public EventResult livingEntityHurt(LivingEntity entity, DamageSource damageSource, AtomicReference<Float> amount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
            boolean isLightning = damageSource.m_276093_(DamageTypes.f_268450_);
            if (hasCopperMod && isGliding && isLightning) {
                return EventResult.cancel();
            }
        }
        return EventResult.pass();
    }

    public EventResult livingEntityAttack(LivingEntity entity, DamageSource damageSource, float amount) {
        Entity entity2 = damageSource.m_7640_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            return GliderUtil.isGlidingWithActiveGlider(livingEntity) ? EventResult.cancel() : EventResult.pass();
        }
        return EventResult.pass();
    }
}

