/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.mining;

import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.MiningRoutines;
import net.picopress.mc.mods.zombietactics2.goals.BreakBlockGoal;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.NotNull;

public class MonsterBreakBlockGoal<T extends class_1588>
extends BreakBlockGoal {
    private final T zombie;

    public MonsterBreakBlockGoal(T zombie) {
        super((class_1308)zombie, Config.hardnessMultiplier, Config.break_speed, Config.dropBlocks);
        this.zombie = zombie;
    }

    protected class_2338[] getCandidate(@NotNull class_1309 liv) {
        double deltaY = liv.method_23318() - this.zombie.method_23318();
        if (deltaY > -2.0 && deltaY < 2.0) {
            return MiningRoutines.routineFlat;
        }
        if (deltaY <= -2.0) {
            return MiningRoutines.routineDown;
        }
        return MiningRoutines.routineUp;
    }

    @Override
    protected boolean checkBlock(class_2338 pos) {
        boolean ret;
        float destroying = this.level.method_8320(pos).method_26204().method_36555();
        boolean bl = ret = super.checkBlock(pos) && (double)destroying <= Config.maxHardness;
        if (ret) {
            this.mine.bp = pos;
            this.mine.bp_vec3 = pos.method_46558();
            this.mine.doMining = true;
        }
        return ret;
    }

    @Override
    public boolean method_6266() {
        return super.method_6266() && this.zombie.method_5707(this.mine.bp_vec3) <= Config.maxDist * Config.maxDist;
    }

    @Override
    public void method_6268() {
        double dist = this.zombie.method_5707(this.mine.bp_vec3);
        if (dist <= Config.minDist || dist > Config.maxDist) {
            this.mine.doMining = false;
            return;
        }
        super.method_6268();
    }

    @Override
    public boolean method_6264() {
        block8: {
            block9: {
                if (!super.method_6264()) {
                    return false;
                }
                double len = this.zombie.method_18798().method_1033();
                if ((len > 0.8 || Config.strictMine && len > 0.1) && !Config.canFly) {
                    return false;
                }
                class_1309 liv = this.zombie.method_5968();
                class_1408 nav = this.zombie.method_5942();
                if (!nav.method_6357() || liv == null || nav.method_6345() == null || nav.method_6345().method_21655()) break block9;
                if (this.zombie.method_42150(liv) && this.zombie.method_6057((class_1297)liv)) {
                    return false;
                }
                if (nav.method_6335((class_1297)liv, (double)this.zombie.method_6029())) {
                    return false;
                }
                class_2338[] set = this.getCandidate(liv);
                int airStack = 0;
                for (class_2338 pos : set) {
                    class_2338 temp = this.zombie.method_24515().method_10081((class_2382)pos.method_10070(Tactics.getRelativeRotation(this.zombie)));
                    if (this.level.method_8320(temp).method_26215()) {
                        ++airStack;
                    }
                    if (airStack != set.length - 1) {
                        if (!this.checkBlock(temp)) continue;
                        return true;
                    }
                    break block8;
                }
                break block8;
            }
            if (!this.zombie.method_5757()) break block8;
            for (class_2338 p : MiningRoutines.routineWall) {
                class_2338 temp = this.zombie.method_24515().method_10081((class_2382)p);
                if (!this.checkBlock(temp)) continue;
                return true;
            }
        }
        return false;
    }
}

