/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.imagetitles;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.imagetitles.Constants;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class ImageTitles {
    private static final Map<String, TitleData> images = new HashMap<String, TitleData>();
    private static TitleData current = null;

    public static void init() {
        Constants.LOG.info("imageTitles init");
    }

    public static void loadImageFiles(class_3300 resourceManager) {
        ImageTitles.clearAllImages();
        ArrayList files = new ArrayList(resourceManager.method_14488("textures/title", path -> path.method_12832().endsWith(".png.mcdata")).keySet());
        Gson gson = new Gson();
        for (class_2960 location : files) {
            try {
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                TitleJson titleJson = (TitleJson)gson.fromJson((Reader)resource.method_43039(), TitleJson.class);
                class_2960 imagePath = class_2960.method_60655((String)location.method_12836(), (String)location.method_12832().replace(".png.mcdata", ".png"));
                images.put(titleJson.title, new TitleData(imagePath, titleJson.x, titleJson.y, titleJson.width, titleJson.height));
            }
            catch (IOException e) {
                Constants.LOG.error("Error loading file \"{}\": {}", (Object)location, (Object)e);
            }
            catch (JsonSyntaxException e) {
                Constants.LOG.error("Error loading json data in file \"{}\": {}", (Object)location, (Object)e);
            }
        }
    }

    public static void setCurrent(class_2561 title) {
        current = images.get(title.getString());
    }

    public static void clearAllImages() {
        images.clear();
        current = null;
    }

    public static boolean renderImage(class_332 guiGraphics, int alpha) {
        if (current == null) {
            return false;
        }
        guiGraphics.method_51448().method_22903();
        float guiScale = (float)class_310.method_1551().method_22683().method_4495();
        guiGraphics.method_51448().method_22905(1.0f / guiScale, 1.0f / guiScale, 1.0f);
        int color = 0xFFFFFF | alpha << 24;
        int width = ImageTitles.current.width;
        int height = ImageTitles.current.height;
        int x = (int)((float)guiGraphics.method_51421() * guiScale * ImageTitles.current.x - (float)width / 2.0f);
        int y = (int)((float)guiGraphics.method_51443() * guiScale * ImageTitles.current.y - (float)height / 2.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ImageTitles.current.texture);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
        bufferbuilder.method_22918(matrix4f, (float)x, (float)(y + height), 0.0f).method_22913(0.0f, 1.0f).method_39415(color);
        bufferbuilder.method_22918(matrix4f, (float)(x + width), (float)(y + height), 0.0f).method_22913(1.0f, 1.0f).method_39415(color);
        bufferbuilder.method_22918(matrix4f, (float)(x + width), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.disableBlend();
        guiGraphics.method_51448().method_22909();
        return true;
    }

    static class TitleJson {
        String title;
        float x = 0.5f;
        float y = 0.25f;
        int width;
        int height;

        TitleJson() {
        }
    }

    static class TitleData {
        public class_2960 texture;
        float x;
        float y;
        public int width;
        public int height;

        public TitleData(class_2960 texture, float x, float y, int width, int height) {
            this.texture = texture;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

