/*
 * Decompiled with CFR 0.152.
 */
package mc.armorhudforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import mc.armorhudforge.gui.ArmorSettingsGui;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jline.utils.Log;

public class ArmorConfig {
    private boolean HudOn;
    private boolean InvHudOn;
    private boolean toggleVerticalMode;
    private int armorX;
    private int armorY;

    public boolean isHudOn() {
        return this.HudOn;
    }

    public void toggleHud() {
        this.HudOn = !this.HudOn;
    }

    public boolean isInvHudOn() {
        return this.InvHudOn;
    }

    public void toggleInvHud() {
        this.InvHudOn = !this.InvHudOn;
    }

    public boolean isVerticalHudOn() {
        return this.toggleVerticalMode;
    }

    public void toggleVerticalHud() {
        this.toggleVerticalMode = !this.toggleVerticalMode;
    }

    public void setArmorX() {
        this.armorX = ArmorSettingsGui.hudX;
    }

    public int getArmorX() {
        return this.armorX;
    }

    public void setArmorY() {
        this.armorY = ArmorSettingsGui.hudY;
    }

    public int getArmorY() {
        return this.armorY;
    }

    public void save() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("armor-hud-config.json");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            Log.error((Object[])new Object[]{"failed to write config file: {}", path.toFile(), e});
        }
    }

    public static ArmorConfig load() {
        block10: {
            ArmorConfig armorConfig;
            block9: {
                Path path = FMLPaths.CONFIGDIR.get().resolve("armor-hud-config.json");
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    armorConfig = (ArmorConfig)new Gson().fromJson((Reader)reader, ArmorConfig.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found!");
                        break block10;
                    }
                    catch (IOException e) {
                        Log.error((Object[])new Object[]{"failed to parse config file: {}", path.toFile(), e});
                    }
                }
                ((Reader)reader).close();
            }
            return armorConfig;
        }
        return new ArmorConfig();
    }
}

