/*
 * Decompiled with CFR 0.152.
 */
package mc.armorhudforge.gui;

import java.util.Objects;
import mc.armorhudforge.ArmorConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ArmorSettingsGui
extends Screen {
    public static volatile int hudX;
    public static volatile int hudY;
    private final ArmorConfig config;

    protected ArmorSettingsGui(ArmorConfig config) {
        super((Component)Component.empty());
        this.config = config;
    }

    private void goBack() {
        Button goBack = Button.builder((Component)Component.nullToEmpty((String)"<-"), btn -> ArmorSettingsGui.close()).pos(20, 25).size(35, 20).build();
        this.addRenderableWidget((GuiEventListener)goBack);
    }

    private void toggleArmorHud() {
        Button toggleArmorHudButton = Button.builder((Component)Component.nullToEmpty((String)"Toggle armor hud"), btn -> {
            this.config.toggleHud();
            this.config.save();
        }).pos(30, 80).size(120, 20).build();
        this.addRenderableWidget((GuiEventListener)toggleArmorHudButton);
    }

    private void isVerticalModeOn() {
        Button isVerticalModeOn = Button.builder((Component)Component.nullToEmpty((String)"Toggle Vertical mode"), btn -> {
            this.config.toggleVerticalHud();
            this.config.save();
        }).pos(30, 110).size(120, 20).build();
        this.addRenderableWidget((GuiEventListener)isVerticalModeOn);
    }

    private void armorHudInput() {
        EditBox inputX = new EditBox(Minecraft.getInstance().font, 270, 80, 30, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)inputX);
        EditBox inputY = new EditBox(Minecraft.getInstance().font, 320, 80, 30, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)inputY);
        Button saveInputValues = Button.builder((Component)Component.nullToEmpty((String)"Save"), btn -> {
            String xValue = inputX.getValue();
            String yValue = inputY.getValue();
            if (xValue != null && yValue != null) {
                if (yValue.isBlank()) {
                    yValue = Integer.toString(this.config.getArmorY());
                } else if (xValue.isBlank()) {
                    xValue = Integer.toString(this.config.getArmorY());
                }
                try {
                    hudX = Integer.parseInt(xValue, 10);
                    hudY = Integer.parseInt(yValue, 10);
                    this.config.setArmorX();
                    this.config.setArmorY();
                    this.config.save();
                }
                catch (NumberFormatException e) {
                    this.onlyNumberToast();
                }
                System.out.println(this.config.getArmorX());
                System.out.println(this.config.getArmorY());
            }
        }).pos(370, 80).size(30, 20).build();
        this.addRenderableWidget((GuiEventListener)saveInputValues);
    }

    protected void init() {
        this.goBack();
        this.toggleArmorHud();
        this.armorHudInput();
        this.isVerticalModeOn();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        super.render(gui, mouseX, mouseY, partialTick);
        Objects.requireNonNull(font);
        gui.drawString(font, "Armor Hud settings", 190, 40 - 9 - 10, -1, true);
        Objects.requireNonNull(font);
        gui.drawString(font, "Armor Hud location", 230, 80 - 9 - 10, -1, true);
        Objects.requireNonNull(font);
        gui.drawString(font, "X: ", 260, 105 - 9 - 10, -1, true);
        Objects.requireNonNull(font);
        gui.drawString(font, "Y: ", 310, 105 - 9 - 10, -1, true);
        String string = "X: " + this.config.getArmorX();
        Objects.requireNonNull(font);
        gui.drawString(font, string, 260, 130 - 9 - 10, -1, true);
        String string2 = "Y: " + this.config.getArmorY();
        Objects.requireNonNull(font);
        gui.drawString(font, string2, 310, 130 - 9 - 10, -1, true);
    }

    public static void open(Component component) {
        Minecraft.getInstance().setScreen((Screen)new ArmorSettingsGui(ArmorConfig.load()));
    }

    public static void close() {
        Minecraft.getInstance().setScreen(null);
    }

    public void onlyNumberToast() {
        Minecraft.getInstance().getToastManager().addToast((Toast)SystemToast.multiline((Minecraft)Minecraft.getInstance(), (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.nullToEmpty((String)"NOTICE!"), (Component)Component.nullToEmpty((String)"Only Use Numbers!")));
    }
}

