/*
 * Decompiled with CFR 0.152.
 */
package mc.armorhudforge.hud;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Function;
import mc.armorhudforge.utils.ArmorUtil;
import mc.armorhudforge.utils.HudPositionUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

public class ArmorHud {
    private final int helmet = 5;
    private final int chestplate = 4;
    private final int leggings = 3;
    private final int boots = 2;
    private final int helmetTools = 3;
    private final int chestplateTools = 2;
    private final int leggingsTools = 1;
    private final int bootsTools = 0;
    private final String[] armorResourceLocations = new String[]{"textures/gui/sprites/container/slot/boots.png", "textures/gui/sprites/container/slot/leggings.png", "textures/gui/sprites/container/slot/chestplate.png", "textures/gui/sprites/container/slot/helmet.png"};
    public static final KeyMapping Key = new KeyMapping("key.keyboard.N", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 78, "key.keyboard.N");

    public void renderArmorAndDamage(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.getInstance();
        new HudPositionUtil().countPos();
        gui.renderItem((ItemStack)ArmorUtil.getArmor(5, Function.identity()), HudPositionUtil.x1, HudPositionUtil.y1);
        gui.renderItem((ItemStack)ArmorUtil.getArmor(4, Function.identity()), HudPositionUtil.x2, HudPositionUtil.y2);
        gui.renderItem((ItemStack)ArmorUtil.getArmor(3, Function.identity()), HudPositionUtil.x3, HudPositionUtil.y3);
        gui.renderItem((ItemStack)ArmorUtil.getArmor(2, Function.identity()), HudPositionUtil.x4, HudPositionUtil.y4);
        if (ArmorUtil.getDamage(5) == 0) {
            this.emptyArmorRenderer(gui, 3, HudPositionUtil.x1, HudPositionUtil.y1, 15);
        } else if (ArmorUtil.getDamage(5) < 100) {
            this.renderDurability(gui, 5, HudPositionUtil.x1, HudPositionUtil.r1, HudPositionUtil.y1);
        } else {
            this.renderDurability(gui, 5, HudPositionUtil.x1, HudPositionUtil.l1, HudPositionUtil.y1);
        }
        if (ArmorUtil.getDamage(4) == 0) {
            this.emptyArmorRenderer(gui, 2, HudPositionUtil.x2, HudPositionUtil.y2, 15);
        } else if (ArmorUtil.getDamage(4) < 100) {
            this.renderDurability(gui, 4, HudPositionUtil.x2, HudPositionUtil.r1, HudPositionUtil.y2);
        } else {
            this.renderDurability(gui, 4, HudPositionUtil.x2, HudPositionUtil.l1, HudPositionUtil.y2);
        }
        if (ArmorUtil.getDamage(3) == 0) {
            this.emptyArmorRenderer(gui, 1, HudPositionUtil.x3, HudPositionUtil.y3, 15);
        } else if (ArmorUtil.getDamage(3) < 100) {
            this.renderDurability(gui, 3, HudPositionUtil.x3, HudPositionUtil.r2, HudPositionUtil.y3);
        } else {
            this.renderDurability(gui, 3, HudPositionUtil.x3, HudPositionUtil.l2, HudPositionUtil.y3);
        }
        if (ArmorUtil.getDamage(2) == 0) {
            this.emptyArmorRenderer(gui, 0, HudPositionUtil.x4, HudPositionUtil.y4, 15);
        } else if (ArmorUtil.getDamage(2) < 100) {
            this.renderDurability(gui, 2, HudPositionUtil.x4, HudPositionUtil.r2, HudPositionUtil.y4);
        } else {
            this.renderDurability(gui, 2, HudPositionUtil.x4, HudPositionUtil.l2, HudPositionUtil.y4);
        }
    }

    private void renderDurability(GuiGraphics gui, int armorId, int x, int textSide, int y) {
        gui.drawString(Minecraft.getInstance().font, String.valueOf(ArmorUtil.getDamage(armorId)), x + textSide, y + 4, -1, true);
    }

    private void emptyArmorRenderer(GuiGraphics gui, int armorId, int x, int y, int size) {
        gui.blitInscribed(ResourceLocation.withDefaultNamespace((String)this.armorResourceLocations[armorId]), x, y, size, size, size, size);
    }
}

