/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.misc.BlockProtectionHelper;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.NullCurrencyType;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnershipAPI;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.PlayerOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.TeamOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.stats.types.IntegerStat;
import io.github.lightman314.lightmanscurrency.api.stats.types.MultiMoneyStat;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesCollectedNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesPaidNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.builtin.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketGroupData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.EntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientCoinSorter;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientMoneyType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.EventCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TextNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankInterestNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ejection.OwnableBlockEjectedNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.CommandTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.GachaTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataBook;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataTicket;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DailyTrades;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DemandPricing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerListing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.AuctionSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.BasicSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.SlotMachineSearchFilter;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.VillagerTradeManager;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import io.github.lightman314.lightmanscurrency.integration.biomesoplenty.BOPCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.claiming.flan.LCFlanIntegration;
import io.github.lightman314.lightmanscurrency.integration.claiming.ftbchunks.LCFTBChunksIntegration;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.ftbteams.LCFTBTeams;
import io.github.lightman314.lightmanscurrency.integration.immersiveengineering.LCImmersive;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCoinData;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    private static CommonProxy PROXY;
    private static final Logger LOGGER;

    @Nonnull
    public static CommonProxy getProxy() {
        return Objects.requireNonNull(PROXY, "Attempted to get the proxy before the mod was initialized!");
    }

    public LightmansCurrency(@Nonnull ModContainer modContainer, @Nonnull IEventBus eventBus, @Nonnull Dist side) {
        PROXY = side.isClient() ? new ClientProxy() : new CommonProxy();
        LootManager.registerDroplistListeners();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::clientSetup);
        LCConfig.init();
        LootManager.init();
        NeoForge.EVENT_BUS.register((Object)this);
        IntegrationUtil.SafeRunIfLoaded("biomesoplenty", BOPCustomWoodTypes::setupWoodTypes, "Error setting up BOP wood types! BOP has probably changed their API!");
        ModRegistries.register(eventBus);
        LightmansCurrency.getProxy().init(eventBus, modContainer);
        IntegrationUtil.SafeRunIfLoaded("ftbchunks", LCFTBChunksIntegration::setup, "Error setting up FTB Chunks chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("flan", LCFlanIntegration::setup, "Error setting up Flans chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("immersiveengineering", LCImmersive::registerRotationBlacklists, null);
        IntegrationUtil.SafeRunIfLoaded("curios", () -> LCCurios.setup(eventBus), "Error setting up Curios Compatibility!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork(event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork(FMLCommonSetupEvent event) {
        ConfigFile.loadServerFiles(ConfigFile.LoadPhase.SETUP);
        IntegrationUtil.SafeRunIfLoaded("impactor", LCImpactorCompat::setup, "Error setting up Impactor Economy Compatibility");
        CoinAPI.API.Setup();
        MoneyAPI.API.RegisterCurrencyType(CoinCurrencyType.INSTANCE);
        MoneyAPI.API.RegisterCurrencyType(NullCurrencyType.INSTANCE);
        MoneyAPI.API.RegisterCurrencyType(AncientMoneyType.INSTANCE);
        CoinAPI.API.RegisterCustomSorter(AncientCoinSorter.INSTANCE);
        OwnershipAPI.API.registerOwnerType(Owner.NULL_TYPE);
        OwnershipAPI.API.registerOwnerType(FakeOwner.TYPE);
        OwnershipAPI.API.registerOwnerType(PlayerOwner.TYPE);
        OwnershipAPI.API.registerOwnerType(TeamOwner.TYPE);
        OwnershipAPI.API.registerPotentialOwnerProvider(PlayerOwnerProvider.INSTANCE);
        OwnershipAPI.API.registerPotentialOwnerProvider(TeamOwnerProvider.INSTANCE);
        TraderAPI.API.RegisterTrader(ItemTraderData.TYPE);
        TraderAPI.API.RegisterTrader(ItemTraderDataArmor.TYPE);
        TraderAPI.API.RegisterTrader(ItemTraderDataTicket.TYPE);
        TraderAPI.API.RegisterTrader(ItemTraderDataBook.TYPE);
        TraderAPI.API.RegisterTrader(SlotMachineTraderData.TYPE);
        TraderAPI.API.RegisterTrader(PaygateTraderData.TYPE);
        TraderAPI.API.RegisterTrader(AuctionHouseTrader.TYPE);
        TraderAPI.API.RegisterTrader(CommandTrader.TYPE);
        TraderAPI.API.RegisterTrader(GachaTrader.TYPE);
        ModGameRules.registerRules();
        TraderAPI.API.RegisterTradeRule(PlayerListing.TYPE);
        TraderAPI.API.RegisterTradeRule(PlayerTradeLimit.TYPE);
        TraderAPI.API.RegisterTradeRule(PlayerDiscounts.TYPE);
        TraderAPI.API.RegisterTradeRule(TimedSale.TYPE);
        TraderAPI.API.RegisterTradeRule(TradeLimit.TYPE);
        TraderAPI.API.RegisterTradeRule(FreeSample.TYPE);
        TraderAPI.API.RegisterTradeRule(PriceFluctuation.TYPE);
        TraderAPI.API.RegisterTradeRule(DemandPricing.TYPE);
        TraderAPI.API.RegisterTradeRule(DailyTrades.TYPE);
        TradeRule.addLoadListener(PlayerListing.LISTENER);
        TradeRule.addIgnoreMissing("lightmanscurrency:whitelist");
        TradeRule.addIgnoreMissing("lightmanscurrency:blacklist");
        NotificationAPI.API.RegisterNotification(ItemTradeNotification.TYPE);
        NotificationAPI.API.RegisterNotification(PaygateNotification.TYPE);
        NotificationAPI.API.RegisterNotification(SlotMachineTradeNotification.TYPE);
        NotificationAPI.API.RegisterNotification(OutOfStockNotification.TYPE);
        NotificationAPI.API.RegisterNotification(LowBalanceNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AuctionHouseSellerNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AuctionHouseBuyerNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AuctionHouseSellerNobidNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AuctionHouseBidNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AuctionHouseCancelNotification.TYPE);
        NotificationAPI.API.RegisterNotification(TextNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AddRemoveAllyNotification.TYPE);
        NotificationAPI.API.RegisterNotification(AddRemoveTradeNotification.TYPE);
        NotificationAPI.API.RegisterNotification(ChangeAllyPermissionNotification.TYPE);
        NotificationAPI.API.RegisterNotification(ChangeCreativeNotification.TYPE);
        NotificationAPI.API.RegisterNotification(ChangeNameNotification.TYPE);
        NotificationAPI.API.RegisterNotification(ChangeOwnerNotification.TYPE);
        NotificationAPI.API.RegisterNotification(ChangeSettingNotification.SIMPLE_TYPE);
        NotificationAPI.API.RegisterNotification(ChangeSettingNotification.ADVANCED_TYPE);
        NotificationAPI.API.RegisterNotification(ChangeSettingNotification.DUMB_TYPE);
        NotificationAPI.API.RegisterNotification(DepositWithdrawNotification.PLAYER_TYPE);
        NotificationAPI.API.RegisterNotification(DepositWithdrawNotification.CUSTOM_TYPE);
        NotificationAPI.API.RegisterNotification(DepositWithdrawNotification.SERVER_TYPE);
        NotificationAPI.API.RegisterNotification(BankTransferNotification.TYPE);
        NotificationAPI.API.RegisterNotification(BankInterestNotification.TYPE);
        NotificationAPI.API.RegisterNotification(TaxesCollectedNotification.TYPE);
        NotificationAPI.API.RegisterNotification(TaxesPaidNotification.TYPE);
        NotificationAPI.API.RegisterNotification(OwnableBlockEjectedNotification.TYPE);
        NotificationAPI.API.RegisterNotification(CommandTradeNotification.TYPE);
        NotificationAPI.API.RegisterNotification(GachaTradeNotification.TYPE);
        NotificationAPI.API.RegisterCategory(NotificationCategory.GENERAL_TYPE);
        NotificationAPI.API.RegisterCategory(NullCategory.TYPE);
        NotificationAPI.API.RegisterCategory(EventCategory.TYPE);
        NotificationAPI.API.RegisterCategory(TraderCategory.TYPE);
        NotificationAPI.API.RegisterCategory(BankCategory.TYPE);
        NotificationAPI.API.RegisterCategory(AuctionHouseCategory.TYPE);
        NotificationAPI.API.RegisterCategory(TaxEntryCategory.TYPE);
        TraderAPI.API.RegisterTraderSearchFilter(new BasicSearchFilter());
        TraderAPI.API.RegisterSearchFilter(new ItemTraderSearchFilter());
        TraderAPI.API.RegisterSearchFilter(new SlotMachineSearchFilter());
        TraderAPI.API.RegisterSearchFilter(new AuctionSearchFilter());
        TaxAPI.API.RegisterReferenceType(TaxableTraderReference.TYPE);
        BankAPI.API.RegisterReferenceType(PlayerBankReference.TYPE);
        BankAPI.API.RegisterReferenceType(TeamBankReference.TYPE);
        MenuValidatorType.register(SimpleValidator.TYPE);
        MenuValidatorType.register(BlockEntityValidator.TYPE);
        MenuValidatorType.register(BlockValidator.TYPE);
        MenuValidatorType.register(EntityValidator.TYPE);
        ItemTradeRestriction.init();
        TicketGroupData.create((ItemLike)ModItems.TICKET_MASTER.get(), (ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_PAPER);
        TicketGroupData.create((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get(), (ItemLike)ModItems.GOLDEN_TICKET.get(), (ItemLike)ModItems.GOLDEN_TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_GOLD);
        ItemListingSerializer.registerDefaultSerializers();
        VillagerTradeManager.registerDefaultTrades();
        IconData.registerDefaultIcons();
        StatType.register(IntegerStat.INSTANCE);
        StatType.register(MultiMoneyStat.INSTANCE);
        BlockProtectionHelper.ProtectBlock(b -> b instanceof IOwnableBlock);
        BlockProtectionHelper.ProtectBlock(b -> b instanceof CoinBlock);
        IntegrationUtil.SafeRunIfLoaded("ftbteams", LCFTBTeams::setup, "Error setting up FTB Teams compat!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", LightmansCurrency.getProxy()::setupClient);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player target = event.getEntity();
        SPacketSyncTime.syncWith(target);
        LCAdminMode.sendSyncPacket(target);
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogDebug(String message, Object ... objects) {
        LOGGER.debug(message, objects);
    }

    public static void LogInfo(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogInfo(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message, objects);
        } else {
            LOGGER.info(message, objects);
        }
    }

    public static void LogWarning(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogWarning(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message, objects);
        } else {
            LOGGER.warn(message, objects);
        }
    }

    public static void LogError(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    public static <T extends ParallelDispatchEvent> void safeEnqueueWork(T event, String errorMessage, Consumer<T> work) {
        event.enqueueWork(() -> {
            try {
                work.accept(event);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    private void setupConfigTasks(RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new SyncCoinDataTask());
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private static class SyncCoinDataTask
    implements ICustomConfigurationTask {
        private SyncCoinDataTask() {
        }

        @Nonnull
        public ConfigurationTask.Type type() {
            return SPacketSyncCoinData.CONFIG_TYPE;
        }

        public void run(@Nonnull Consumer<CustomPacketPayload> sender) {
            sender.accept(CoinAPI.API.getSyncPacket().configTask());
        }
    }
}

