/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DoubleOption
extends ConfigOption<Double> {
    private final double lowerLimit;
    private final double upperLimit;
    private final ConfigParser<Double> parser;

    public static ConfigParser<Double> makeParser(double lowerLimit, double upperLimit) {
        return new Parser(lowerLimit, upperLimit);
    }

    protected DoubleOption(@Nonnull Supplier<Double> defaultValue, double lowerLimit, double upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = DoubleOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    @Nonnull
    protected ConfigParser<Double> getParser() {
        return this.parser;
    }

    @Override
    @Nonnull
    protected List<String> bonusComments() {
        return Lists.newArrayList((Object[])new String[]{"Range: " + this.lowerLimit + " -> " + this.upperLimit, "Default: " + String.valueOf(this.getDefaultValue())});
    }

    public static DoubleOption create(double defaultValue) {
        return new DoubleOption(() -> defaultValue, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static DoubleOption create(double defaultValue, double lowerLimit) {
        return new DoubleOption(() -> defaultValue, lowerLimit, Double.MAX_VALUE);
    }

    public static DoubleOption create(double defaultValue, double lowerLimit, double upperLimit) {
        return new DoubleOption(() -> defaultValue, lowerLimit, upperLimit);
    }

    public static DoubleOption create(@Nonnull Supplier<Double> defaultValue) {
        return new DoubleOption(defaultValue, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static DoubleOption create(@Nonnull Supplier<Double> defaultValue, double lowerLimit) {
        return new DoubleOption(defaultValue, lowerLimit, Double.MAX_VALUE);
    }

    public static DoubleOption create(@Nonnull Supplier<Double> defaultValue, double lowerLimit, double upperLimit) {
        return new DoubleOption(defaultValue, lowerLimit, upperLimit);
    }

    private static class Parser
    implements ConfigParser<Double> {
        private final double lowerLimit;
        private final double upperLimit;

        private Parser(double lowerLimit, double upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        @Nonnull
        public Double tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            try {
                return MathUtil.clamp(Double.parseDouble(cleanLine), this.lowerLimit, this.upperLimit);
            }
            catch (NumberFormatException e) {
                throw new ConfigParsingException("Error parsing double!", e);
            }
        }

        @Override
        @Nonnull
        public String write(@Nonnull Double value) {
            return value.toString();
        }
    }
}

