/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ejection.builtin;

import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionDataType;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.common.menus.containers.NonEmptyContainer;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class BasicEjectionData
extends EjectionData {
    public static final EjectionDataType TYPE = new Type();
    private final Component name;
    private final Container contents;
    private final OwnerData owner;

    public BasicEjectionData(@Nonnull OwnerData owner, @Nonnull List<ItemStack> contents, @Nonnull Component name) {
        this(owner, (Container)InventoryUtil.buildInventory(contents), name);
    }

    public BasicEjectionData(@Nonnull OwnerData owner, @Nonnull Container contents, @Nonnull Component name) {
        this.name = name;
        this.contents = new NonEmptyContainer(contents);
        this.owner = new OwnerData(this);
        this.owner.copyFrom(owner);
    }

    @Override
    @Nonnull
    public OwnerData getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public Component getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public EjectionDataType getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public Container getContents() {
        return this.contents;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        tag.put("Owner", (Tag)this.owner.save(lookup));
        tag.putString("Name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
        tag.putInt("Size", this.contents.getContainerSize());
        InventoryUtil.saveAllItems("Contents", tag, this.contents, lookup);
    }

    private static class Type
    extends EjectionDataType {
        private Type() {
        }

        @Override
        @Nonnull
        public EjectionData load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            OwnerData owner = new OwnerData(IClientTracker.forClient());
            owner.load(tag, lookup);
            MutableComponent name = Component.Serializer.fromJson((String)tag.getString("Name"), (HolderLookup.Provider)lookup);
            SimpleContainer contents = InventoryUtil.loadAllItems("Contents", tag, tag.getInt("Size"), lookup);
            return new BasicEjectionData(owner, (Container)contents, (Component)name);
        }
    }
}

