/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class ATMIconData {
    protected final int xPos;
    protected final int yPos;

    protected ATMIconData(@Nonnull JsonObject data) throws JsonSyntaxException, ResourceLocationException {
        this.xPos = GsonHelper.getAsInt((JsonObject)data, (String)"x");
        this.yPos = GsonHelper.getAsInt((JsonObject)data, (String)"y");
    }

    protected ATMIconData(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    @Nonnull
    public final JsonObject save(@Nonnull HolderLookup.Provider lookup) {
        JsonObject data = new JsonObject();
        data.addProperty("type", this.getType().toString());
        data.addProperty("x", (Number)this.xPos);
        data.addProperty("y", (Number)this.yPos);
        this.saveAdditional(data, lookup);
        return data;
    }

    @Nonnull
    protected abstract ResourceLocation getType();

    protected abstract void saveAdditional(@Nonnull JsonObject var1, @Nonnull HolderLookup.Provider var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(@Nonnull ATMExchangeButton var1, @Nonnull EasyGuiGraphics var2, boolean var3);
}

