/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.easy_data.EasyData;
import io.github.lightman314.lightmanscurrency.api.easy_data.IEasyDataHost;
import io.github.lightman314.lightmanscurrency.api.easy_data.categories.DataCategories;
import io.github.lightman314.lightmanscurrency.api.easy_data.complex.types.IconDataData;
import io.github.lightman314.lightmanscurrency.api.easy_data.types.BoolData;
import io.github.lightman314.lightmanscurrency.api.easy_data.types.StringData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IPermissions;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.misc.world.WorldPosition;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.api.ownership.IOwnable;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.stats.StatKey;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.stats.StatTracker;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.builtin.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.api.traders.FullTradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.IFlexibleOfferTrader;
import io.github.lightman314.lightmanscurrency.api.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.api.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.api.traders.easy_data.TraderNotificationReplacers;
import io.github.lightman314.lightmanscurrency.api.traders.menu.customer.ITraderScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.BooleanPermission;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.AllyTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.CreativeSettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.MiscTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.NameTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.OwnershipTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.PermissionsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.PersistentTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.TaxSettingsTab;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.TraderEjectionData;
import io.github.lightman314.lightmanscurrency.common.items.data.TraderItemData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketSyncUsers;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TraderData
implements ISidedObject,
IDumpable,
IUpgradeable,
ITraderSource,
ITradeRuleHost,
ITaxable,
IOwnable,
IEasyDataHost,
IPermissions {
    public static final int GLOBAL_TRADE_LIMIT = 100;
    private final List<EasyData<?>> easyData = new ArrayList();
    private boolean canMarkDirty = false;
    public final TraderType<?> type;
    private long id = -1L;
    @Nullable
    private TradeEvent.PostTradeEvent latestTrade = null;
    private boolean alwaysShowOnTerminal = false;
    private TraderState state = TraderState.NORMAL;
    public final BoolData creative = BoolData.builder(false).host(this).key("creative").tagKey("Creative").name((Component)LCText.DATA_ENTRY_CREATIVE.get(new Object[0])).category(DataCategories.Traders.CREATIVE).notificationReplacer(TraderNotificationReplacers.CREATIVE_NOTIFICATION).build();
    public final BoolData storeCreativeMoney = BoolData.builder(false).host(this).key("store_money_in_creative").tagKey("StoreCreativeMoney").name((Component)LCText.DATA_ENTRY_STORE_CREATIVE_MONEY.get(new Object[0])).category(DataCategories.Traders.CREATIVE).build();
    private boolean isClient = false;
    private final OwnerData owner = new OwnerData((IClientTracker)this, () -> this.markDirty(this::saveOwner));
    public final StatTracker statTracker = new StatTracker(() -> {}, this);
    private final List<PlayerReference> allies = new ArrayList<PlayerReference>();
    private final Map<String, Integer> allyPermissions = this.getDefaultAllyPermissions();
    private final NotificationData logger = new NotificationData();
    public final StringData customName = StringData.builder().host(this).key("name").tagKey("Name").category(DataCategories.Traders.DISPLAY).name((Component)LCText.DATA_ENTRY_TRADER_NAME.get(new Object[0])).build();
    public final IconDataData customIcon = IconDataData.builder().host(this).key("trader_icon").tagKey("CustomIcon").name((Component)LCText.DATA_ENTRY_TRADER_ICON.get(new Object[0])).category(DataCategories.Traders.DISPLAY).build();
    private Item traderBlock;
    private ResourceLocation blockVariant;
    private final MoneyStorage storedMoney = new MoneyStorage(() -> this.markDirty(this::saveStoredMoney));
    public final BoolData linkedToBank = BoolData.builder(false).host(this).key("linked_to_bank").tagKey("LinkedToBank").name((Component)LCText.DATA_ENTRY_TRADER_BANK_LINK.get(new Object[0])).category(DataCategories.Traders.BANK).build();
    private SimpleContainer upgrades;
    private List<TradeRule> rules = new ArrayList<TradeRule>();
    private boolean alwaysShowSearchBox = false;
    private boolean notificationsEnabled = false;
    private boolean notificationsToChat = true;
    private int teamNotificationLevel = 0;
    private int acceptableTaxRate = 99;
    private final List<Long> ignoredTaxCollectors = new ArrayList<Long>();
    private boolean ignoreAllTaxes = false;
    private WorldPosition worldPosition = WorldPosition.VOID;
    private String persistentID = "";
    private int userCount = 0;
    private final List<Player> currentUsers = new ArrayList<Player>();

    @Override
    public void registerData(EasyData<?> data) {
        if (!this.easyData.contains(data)) {
            this.easyData.add(data);
        }
    }

    public final TraderData allowMarkingDirty() {
        this.canMarkDirty = true;
        return this;
    }

    @Override
    public final RegistryAccess registryAccess() {
        return LookupHelper.getRegistryAccess();
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean allowAccess() {
        return this.getState().allowAccess;
    }

    public boolean isRecoverable() {
        return this.getState().allowRecovery;
    }

    public boolean hasWorldPosition() {
        return !this.worldPosition.isVoid() && this.getState().validateWorldPosition;
    }

    public void setAlwaysShowOnTerminal() {
        this.alwaysShowOnTerminal = true;
        this.markDirty(this::saveShowOnTerminal);
    }

    public boolean shouldAlwaysShowOnTerminal() {
        return this.alwaysShowOnTerminal;
    }

    public boolean canShowOnTerminal() {
        return true;
    }

    public boolean showOnTerminal() {
        if (!this.allowAccess() || this.isInQuarantine()) {
            return false;
        }
        if (this.alwaysShowOnTerminal) {
            return true;
        }
        return this.hasNetworkUpgrade();
    }

    protected final boolean hasNetworkUpgrade() {
        return UpgradeType.hasUpgrade(Upgrades.NETWORK, (Container)this.upgrades);
    }

    protected boolean allowVoidUpgrade() {
        return false;
    }

    protected final boolean shouldStoreGoods() {
        return this.creative.get() == false && !UpgradeType.hasUpgrade(Upgrades.VOID, (Container)this.upgrades);
    }

    public boolean readyForCustomers() {
        return this.hasValidTrade();
    }

    public TraderState getState() {
        return this.state;
    }

    public void setState(TraderState state) {
        if (this.state == state) {
            return;
        }
        if (this.state == TraderState.PERSISTENT) {
            LightmansCurrency.LogError("Cannot change the state of a persistent trader!");
            return;
        }
        this.state = state;
        this.markDirty(this::saveState);
    }

    public void PickupTrader(Player player, boolean adminState) {
        MinecraftServer server;
        if (this.isClient() || this.state != TraderState.NORMAL) {
            return;
        }
        if (!LCAdminMode.isAdminPlayer(player)) {
            adminState = false;
        }
        if ((server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ItemStack result;
            if (this.shouldRemove(server)) {
                return;
            }
            TraderBlockEntity<?> be = this.getBlockEntity();
            if (be != null && !(result = be.PickupTrader(player, this)).isEmpty()) {
                this.setState(adminState ? TraderState.ADMIN_HELD_AS_ITEM : TraderState.HELD_AS_ITEM);
                result.set(ModDataComponents.TRADER_ITEM_DATA, (Object)new TraderItemData(this.id));
                if (this.blockVariant != null) {
                    result.set(ModDataComponents.MODEL_VARIANT, (Object)this.blockVariant);
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
            }
        }
    }

    public void OnTraderMoved(WorldPosition newPosition) {
        this.setState(TraderState.NORMAL);
        this.worldPosition = newPosition;
        this.markDirty(this::saveLevelData);
    }

    public boolean isCreative() {
        return this.creative.get();
    }

    public boolean canStoreMoney() {
        return this.creative.get() == false || this.storeCreativeMoney.get() != false;
    }

    @Override
    public final TraderData flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    public final TraderData flagAsClient(boolean isClient) {
        this.isClient = isClient;
        this.logger.flagAsClient(this);
        return this;
    }

    @Override
    public final TraderData flagAsClient(IClientTracker context) {
        return this.flagAsClient(context.isClient());
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public final OwnerData getOwner() {
        return this.owner;
    }

    public final List<PlayerReference> getAllies() {
        return new ArrayList<PlayerReference>(this.allies);
    }

    public final void overwriteAllies(List<PlayerReference> allies) {
        this.allies.clear();
        this.allies.addAll(allies);
        this.markDirty(this::saveAllies);
    }

    public final Set<String> getAllyPermissionKeys() {
        return this.allyPermissions.keySet();
    }

    public final Map<String, Integer> getAllyPermissionMap() {
        return new HashMap<String, Integer>(this.allyPermissions);
    }

    public void overwriteAllyPermissions(Map<String, Integer> allyPermissions) {
        this.allyPermissions.clear();
        this.allyPermissions.putAll(allyPermissions);
        this.markDirty(this::saveAllyPermissions);
    }

    private Map<String, Integer> getDefaultAllyPermissions() {
        HashMap<String, Integer> defaultValues = new HashMap<String, Integer>();
        defaultValues.put("openStorage", 1);
        defaultValues.put("editTrades", 1);
        defaultValues.put("editTradeRules", 1);
        defaultValues.put("editSettings", 1);
        defaultValues.put("changeName", 1);
        defaultValues.put("viewLogs", 1);
        this.modifyDefaultAllyPermissions(defaultValues);
        return defaultValues;
    }

    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
    }

    public List<String> getBlockedPermissions() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasPermission(Player player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    @Override
    public boolean hasPermission(PlayerReference player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    @Override
    public int getPermissionLevel(Player player, String permission) {
        if (this.isPersistent() && player != null && this.persistentTraderBlockedPermissions().contains((Object)permission)) {
            return 0;
        }
        if (player != null && this.getBlockedPermissions().contains(permission)) {
            return 0;
        }
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(player)) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    @Override
    public int getPermissionLevel(PlayerReference player, String permission) {
        if (this.isPersistent() && player != null && this.persistentTraderBlockedPermissions().contains((Object)permission)) {
            return 0;
        }
        if (player != null && this.getBlockedPermissions().contains(permission)) {
            return 0;
        }
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(player)) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    public final ImmutableList<String> persistentTraderBlockedPermissions() {
        ArrayList blockedPermissions = Lists.newArrayList((Object[])new String[]{"editTrades", "editSettings", "interactionLink", "transferOwnership", "collectCoins", "storeCoins"});
        this.blockPermissionsForPersistentTrader(blockedPermissions);
        return ImmutableList.copyOf((Collection)blockedPermissions);
    }

    protected void blockPermissionsForPersistentTrader(List<String> list) {
    }

    public int getAllyPermissionLevel(String permission) {
        return this.allyPermissions.getOrDefault(permission, 0);
    }

    public void setAllyPermissionLevel(Player player, String permission, int level) {
        if (this.hasPermission(player, "editPermissions") && this.getAllyPermissionLevel(permission) != level) {
            int oldLevel = this.getAllyPermissionLevel(permission);
            this.allyPermissions.put(permission, level);
            this.markDirty(this::saveAllyPermissions);
            if (player != null) {
                this.pushLocalNotification(new ChangeAllyPermissionNotification(PlayerReference.of(player), permission, level, oldLevel));
            }
        }
    }

    private boolean isAdmin(Player player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAdmin(PlayerReference player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAlly(Player player) {
        if (this.owner.isMember(player)) {
            return true;
        }
        return PlayerReference.isInList(this.allies, (Entity)player);
    }

    private boolean isAlly(PlayerReference player) {
        if (this.owner.isMember(player)) {
            return true;
        }
        return PlayerReference.isInList(this.allies, player);
    }

    public final List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public final void deleteNotification(Player player, int notificationIndex) {
        if (this.hasPermission(player, "transferOwnership")) {
            this.logger.deleteNotification(notificationIndex);
            this.markDirty(this::saveLogger);
        }
    }

    public boolean hasCustomName() {
        return !this.customName.get().isBlank();
    }

    public IconData getDisplayIcon() {
        return this.customIcon.get().isNull() ? this.getIcon() : this.customIcon.get();
    }

    public abstract IconData getIcon();

    @Override
    public MutableComponent getName() {
        if (this.hasCustomName()) {
            return EasyText.literal(this.customName.get());
        }
        return this.getDefaultName();
    }

    public final MutableComponent getTitle() {
        if (this.creative.get().booleanValue()) {
            return this.getName();
        }
        return LCText.GUI_TRADER_TITLE.get(this.getName(), this.owner.getName());
    }

    public IconData getIconForItem(ItemStack stack) {
        return this.getIconForItem(stack, this.customIcon.get());
    }

    protected IconData getIconForItem(ItemStack stack, IconData originalIcon) {
        return IconData.of(stack.copyWithCount(1));
    }

    @Nullable
    public Item getTraderBlock() {
        return this.traderBlock;
    }

    protected MutableComponent getDefaultName() {
        if (this.traderBlock != null) {
            return EasyText.literal(new ItemStack((ItemLike)this.traderBlock).getHoverName().getString());
        }
        return LCText.GUI_TRADER_DEFAULT_NAME.get(new Object[0]);
    }

    @Nullable
    public ResourceLocation getTraderBlockVariant() {
        return this.blockVariant;
    }

    public void setTraderBlockVariant(@Nullable ResourceLocation blockVariant) {
        this.blockVariant = blockVariant;
        this.markDirty(this::saveTraderItem);
    }

    @Override
    public void onDataChanged(EasyData<?> data) {
        this.markDirty(data::write);
    }

    public IMoneyHolder getStoredMoney() {
        IBankAccount ba = this.getBankAccount();
        if (ba != null) {
            return ba.getMoneyStorage();
        }
        return this.getInternalStoredMoney();
    }

    public MoneyStorage getInternalStoredMoney() {
        return this.storedMoney;
    }

    public MoneyValue addStoredMoney(MoneyValue amount, boolean shouldTax) {
        IBankAccount ba;
        if (amount == null) {
            return MoneyValue.empty();
        }
        MoneyValue taxesPaid = MoneyValue.empty();
        if (shouldTax) {
            taxesPaid = this.payTaxesOn(amount);
            if (!amount.containsValue(taxesPaid)) {
                this.removeStoredMoney(taxesPaid.subtractValue(amount), false);
                return taxesPaid;
            }
            if ((amount = amount.subtractValue(taxesPaid)).isEmpty()) {
                return taxesPaid;
            }
        }
        if ((ba = this.getBankAccount()) != null) {
            ba.depositMoney(amount);
            if (ba instanceof BankAccount) {
                BankAccount ba2 = (BankAccount)ba;
                ba2.LogInteraction(this, amount, true);
            }
            return taxesPaid;
        }
        this.storedMoney.addValue(amount);
        return taxesPaid;
    }

    public MoneyValue removeStoredMoney(MoneyValue amount, boolean shouldTax) {
        IBankAccount ba;
        MoneyValue taxesPaid = MoneyValue.empty();
        if (shouldTax && !(taxesPaid = this.payTaxesOn(amount)).isEmpty()) {
            amount = amount.addValue(taxesPaid);
        }
        if ((ba = this.getBankAccount()) != null) {
            ba.withdrawMoney(amount);
            if (ba instanceof BankAccount) {
                BankAccount ba2 = (BankAccount)ba;
                ba2.LogInteraction(this, amount, false);
            }
            return taxesPaid;
        }
        this.storedMoney.removeValue(amount);
        return taxesPaid;
    }

    public void CollectStoredMoney(Player player) {
        if (this.hasPermission(player, "collectCoins")) {
            MoneyStorage storedMoney = this.getInternalStoredMoney();
            if (storedMoney.isEmpty()) {
                return;
            }
            storedMoney.GiveToPlayer(player);
        } else {
            Permissions.PermissionWarning(player, "collect stored coins", "collectCoins");
        }
    }

    public final MoneyValue payTaxesOn(MoneyValue amount) {
        MoneyValue paidCache = MoneyValue.empty();
        for (ITaxCollector tax : this.getApplicableTaxes()) {
            MoneyValue paid;
            MoneyValue temp;
            if (this.ShouldIgnoreTaxEntry(tax) || (temp = paidCache.addValue(paid = tax.CalculateAndPayTaxes(this, amount))).isEmpty()) continue;
            paidCache = temp;
        }
        return paidCache;
    }

    protected boolean isInQuarantine() {
        ResourceKey<Level> level = this.worldPosition.getDimension();
        return level != null && QuarantineAPI.IsDimensionQuarantined(level);
    }

    public boolean canLinkBankAccount() {
        BankReference reference = this.owner.getValidOwner().asBankReference();
        return !this.isInQuarantine() && reference != null && reference.get() != null;
    }

    private void onBankLinkChanged(boolean newState) {
        if (newState) {
            if (this.isInQuarantine()) {
                this.linkedToBank.set(false);
            } else {
                IBankAccount account = this.getBankAccount();
                if (account != null) {
                    for (MoneyValue value : this.storedMoney.allValues()) {
                        account.depositMoney(value);
                    }
                    this.storedMoney.clear();
                } else {
                    this.linkedToBank.set(false);
                }
            }
        }
    }

    public boolean hasBankAccount() {
        return this.getBankAccount() != null;
    }

    public IBankAccount getBankAccount() {
        BankReference reference;
        if (this.linkedToBank.get().booleanValue() && !this.isInQuarantine() && (reference = this.owner.getValidOwner().asBankReference()) != null) {
            return reference.get();
        }
        return null;
    }

    @Override
    public Container getUpgrades() {
        return this.upgrades;
    }

    @Override
    public final boolean allowUpgrade(UpgradeType type) {
        if (type == Upgrades.NETWORK && !this.showOnTerminal() && this.canShowOnTerminal()) {
            return true;
        }
        if (type == Upgrades.VOID && this.allowVoidUpgrade()) {
            return true;
        }
        if (this instanceof IFlexibleOfferTrader && type == Upgrades.TRADE_OFFERS) {
            return true;
        }
        return this.allowAdditionalUpgradeType(type);
    }

    protected abstract boolean allowAdditionalUpgradeType(UpgradeType var1);

    @Override
    public List<TradeRule> getRules() {
        return Lists.newArrayList(this.rules);
    }

    protected void validateRules() {
        TradeRule.ValidateTradeRuleList(this.rules, this);
    }

    public final boolean alwaysShowSearchBox() {
        return this.alwaysShowSearchBox;
    }

    public final void setAlwaysShowSearchBox(Player player, boolean newVal) {
        if (this.hasPermission(player, "editSettings") && this.alwaysShowSearchBox != newVal) {
            this.alwaysShowSearchBox = newVal;
            this.markDirty(this::saveMiscSettings);
        }
    }

    @Override
    public boolean showSearchBox() {
        return this.alwaysShowSearchBox;
    }

    public boolean notificationsEnabled() {
        return this.notificationsEnabled;
    }

    public boolean notificationsToChat() {
        return this.notificationsToChat;
    }

    public int teamNotificationLevel() {
        return this.teamNotificationLevel;
    }

    public abstract int getTradeCount();

    public boolean canEditTradeCount() {
        return false;
    }

    public int getMaxTradeCount() {
        return 1;
    }

    public abstract int getTradeStock(int var1);

    public int validTradeCount() {
        return (int)this.getTradeData().stream().filter(TradeData::isValid).count();
    }

    public boolean hasValidTrade() {
        return this.getTradeData().stream().anyMatch(TradeData::isValid);
    }

    public int tradesWithStock() {
        TradeContext context = TradeContext.createStorageMode(this);
        return (int)this.getTradeData().stream().filter(t -> t.isValid() && t.hasStock(context)).count();
    }

    public boolean anyTradeHasStock() {
        TradeContext context = TradeContext.createStorageMode(this);
        return this.getTradeData().stream().anyMatch(t -> t.isValid() && t.hasStock(context));
    }

    public boolean supportsMultiPriceEditing() {
        return true;
    }

    public final int getAcceptableTaxRate() {
        return this.acceptableTaxRate;
    }

    public boolean ShouldIgnoreAllTaxes() {
        return this.ignoreAllTaxes;
    }

    public boolean ShouldIgnoreTaxEntryOnly(ITaxCollector entry) {
        return this.ignoredTaxCollectors.contains(entry.getID());
    }

    public void FlagTaxEntryToIgnore(TaxEntry entry, Player player) {
        if (this.ignoredTaxCollectors.contains(entry.getID())) {
            return;
        }
        if (!LCAdminMode.isAdminPlayer(player)) {
            Permissions.PermissionWarning(player, "ignore tax collector", "LC_ADMIN_MODE");
            return;
        }
        this.ignoredTaxCollectors.add(entry.getID());
        this.markDirty(this::saveTaxSettings);
    }

    public void PardonTaxEntry(TaxEntry entry) {
        if (this.ignoredTaxCollectors.contains(entry.getID())) {
            this.ignoredTaxCollectors.remove(entry.getID());
            this.markDirty(this::saveTaxSettings);
        }
    }

    private boolean AllowTaxEntry(ITaxCollector entry) {
        return !this.ShouldIgnoreTaxEntry(entry);
    }

    public boolean ShouldIgnoreTaxEntry(ITaxCollector entry) {
        return this.ShouldIgnoreAllTaxes() || this.ShouldIgnoreTaxEntryOnly(entry);
    }

    public ResourceKey<Level> getLevel() {
        return this.worldPosition.getDimension();
    }

    public BlockPos getPos() {
        return this.worldPosition.getPos();
    }

    @Nullable
    public TraderBlockEntity<?> getBlockEntity() {
        TraderBlockEntity be;
        BlockEntity blockEntity;
        Level level = LightmansCurrency.getProxy().getDimension(this.isClient, this.getLevel());
        if (level != null && level.isLoaded(this.worldPosition.getPos()) && (blockEntity = level.getBlockEntity(this.worldPosition.getPos())) instanceof TraderBlockEntity && (be = (TraderBlockEntity)blockEntity).getTraderID() == this.id) {
            return be;
        }
        return null;
    }

    @Override
    public TaxableReference getReference() {
        return new TaxableTraderReference(this.getID());
    }

    @Override
    public WorldPosition getWorldPosition() {
        return this.worldPosition;
    }

    public final List<ITaxCollector> getApplicableTaxes() {
        return TaxAPI.API.GetTaxCollectorsFor(this).stream().filter(this::AllowTaxEntry).toList();
    }

    public final List<ITaxCollector> getPossibleTaxes() {
        return TaxAPI.API.GetPotentialTaxCollectorsFor(this);
    }

    public final int getTotalTaxPercentage() {
        List<ITaxCollector> entries = this.getApplicableTaxes();
        int taxPercentage = 0;
        for (ITaxCollector entry : entries) {
            taxPercentage += entry.getTaxRate();
        }
        return taxPercentage;
    }

    public final boolean exceedsAcceptableTaxRate() {
        return this.getTotalTaxPercentage() > this.acceptableTaxRate;
    }

    public void move(Level level, BlockPos pos) {
        this.worldPosition = WorldPosition.ofLevel(level, pos);
        if (this.id >= 0L) {
            this.markDirty(this::saveLevelData);
        }
    }

    protected TraderData(TraderType<?> type) {
        this.type = type;
        this.upgrades = new SimpleContainer(5);
        this.upgrades.addListener(this::upgradesChanged);
        this.linkedToBank.addListener(this::onBankLinkChanged);
    }

    protected TraderData(TraderType<?> type, Level level, BlockPos pos) {
        this(type);
        this.worldPosition = WorldPosition.ofLevel(level, pos);
        this.traderBlock = level.getBlockState(this.worldPosition.getPos()).getBlock().asItem();
    }

    private void upgradesChanged(Container container) {
        if (container == this.upgrades) {
            this.markDirty(this::saveUpgrades);
            TraderData traderData = this;
            if (traderData instanceof IFlexibleOfferTrader) {
                IFlexibleOfferTrader fot = (IFlexibleOfferTrader)((Object)traderData);
                fot.refactorTrades();
            }
        }
    }

    public boolean isPersistent() {
        return !this.persistentID.isEmpty();
    }

    public String getPersistentID() {
        return this.persistentID;
    }

    public void makePersistent(long id, String persistentID) {
        this.state = TraderState.PERSISTENT;
        this.id = id;
        this.persistentID = persistentID;
        this.creative.set(true);
        this.alwaysShowOnTerminal = true;
    }

    protected final void markDirty(CompoundTag updateData) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        updateData.putLong("ID", this.id);
        TraderDataCache.TYPE.get(false).markTraderDirty(updateData);
    }

    protected final void markDirty(Consumer<CompoundTag> updateWriter) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        CompoundTag updateData = new CompoundTag();
        updateWriter.accept(updateData);
        this.markDirty(updateData);
    }

    protected final void markDirty(BiConsumer<CompoundTag, HolderLookup.Provider> updateWriter) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        CompoundTag updateData = new CompoundTag();
        updateWriter.accept(updateData, (HolderLookup.Provider)LookupHelper.getRegistryAccess());
        this.markDirty(updateData);
    }

    public final CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        compound.putString("Type", this.type.toString());
        compound.putLong("ID", this.id);
        this.saveState(compound);
        this.saveLevelData(compound);
        this.saveTraderItem(compound);
        this.saveOwner(compound, lookup);
        this.saveAllies(compound);
        this.saveAllyPermissions(compound);
        this.saveShowOnTerminal(compound);
        this.saveRules(compound, lookup);
        this.saveUpgrades(compound, lookup);
        this.saveStoredMoney(compound);
        this.saveLogger(compound, lookup);
        this.saveMiscSettings(compound);
        this.saveTaxSettings(compound);
        this.saveStatistics(compound, lookup);
        if (!this.persistentID.isEmpty()) {
            compound.putString("PersistentTraderID", this.persistentID);
        }
        for (EasyData<?> data : this.easyData) {
            data.write(compound, lookup);
        }
        this.saveAdditional(compound, lookup);
        return compound;
    }

    private void saveState(CompoundTag compoundTag) {
        compoundTag.putString("State", this.state.toString());
    }

    public final void saveLevelData(CompoundTag compound) {
        compound.put("Location", (Tag)this.worldPosition.save());
    }

    private void saveTraderItem(CompoundTag compound) {
        if (this.traderBlock != null) {
            compound.putString("TraderBlock", BuiltInRegistries.ITEM.getKey((Object)this.traderBlock).toString());
        }
        if (this.blockVariant != null) {
            compound.putString("TraderVariant", this.blockVariant.toString());
        } else {
            compound.putBoolean("NoTraderVariant", true);
        }
    }

    protected final void saveOwner(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.put("OwnerData", (Tag)this.owner.save(lookup));
    }

    protected final void saveAllies(CompoundTag compound) {
        PlayerReference.saveList(compound, this.allies, "Allies");
    }

    protected final void saveAllyPermissions(CompoundTag compound) {
        ListTag allyPermList = new ListTag();
        this.allyPermissions.forEach((perm, level) -> {
            CompoundTag tag = new CompoundTag();
            if (level != 0) {
                tag.putString("Permission", perm);
                tag.putInt("Level", level.intValue());
                allyPermList.add((Object)tag);
            }
        });
        compound.put("AllyPermissions", (Tag)allyPermList);
    }

    protected final void saveShowOnTerminal(CompoundTag compound) {
        compound.putBoolean("AlwaysShowOnTerminal", this.alwaysShowOnTerminal);
    }

    protected final void saveRules(CompoundTag compound, HolderLookup.Provider lookup) {
        TradeRule.saveRules(compound, this.rules, "RuleData", lookup);
    }

    protected final void saveUpgrades(CompoundTag compound, HolderLookup.Provider lookup) {
        InventoryUtil.saveAllItems("Upgrades", compound, (Container)this.upgrades, lookup);
    }

    protected final void saveStoredMoney(CompoundTag compound) {
        compound.put("StoredMoney", (Tag)this.storedMoney.save());
    }

    protected final void saveLogger(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.put("Logger", (Tag)this.logger.save(lookup));
    }

    protected final void saveMiscSettings(CompoundTag compound) {
        compound.putBoolean("NotificationsEnabled", this.notificationsEnabled);
        compound.putBoolean("ChatNotifications", this.notificationsToChat);
        compound.putInt("TeamNotifications", this.teamNotificationLevel);
        compound.putBoolean("AlwaysShowSearchBox", this.alwaysShowSearchBox);
    }

    protected final void saveTaxSettings(CompoundTag compound) {
        compound.putInt("AcceptableTaxRate", this.acceptableTaxRate);
        compound.putBoolean("IgnoreAllTaxCollectors", this.ignoreAllTaxes);
        compound.putLongArray("IgnoreTaxCollectors", this.ignoredTaxCollectors);
    }

    protected final void saveStatistics(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.put("Stats", (Tag)this.statTracker.save(lookup));
    }

    protected abstract void saveTrades(CompoundTag var1, HolderLookup.Provider var2);

    protected abstract void saveAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    @Override
    public void markTradeRulesDirty() {
        this.markDirty(this::saveRules);
    }

    public void markStatsDirty() {
        this.markDirty(this::saveStatistics);
    }

    public final JsonObject saveToJson(String id, String ownerName, HolderLookup.Provider lookup) throws Exception {
        if (!this.canMakePersistent()) {
            throw new Exception("Trader of type '" + this.type.toString() + "' cannot be saved to JSON!");
        }
        JsonObject json = new JsonObject();
        json.addProperty("Type", this.type.toString());
        json.addProperty("ID", id);
        json.addProperty("Name", this.hasCustomName() ? this.customName.get() : "Trader");
        json.addProperty("OwnerName", ownerName);
        JsonArray ruleData = TradeRule.saveRulesToJson(this.rules, lookup);
        if (!ruleData.isEmpty()) {
            json.add("Rules", (JsonElement)ruleData);
        }
        this.saveAdditionalToJson(json, lookup);
        return json;
    }

    protected abstract void saveAdditionalToJson(JsonObject var1, HolderLookup.Provider var2);

    public final void load(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("ID", 4)) {
            this.setID(compound.getLong("ID"));
        }
        if (compound.contains("PersistentTraderID")) {
            this.persistentID = compound.getString("PersistentTraderID");
        }
        if (compound.contains("State")) {
            this.state = (TraderState)EnumUtil.enumFromString((String)compound.getString("State"), (Enum[])TraderState.values(), (Enum)TraderState.NORMAL);
        }
        if (compound.contains("WorldPos") && compound.contains("Level")) {
            CompoundTag posTag = compound.getCompound("WorldPos");
            BlockPos pos = new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z"));
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)VersionUtil.parseResource(compound.getString("Level")));
            this.worldPosition = WorldPosition.of((ResourceKey<Level>)dimension, pos);
        } else if (compound.contains("Location")) {
            this.worldPosition = WorldPosition.load(compound.getCompound("Location"));
        }
        if (compound.contains("TraderBlock")) {
            try {
                this.traderBlock = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(compound.getString("TraderBlock")));
            }
            catch (Throwable posTag) {
                // empty catch block
            }
        }
        if (compound.contains("TraderVariant")) {
            try {
                this.blockVariant = VersionUtil.parseResource(compound.getString("TraderVariant"));
            }
            catch (Throwable posTag) {}
        } else if (compound.contains("NoTraderVariant")) {
            this.blockVariant = null;
        }
        if (compound.contains("OwnerData", 10)) {
            this.owner.load(compound.getCompound("OwnerData"), lookup);
        }
        if (compound.contains("Allies")) {
            this.allies.clear();
            this.allies.addAll(PlayerReference.loadList(compound, "Allies"));
        }
        if (compound.contains("AllyPermissions")) {
            this.allyPermissions.clear();
            ListTag allyPermList = compound.getList("AllyPermissions", 10);
            for (int i = 0; i < allyPermList.size(); ++i) {
                CompoundTag tag = allyPermList.getCompound(i);
                String perm = tag.getString("Permission");
                int level = tag.getInt("Level");
                this.allyPermissions.put(perm, level);
            }
        }
        if (compound.contains("AlwaysShowOnTerminal")) {
            this.alwaysShowOnTerminal = compound.getBoolean("AlwaysShowOnTerminal");
        }
        if (compound.contains("RuleData")) {
            this.rules = TradeRule.loadRules(compound, "RuleData", this, lookup);
        }
        if (compound.contains("Upgrades")) {
            this.upgrades = InventoryUtil.loadAllItems("Upgrades", compound, 5, lookup);
            this.upgrades.addListener(this::upgradesChanged);
        }
        if (compound.contains("StoredMoney")) {
            this.storedMoney.safeLoad(compound, "StoredMoney");
        }
        if (compound.contains("Logger")) {
            this.logger.load(compound.getCompound("Logger"), lookup);
        }
        if (compound.contains("NotificationsEnabled")) {
            this.notificationsEnabled = compound.getBoolean("NotificationsEnabled");
        }
        if (compound.contains("ChatNotifications")) {
            this.notificationsToChat = compound.getBoolean("ChatNotifications");
        }
        if (compound.contains("TeamNotifications")) {
            this.teamNotificationLevel = compound.getInt("TeamNotifications");
        }
        if (compound.contains("AlwaysShowSearchBox")) {
            this.alwaysShowSearchBox = compound.getBoolean("AlwaysShowSearchBox");
        }
        if (compound.contains("AcceptableTaxRate")) {
            this.acceptableTaxRate = compound.getInt("AcceptableTaxRate");
        }
        if (compound.contains("IgnoreAllTaxCollectors")) {
            this.ignoreAllTaxes = compound.getBoolean("IgnoreAllTaxCollectors");
        }
        if (compound.contains("IgnoreTaxCollectors")) {
            this.ignoredTaxCollectors.clear();
            for (long val : compound.getLongArray("IgnoreTaxCollectors")) {
                this.ignoredTaxCollectors.add(val);
            }
        }
        if (compound.contains("Stats")) {
            this.statTracker.load(compound.getCompound("Stats"), lookup);
        }
        Object object = this.easyData.iterator();
        while (object.hasNext()) {
            EasyData data = (EasyData)object.next();
            data.read(compound, lookup);
        }
        this.loadAdditional(compound, lookup);
    }

    public void OnRegisteredToOffice() {
        if (this.isServer() && !this.isPersistent()) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    protected abstract void loadAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public final void loadFromJson(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        this.owner.SetOwner(FakeOwner.of(GsonHelper.getAsString((JsonObject)json, (String)"OwnerName", (String)"Server")));
        if (json.has("Name")) {
            this.customName.set(GsonHelper.getAsString((JsonObject)json, (String)"Name"));
        }
        if (json.has("Rules")) {
            this.rules = TradeRule.Parse(GsonHelper.getAsJsonArray((JsonObject)json, (String)"Rules"), this, lookup);
        }
        this.loadAdditionalFromJson(json, lookup);
    }

    protected abstract void loadAdditionalFromJson(JsonObject var1, HolderLookup.Provider var2) throws JsonSyntaxException, ResourceLocationException;

    public final CompoundTag savePersistentData(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        TradeRule.savePersistentData(compound, this.rules, "RuleData", lookup);
        this.saveAdditionalPersistentData(compound, lookup);
        return compound;
    }

    protected abstract void saveAdditionalPersistentData(CompoundTag var1, HolderLookup.Provider var2);

    public final void loadPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
        TradeRule.loadPersistentData(compound, this.rules, "RuleData", lookup);
        this.loadAdditionalPersistentData(compound, lookup);
    }

    protected abstract void loadAdditionalPersistentData(CompoundTag var1, HolderLookup.Provider var2);

    @Deprecated(since="2.1.2.3")
    public void openTraderMenu(Player player) {
        this.openTraderMenu(player, SimpleValidator.NULL);
    }

    public void openTraderMenu(Player player, MenuValidator validator) {
        if (player instanceof ServerPlayer) {
            player.openMenu(this.getTraderMenuProvider(validator), EasyMenu.encoder(this.getMenuDataWriter(), validator));
        }
    }

    protected MenuProvider getTraderMenuProvider(MenuValidator validator) {
        return new TraderMenuProvider(this.id, validator);
    }

    @Deprecated(since="2.1.2.3")
    public void openStorageMenu(Player player) {
        this.openStorageMenu(player, SimpleValidator.NULL);
    }

    public void openStorageMenu(Player player, MenuValidator validator) {
        if (!this.hasPermission(player, "openStorage")) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player.openMenu(this.getTraderStorageMenuProvider(validator), EasyMenu.encoder(this.getMenuDataWriter(), validator));
        }
    }

    protected MenuProvider getTraderStorageMenuProvider(MenuValidator validator) {
        return new TraderStorageMenuProvider(this.id, validator);
    }

    public Consumer<RegistryFriendlyByteBuf> getMenuDataWriter() {
        return b -> b.writeLong(this.id);
    }

    public TradeEvent.PreTradeEvent runPreTradeEvent(TradeData trade, TradeContext context) {
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(trade, context);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
        trade.beforeTrade(event);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public TradeEvent.TradeCostEvent runTradeCostEvent(TradeData trade, TradeContext context) {
        return this.runTradeCostEvent(trade, context, TradeRule.getBaseCost(trade, context));
    }

    public TradeEvent.TradeCostEvent runTradeCostEvent(TradeData trade, TradeContext context, MoneyValue baseCost) {
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(trade, context, baseCost);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
        trade.tradeCost(event);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public void runPostTradeEvent(TradeData trade, TradeContext context, MoneyValue cost, MoneyValue taxesPaid) {
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(trade, context, cost, taxesPaid);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
        if (event.isDirty()) {
            this.markTradeRulesDirty();
        }
        event.clean();
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
        }
        event.clean();
        NeoForge.EVENT_BUS.post((Event)event);
        this.latestTrade = event;
    }

    public final List<ItemStack> getContents(Level level, BlockPos pos, @Nullable BlockState state, boolean dropBlock) {
        ItemStack blockStack = ItemStack.EMPTY;
        if (dropBlock) {
            Block block;
            Block block2 = block = state != null ? state.getBlock() : null;
            if (block != null) {
                blockStack = new ItemStack((ItemLike)block);
            }
            if (block instanceof ITraderBlock) {
                ITraderBlock b = (ITraderBlock)block;
                blockStack = b.getDropBlockItem(level, pos, state);
            }
            if (blockStack.isEmpty()) {
                LightmansCurrency.LogWarning("Block drop for trader is empty!");
            } else if (this.blockVariant != null) {
                blockStack.set(ModDataComponents.MODEL_VARIANT, (Object)this.blockVariant);
            }
        }
        return this.getContents(blockStack);
    }

    public final List<ItemStack> getContents(ItemStack item) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (!item.isEmpty()) {
            results.add(item);
        }
        for (int i = 0; i < this.upgrades.getContainerSize(); ++i) {
            ItemStack stack = this.upgrades.getItem(i);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        for (MoneyValue value : this.storedMoney.allValues()) {
            List<ItemStack> items = value.onBlockBroken(this.owner);
            if (items == null) continue;
            results.addAll(items);
        }
        this.getAdditionalContents(results);
        return results;
    }

    @Override
    public EjectionData buildEjectionData(Level level, BlockPos pos, @Nullable BlockState state) {
        ItemStack item = ItemStack.EMPTY;
        if (state == null) {
            if (this.traderBlock != null) {
                item = new ItemStack((ItemLike)this.traderBlock);
            }
        } else {
            item = new ItemStack((ItemLike)state.getBlock());
        }
        if (!item.isEmpty()) {
            item.set(ModDataComponents.TRADER_ITEM_DATA, (Object)new TraderItemData(this.getID()));
            if (this.blockVariant != null) {
                item.set(ModDataComponents.MODEL_VARIANT, (Object)this.blockVariant);
            }
        }
        this.setState(TraderState.EJECTED);
        return new TraderEjectionData(this.getID(), item);
    }

    protected abstract void getAdditionalContents(List<ItemStack> var1);

    public static TraderData Deserialize(boolean isClient, CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Type")) {
            String type = compound.getString("Type");
            TraderType<?> traderType = TraderAPI.API.GetTraderType(VersionUtil.parseResource(type));
            if (traderType != null) {
                return traderType.load(isClient, compound, lookup);
            }
            LightmansCurrency.LogWarning("Could not deserialize TraderData of type '" + type + "' as no TraderType has been registered with that id!");
            return null;
        }
        LightmansCurrency.LogError("Could not deserialize TraderData as no 'Type' entry was given!");
        return null;
    }

    public static TraderData Deserialize(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        String thisType = GsonHelper.getAsString((JsonObject)json, (String)"Type");
        TraderType<?> traderType = TraderAPI.API.GetTraderType(VersionUtil.parseResource(thisType));
        if (traderType != null) {
            return traderType.loadFromJson(json, lookup);
        }
        throw new JsonSyntaxException("Trader type '" + thisType + "' is undefined.");
    }

    public boolean shouldRemove(MinecraftServer server) {
        if (!this.hasWorldPosition()) {
            return false;
        }
        TraderBlockEntity<?> be = this.getBlockEntity();
        return be != null && be.getTraderID() != this.id;
    }

    public List<Player> getUsers() {
        return new ArrayList<Player>(this.currentUsers);
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void userOpen(Player player) {
        this.currentUsers.add(player);
        this.updateUserCount();
    }

    public void userClose(Player player) {
        this.currentUsers.remove(player);
        this.updateUserCount();
    }

    private void updateUserCount() {
        if (this.isServer()) {
            this.userCount = this.currentUsers.size();
            new SPacketSyncUsers(this.id, this.userCount).sendToAll();
        }
    }

    public void updateUserCount(int userCount) {
        if (this.isClient) {
            this.userCount = userCount;
        }
    }

    public abstract List<? extends TradeData> getTradeData();

    @Nullable
    public abstract TradeData getTrade(int var1);

    public int indexOfTrade(TradeData trade) {
        return this.getTradeData().indexOf(trade);
    }

    public abstract void addTrade(Player var1);

    public abstract void removeTrade(Player var1);

    @Override
    public final boolean isTrader() {
        return true;
    }

    @Override
    public final boolean isTrade() {
        return false;
    }

    @Override
    public boolean canMoneyBeRelevant() {
        List<? extends TradeData> trades = this.getTradeData();
        if (trades != null) {
            return trades.stream().anyMatch(ITradeRuleHost::canMoneyBeRelevant);
        }
        return true;
    }

    @Override
    public boolean isMoneyRelevant() {
        return this.canMoneyBeRelevant();
    }

    public final TradeResult TryExecuteTrade(TradeContext context, int tradeIndex) {
        this.latestTrade = null;
        if (this.exceedsAcceptableTaxRate()) {
            return TradeResult.FAIL_TAX_EXCEEDED_LIMIT;
        }
        TradeResult result = this.ExecuteTrade(context, tradeIndex);
        if (result.isSuccess()) {
            this.incrementStat(StatKeys.Traders.TRADES_EXECUTED, 1);
            this.markStatsDirty();
        }
        return result;
    }

    public final FullTradeResult TryExecuteTradeWithResults(TradeContext context, int tradeIndex) {
        TradeResult result = this.TryExecuteTrade(context, tradeIndex);
        if (result.isSuccess() && this.latestTrade != null) {
            return FullTradeResult.success(this.latestTrade);
        }
        return FullTradeResult.failure(result);
    }

    protected abstract TradeResult ExecuteTrade(TradeContext var1, int var2);

    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    public abstract boolean canMakePersistent();

    public Predicate<TradeData> getStorageTradeFilter(ITraderStorageMenu menu) {
        return t -> true;
    }

    public abstract void initStorageTabs(ITraderStorageMenu var1);

    public void handleSettingsChange(Player player, LazyPacketData message) {
        boolean newState;
        boolean newVal;
        int level;
        boolean enable;
        boolean enable2;
        PlayerReference oldAlly;
        PlayerReference newAlly;
        PlayerReference newOwnerPlayer;
        if (message.contains("ChangePlayerOwner") && this.hasPermission(player, "transferOwnership") && (newOwnerPlayer = PlayerReference.of(this.isClient, message.getString("ChangePlayerOwner"))) != null) {
            PlayerOwner newOwner = PlayerOwner.of(newOwnerPlayer);
            Owner oldOwner = this.owner.getValidOwner();
            if (oldOwner.matches(newOwner)) {
                LightmansCurrency.LogDebug("Set owner player to the same player who already owns this machine.");
                return;
            }
            this.owner.SetOwner(newOwner);
            this.linkedToBank.set(false);
            this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldOwner));
        }
        if (message.contains("ChangeOwner") && this.hasPermission(player, "transferOwnership")) {
            Owner newOwner = message.getOwner("ChangeOwner");
            Owner oldOwner = this.owner.getValidOwner();
            if (newOwner != null && !oldOwner.matches(newOwner)) {
                this.owner.SetOwner(newOwner);
                this.linkedToBank.set(false);
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldOwner));
            }
        }
        if (message.contains("AddAlly") && this.hasPermission(player, "addRemoveAllies") && (newAlly = PlayerReference.load(message.getNBT("AddAlly"))) != null && !PlayerReference.isInList(this.allies, newAlly.id)) {
            this.allies.add(newAlly);
            this.markDirty(this::saveAllies);
            this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), true, newAlly));
        }
        if (message.contains("RemoveAlly") && this.hasPermission(player, "addRemoveAllies") && PlayerReference.removeFromList(this.allies, oldAlly = PlayerReference.load(message.getNBT("RemoveAlly")))) {
            this.markDirty(this::saveAllies);
            this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), false, oldAlly));
        }
        if (message.contains("ChangeAllyPermissions") && this.hasPermission(player, "editPermissions")) {
            String permission = message.getString("ChangeAllyPermissions");
            int newLevel = message.getInt("NewLevel");
            this.setAllyPermissionLevel(player, permission, newLevel);
        }
        if (message.contains("ChangeName")) {
            this.customName.trySet(player, message.getString("ChangeName"));
        }
        if (message.contains("ChangeIcon")) {
            IconData newIcon = IconData.load(message.getNBT("ChangeIcon"), message.lookup);
            if (newIcon == null) {
                newIcon = IconData.Null();
            }
            this.customIcon.trySet(player, newIcon);
        }
        if (message.contains("MakeCreative")) {
            this.creative.trySet(player, message.getBoolean("MakeCreative"));
        }
        if (message.contains("StoreCreativeMoney")) {
            this.storeCreativeMoney.trySet(player, message.getBoolean("StoreCreativeMoney"));
        }
        if (message.contains("LinkToBankAccount")) {
            this.linkedToBank.trySet(player, message.getBoolean("LinkToBankAccount"));
        }
        if (message.contains("Notifications") && this.hasPermission(player, "editSettings") && this.notificationsEnabled != (enable2 = message.getBoolean("Notifications"))) {
            this.notificationsEnabled = enable2;
            this.markDirty(this::saveMiscSettings);
            this.pushLocalNotification(ChangeSettingNotification.simple(PlayerReference.of(player), (Component)EasyText.literal("Notifications"), this.notificationsEnabled));
        }
        if (message.contains("NotificationsToChat") && this.hasPermission(player, "editSettings") && this.notificationsToChat != (enable = message.getBoolean("NotificationsToChat"))) {
            this.notificationsToChat = enable;
            this.markDirty(this::saveMiscSettings);
            this.pushLocalNotification(ChangeSettingNotification.simple(PlayerReference.of(player), (Component)EasyText.literal("NotificationsToChat"), this.notificationsToChat));
        }
        if (message.contains("TeamNotificationLevel") && this.hasPermission(player, "editSettings") && this.teamNotificationLevel != (level = message.getInt("TeamNotificationLevel"))) {
            this.teamNotificationLevel = level;
            this.markDirty(this::saveMiscSettings);
            this.pushLocalNotification(ChangeSettingNotification.simple(PlayerReference.of(player), (Component)EasyText.literal("TeamNotificationLevel"), this.teamNotificationLevel));
        }
        if (message.contains("AlwaysShowSearchBox") && this.hasPermission(player, "editSettings") && this.alwaysShowSearchBox != (newVal = message.getBoolean("AlwaysShowSearchBox"))) {
            this.alwaysShowSearchBox = newVal;
            this.markDirty(this::saveMiscSettings);
            this.pushLocalNotification(ChangeSettingNotification.simple(PlayerReference.of(player), (Component)EasyText.literal("AlwaysShowSearchBox"), this.alwaysShowSearchBox));
        }
        if (message.contains("AcceptableTaxRate") && this.hasPermission(player, "editSettings")) {
            int newRate = MathUtil.clamp(message.getInt("AcceptableTaxRate"), 0, 99);
            if (newRate == this.acceptableTaxRate) {
                return;
            }
            this.pushLocalNotification(ChangeSettingNotification.advanced(PlayerReference.of(player), (Component)EasyText.literal("AcceptableTaxRate"), newRate, this.acceptableTaxRate));
            this.acceptableTaxRate = newRate;
            this.markDirty(this::saveTaxSettings);
        }
        if (message.contains("ForceIgnoreAllTaxCollectors") && (!(newState = message.getBoolean("ForceIgnoreAllTaxCollectors")) || LCAdminMode.isAdminPlayer(player)) && newState != this.ignoreAllTaxes) {
            this.ignoreAllTaxes = newState;
            this.pushLocalNotification(ChangeSettingNotification.simple(PlayerReference.of(player), (Component)EasyText.literal("IgnoreAllTaxes"), this.ignoreAllTaxes));
            this.markDirty(this::saveTaxSettings);
        }
        if (message.contains("PickupTrader")) {
            if (this.hasPermission(player, "breakTrader")) {
                this.PickupTrader(player, message.getBoolean("PickupTrader"));
            } else {
                Permissions.PermissionWarning(player, "Pickup Trader", "breakTrader");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<SettingsSubTab> getSettingsTabs(TraderSettingsClientTab tab) {
        ArrayList tabs = Lists.newArrayList((Object[])new SettingsSubTab[]{new NameTab(tab), new CreativeSettingsTab(tab), new PersistentTab(tab), new AllyTab(tab), new PermissionsTab(tab), new MiscTab(tab), new TaxSettingsTab(tab)});
        this.addSettingsTabs(tab, tabs);
        tabs.add(new OwnershipTab(tab));
        return tabs;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addSettingsTabs(TraderSettingsClientTab tab, List<SettingsSubTab> tabs) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<PermissionOption> getPermissionOptions() {
        ArrayList options = Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("openStorage"), BooleanPermission.of("changeName"), BooleanPermission.of("editTrades"), BooleanPermission.of("collectCoins"), BooleanPermission.of("storeCoins"), BooleanPermission.of("editTradeRules"), BooleanPermission.of("editSettings"), BooleanPermission.of("addRemoveAllies"), BooleanPermission.of("editPermissions"), BooleanPermission.of("viewLogs"), BooleanPermission.of("bankLink"), BooleanPermission.of("breakTrader"), BooleanPermission.of("transferOwnership")});
        if (this.showOnTerminal()) {
            options.add(BooleanPermission.of("interactionLink"));
        }
        this.addPermissionOptions(options);
        this.handleBlockedPermissions(options);
        return options;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void addPermissionOptions(List<PermissionOption> var1);

    @OnlyIn(value=Dist.CLIENT)
    protected final void handleBlockedPermissions(List<PermissionOption> options) {
        for (String blockedPerm : this.getBlockedPermissions()) {
            for (int i = 0; i < options.size(); ++i) {
                if (!Objects.equals(options.get((int)i).permission, blockedPerm)) continue;
                options.remove(i);
                --i;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreenInit(ITraderScreen screen, Consumer<Object> addWidget) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onStorageScreenInit(ITraderStorageScreen screen, Consumer<Object> addWidget) {
    }

    @Override
    @Nullable
    public Consumer<Notification> dataChangeNotifier() {
        return this::pushLocalNotification;
    }

    public final void pushLocalNotification(Notification notification) {
        if (this.isClient) {
            return;
        }
        this.logger.addNotification(notification);
        this.markDirty(this::saveLogger);
    }

    @Override
    public final void pushNotification(Supplier<Notification> notificationSource) {
        if (this.isClient) {
            return;
        }
        this.pushLocalNotification(notificationSource.get());
        if (!this.notificationsEnabled) {
            return;
        }
        this.owner.getValidOwner().pushNotification(notificationSource, this.teamNotificationLevel, this.notificationsToChat);
    }

    public final <T> void incrementStat(StatKey<?, T> key, T addValue) {
        this.statTracker.incrementStat(key, addValue);
        this.owner.getValidOwner().incrementStat(key, addValue);
    }

    public final TraderCategory getNotificationCategory() {
        return new TraderCategory((ItemLike)(this.traderBlock != null ? this.traderBlock : (ItemLike)ModItems.TRADING_CORE.get()), this.getName(), this.id);
    }

    @Override
    public final List<TraderData> getTraders() {
        return this.allowAccess() ? Lists.newArrayList((Object[])new TraderData[]{this}) : new ArrayList();
    }

    @Override
    public final boolean isSingleTrader() {
        return true;
    }

    public static MenuProvider getTraderMenuProvider(BlockPos traderSourcePosition, MenuValidator validator) {
        return new TraderMenuProviderBlock(traderSourcePosition, validator);
    }

    public static MenuProvider getTraderMenuForAllNetworkTraders(MenuValidator validator) {
        return new TraderMenuAllNetworkProvider(validator);
    }

    public final List<Component> getTerminalInfo(@Nullable Player player) {
        ArrayList<Component> info = new ArrayList<Component>();
        this.appendTerminalInfo(info, player);
        return info;
    }

    protected void appendTerminalInfo(List<Component> list, @Nullable Player player) {
    }

    public int getTerminalTextColor() {
        if (!this.hasValidTrade()) {
            return 0xFF0000;
        }
        if (this.isCreative()) {
            return 65280;
        }
        if (!this.anyTradeHasStock()) {
            return 0xFFAA00;
        }
        return 0x404040;
    }

    private record TraderMenuProvider(long traderID, MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
            return new TraderMenu(windowID, inventory, this.traderID, this.validator);
        }
    }

    private record TraderStorageMenuProvider(long traderID, MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
            return new TraderStorageMenu(windowID, inventory, this.traderID, this.validator);
        }
    }

    private record TraderMenuProviderBlock(BlockPos traderSourcePosition, MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
            return new TraderMenu.TraderMenuBlockSource(windowID, inventory, this.traderSourcePosition, this.validator);
        }
    }

    private record TraderMenuAllNetworkProvider(MenuValidator validator) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
            return new TraderMenu.TraderMenuAllNetwork(windowID, inventory, this.validator);
        }
    }
}

