/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IUpgradeable {
    default public boolean allowUpgrade(@Nonnull UpgradeItem item) {
        return this.allowUpgrade(item.getUpgradeType());
    }

    public boolean allowUpgrade(@Nonnull UpgradeType var1);

    @Nonnull
    public Container getUpgrades();

    default public boolean quickInsertUpgrade(@Nonnull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem;
            UpgradeItem upgrade = (UpgradeItem)item;
            Container upgradeContainer = this.getUpgrades();
            Item item2 = stack.getItem();
            if (item2 instanceof UpgradeItem && this.allowUpgrade(upgradeItem = (UpgradeItem)item2) && UpgradeItem.noUniqueConflicts(upgradeItem, upgradeContainer)) {
                ItemStack insertItem = stack.copyWithCount(1);
                for (int i = 0; i < upgradeContainer.getContainerSize(); ++i) {
                    if (!upgradeContainer.getItem(i).isEmpty()) continue;
                    upgradeContainer.setItem(i, insertItem);
                    stack.shrink(1);
                    return true;
                }
            }
        }
        return false;
    }
}

