/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.colors.ATMCardColor;
import io.github.lightman314.lightmanscurrency.client.colors.GachaBallColor;
import io.github.lightman314.lightmanscurrency.client.colors.GoldenTicketColor;
import io.github.lightman314.lightmanscurrency.client.colors.SusBlockColor;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.overlay.WalletDisplayOverlay;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ATMCardScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NetworkTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.VariantSelectScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.CoinChestScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.EjectionRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.GachaMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PlayerTradeScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketStationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_management.CoinManagementScreen;
import io.github.lightman314.lightmanscurrency.client.model.VariantBlockModel;
import io.github.lightman314.lightmanscurrency.client.model.VariantItemModel;
import io.github.lightman314.lightmanscurrency.client.renderer.LCItemRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.client.renderer.item.GachaBallRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new TicketColor(), new ItemLike[]{(ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_PASS.get(), (ItemLike)ModItems.TICKET_MASTER.get()});
        event.register((ItemColor)new GoldenTicketColor(), new ItemLike[]{(ItemLike)ModItems.GOLDEN_TICKET_PASS.get(), (ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()});
        event.register((ItemColor)new ATMCardColor(), new ItemLike[]{(ItemLike)ModItems.ATM_CARD.get(), (ItemLike)ModItems.PREPAID_CARD.get()});
        event.register((ItemColor)SusBlockColor.INSTANCE, new ItemLike[]{(ItemLike)ModBlocks.SUS_JAR.get()});
        event.register((ItemColor)new GachaBallColor(), new ItemLike[]{(ItemLike)ModItems.GACHA_BALL.get()});
        event.register((stack, layer) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)-6265536), new ItemLike[]{(ItemLike)ModItems.WALLET_LEATHER.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)SusBlockColor.INSTANCE, new Block[]{ModBlocks.SUS_JAR.get()});
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        for (FreezerBlock block : ModBlocks.FREEZER.getAll()) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)block.getDoorModel()));
        }
        event.register(ModelResourceLocation.standalone((ResourceLocation)SlotMachineBlock.LIGHT_MODEL_LOCATION));
        event.register(NormalBookRenderer.MODEL_LOCATION);
        event.register(EnchantedBookRenderer.MODEL_LOCATION);
        BuiltInRegistries.ITEM.forEach(item -> {
            WalletItem wallet;
            ResourceLocation model;
            if (item instanceof WalletItem && (model = (ResourceLocation)(wallet = (WalletItem)((Object)item)).components().get(ModDataComponents.WALLET_MODEL.get())) != null) {
                event.register(ModelResourceLocation.standalone((ResourceLocation)model));
            }
        });
        event.register(GachaBallRenderer.MODEL);
    }

    @SubscribeEvent
    public static void onModelsBaked(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ArrayList<ModelResourceLocation> wrappedModels = new ArrayList<ModelResourceLocation>();
        for (Block b : BuiltInRegistries.BLOCK) {
            if (!(b instanceof IVariantBlock)) continue;
            IVariantBlock block = (IVariantBlock)b;
            for (BlockState state : b.getStateDefinition().getPossibleStates()) {
                ModelResourceLocation modelID = BlockModelShaper.stateToModelLocation((BlockState)state);
                BakedModel existingModel = (BakedModel)modelRegistry.get(modelID);
                if (existingModel != null) {
                    modelRegistry.put(modelID, new VariantBlockModel(block, existingModel));
                    wrappedModels.add(modelID);
                    continue;
                }
                LightmansCurrency.LogDebug("Missing block model:  " + String.valueOf(modelID));
            }
            ModelResourceLocation itemModel = ModelResourceLocation.inventory((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)b.asItem()));
            BakedModel existingModel = (BakedModel)modelRegistry.get(itemModel);
            if (existingModel != null) {
                modelRegistry.put(itemModel, new VariantItemModel(block, existingModel));
                wrappedModels.add(itemModel);
                continue;
            }
            LightmansCurrency.LogWarning("Missing item model: " + String.valueOf(itemModel));
        }
        LightmansCurrency.LogDebug("Wrapped " + wrappedModels.size() + " models with a custom VariantBlockModel");
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        ClientModEvents.addWalletLayer(event, PlayerSkin.Model.WIDE);
        ClientModEvents.addWalletLayer(event, PlayerSkin.Model.SLIM);
    }

    private static void addWalletLayer(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skin) {
        EntityRenderer renderer = event.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer(new WalletLayer(livingRenderer));
        }
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ClientEvents.KEY_WALLET);
        if (LCCurios.isLoaded()) {
            event.register(ClientEvents.KEY_PORTABLE_ATM);
            event.register(ClientEvents.KEY_PORTABLE_TERMINAL);
        }
    }

    @SubscribeEvent
    public static void registerWalletGuiOverlay(RegisterGuiLayersEvent event) {
        event.registerAboveAll(VersionUtil.lcResource("wallet_hud"), (LayeredDraw.Layer)WalletDisplayOverlay.INSTANCE);
    }

    @SubscribeEvent
    public static void registerScreens(@Nonnull RegisterMenuScreensEvent event) {
        event.register(ModMenus.ATM.get(), ATMScreen::new);
        event.register(ModMenus.MINT.get(), MintScreen::new);
        event.register(ModMenus.NETWORK_TERMINAL.get(), NetworkTerminalScreen::new);
        event.register(ModMenus.TRADER.get(), TraderScreen::new);
        event.register(ModMenus.TRADER_BLOCK.get(), TraderScreen::new);
        event.register(ModMenus.TRADER_NETWORK_ALL.get(), TraderScreen::new);
        event.register(ModMenus.TRADER_STORAGE.get(), TraderStorageScreen::new);
        event.register(ModMenus.SLOT_MACHINE.get(), SlotMachineScreen::new);
        event.register(ModMenus.GACHA_MACHINE.get(), GachaMachineScreen::new);
        event.register(ModMenus.WALLET.get(), WalletScreen::new);
        event.register(ModMenus.WALLET_BANK.get(), WalletBankScreen::new);
        event.register(ModMenus.TICKET_MACHINE.get(), TicketStationScreen::new);
        event.register(ModMenus.TRADER_INTERFACE.get(), TraderInterfaceScreen::new);
        event.register(ModMenus.EJECTION_RECOVERY.get(), EjectionRecoveryScreen::new);
        event.register(ModMenus.PLAYER_TRADE.get(), PlayerTradeScreen::new);
        event.register(ModMenus.COIN_CHEST.get(), CoinChestScreen::new);
        event.register(ModMenus.TAX_COLLECTOR.get(), TaxCollectorScreen::new);
        event.register(ModMenus.COIN_MANAGEMENT.get(), CoinManagementScreen::new);
        event.register(ModMenus.TEAM_MANAGEMENT.get(), TeamManagerScreen::new);
        event.register(ModMenus.NOTIFICATIONS.get(), NotificationScreen::new);
        event.register(ModMenus.ATM_CARD.get(), ATMCardScreen::new);
        event.register(ModMenus.VARIANT_SELECT.get(), VariantSelectScreen::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(LCItemRenderer.USE_LC_RENDERER, new Item[]{ModBlocks.COIN_CHEST.get().asItem(), ModItems.GACHA_BALL.get()});
    }

    @SubscribeEvent
    public static void registerResourceListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ItemPositionManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ItemPositionBlockManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)CustomModelDataManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ModelVariantDataManager.INSTANCE);
    }
}

