/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CustomItemScaleData {
    private final List<Pair<ItemTest, Float>> data;
    public static final CustomItemScaleData EMPTY = new CustomItemScaleData((List<Pair<ItemTest, Float>>)ImmutableList.of());

    public List<Pair<ItemTest, Float>> getRawData() {
        return new ArrayList<Pair<ItemTest, Float>>(this.data);
    }

    public CustomItemScaleData(List<Pair<ItemTest, Float>> data) {
        this.data = ImmutableList.copyOf(data);
    }

    public float getCustomScale(ItemStack item) {
        for (Pair<ItemTest, Float> pair : this.data) {
            if (!((ItemTest)pair.getFirst()).test(item)) continue;
            return ((Float)pair.getSecond()).floatValue();
        }
        return 1.0f;
    }

    public static ItemTest create(Supplier<? extends ItemLike> item) {
        return new MatchTest(item.get().asItem());
    }

    public static ItemTest create(TagKey<Item> itemTag) {
        return new TagTest(itemTag);
    }

    public static Pair<ItemTest, Float> parse(String string) throws ConfigParsingException {
        ItemTest test;
        String[] split = string.split(";");
        if (split.length < 2) {
            throw new ConfigParsingException("Missing ';' in '" + string + "'");
        }
        if (split.length > 2) {
            throw new ConfigParsingException("Unexpected ';' in '" + string + "'");
        }
        try {
            test = split[0].startsWith("#") ? new TagTest((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)VersionUtil.parseResource(split[0].substring(1)))) : new MatchTest((Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(split[0])));
        }
        catch (ResourceLocationException e) {
            throw new ConfigParsingException(split[0] + " is not a valid Resource Location");
        }
        try {
            float scale = Float.parseFloat(split[1]);
            if (scale <= 0.0f) {
                throw new ConfigParsingException(split[1] + " cannot be less than or equal to 0");
            }
            return Pair.of((Object)test, (Object)Float.valueOf(scale));
        }
        catch (NumberFormatException e) {
            throw new ConfigParsingException(split[1] + " is not a valid scale");
        }
    }

    public static String write(Pair<ItemTest, Float> value) {
        return ((ItemTest)value.getFirst()).toString() + ";" + String.valueOf(value.getSecond());
    }

    public static abstract class ItemTest
    implements Predicate<ItemStack> {
        public abstract String toString();
    }

    private static class MatchTest
    extends ItemTest {
        private final Item item;

        private MatchTest(Item item) {
            this.item = item;
        }

        @Override
        public String toString() {
            return BuiltInRegistries.ITEM.getKey((Object)this.item).toString();
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.getItem() == this.item;
        }
    }

    private static class TagTest
    extends ItemTest {
        private final TagKey<Item> tag;

        private TagTest(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public String toString() {
            return "#" + String.valueOf(this.tag.location());
        }

        @Override
        public boolean test(ItemStack stack) {
            return InventoryUtil.ItemHasTag(stack, this.tag);
        }
    }
}

