/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.customer.ITraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common.TraderInteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class TraderScreen
extends EasyMenuScreen<TraderMenu>
implements ITraderScreen {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/trader.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    private final ScreenPosition INFO_WIDGET_POSITION = ScreenPosition.of(175, 140);
    private final TraderClientTab DEFAULT_TAB;
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    IconButton buttonOpenTerminal;
    TraderClientTab currentTab = this.DEFAULT_TAB = new TraderInteractionTab(this);
    private final LazyWidgetPositioner rightEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), 206, 0, 20);

    @Override
    public void setTab(@Nonnull TraderClientTab tab) {
        this.currentTab.onClose();
        this.currentTab = tab;
        this.currentTab.onOpen();
    }

    @Override
    public void closeTab() {
        this.setTab(this.DEFAULT_TAB);
    }

    @Override
    @Nonnull
    public IWidgetPositioner getRightEdgePositioner() {
        return this.rightEdgePositioner;
    }

    protected boolean forceShowTerminalButton() {
        return false;
    }

    public TraderScreen(TraderMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(206, 236);
    }

    @Override
    public void initialize(ScreenArea screenArea) {
        TraderData trader;
        this.rightEdgePositioner.clear();
        this.addChild(this.rightEdgePositioner);
        this.buttonOpenStorage = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenStorage)).icon(IconUtil.ICON_STORAGE).addon(EasyAddonHelper.visibleCheck(() -> ((TraderMenu)this.menu).isSingleTrader() && ((TraderMenu)this.menu).getSingleTrader().hasPermission(((TraderMenu)this.menu).player, "openStorage")))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_OPEN_STORAGE))).build());
        this.buttonCollectCoins = this.addChild(IconAndButtonUtil.finishCollectCoinButton((IconButton.Builder)IconButton.builder().pressAction(this::CollectCoins), ((TraderMenu)this.menu).player, ((TraderMenu)this.menu)::getSingleTrader));
        this.buttonOpenTerminal = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenTerminal)).icon(IconUtil.ICON_BACK).addon(EasyAddonHelper.visibleCheck(this::showTerminalButton))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_NETWORK_BACK))).build());
        this.buttonOpenTerminal.visible = this.showTerminalButton();
        this.rightEdgePositioner.addWidgets(this.buttonOpenTerminal, this.buttonOpenStorage, this.buttonCollectCoins);
        if (((TraderMenu)this.menu).isSingleTrader() && (trader = ((TraderMenu)this.menu).getSingleTrader()) != null) {
            trader.onScreenInit(this, this::addChild);
        }
        this.currentTab.onOpen();
        this.containerTick();
    }

    private boolean showTerminalButton() {
        return this.forceShowTerminalButton() || ((TraderMenu)this.menu).isSingleTrader() && ((TraderMenu)this.menu).getSingleTrader().showOnTerminal();
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.blit(GUI_TEXTURE, this.INFO_WIDGET_POSITION, this.imageWidth + 38, 0, 10, 10);
        for (Slot slot : ((TraderMenu)this.menu).getCoinSlots()) {
            gui.blit(GUI_TEXTURE, slot.x - 1, slot.y - 1, this.imageWidth, 0, 18, 18);
        }
        if (((TraderMenu)this.menu).getInteractionSlot().isActive()) {
            gui.blit(GUI_TEXTURE, ((TraderMenu)this.menu).getInteractionSlot().x - 1, ((TraderMenu)this.menu).getInteractionSlot().y - 1, this.imageWidth, 0, 18, 18);
        }
        try {
            this.currentTab.renderBG(gui);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab " + this.currentTab.getClass().getName(), t);
        }
        gui.drawString(this.playerInventoryTitle, 23, this.imageHeight - 94, 0x404040);
        Component valueText = ((TraderMenu)this.menu).getContext(null).getAvailableFunds().getRandomValueLine();
        gui.drawString(valueText, 185 - gui.font.width((FormattedText)valueText) - 10, this.imageHeight - 94, 0x404040);
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        try {
            this.currentTab.renderAfterWidgets(gui);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab tooltips " + this.currentTab.getClass().getName(), t);
        }
        if (this.INFO_WIDGET_POSITION.offset(this).isMouseInArea(gui.mousePos, 10, 10)) {
            gui.renderComponentTooltip(((TraderMenu)this.menu).getContext(null).getAvailableFundsDescription());
        }
    }

    private void OpenStorage(EasyButton button) {
        if (((TraderMenu)this.menu).isSingleTrader()) {
            new CPacketOpenStorage(((TraderMenu)this.menu).getSingleTrader().getID()).send();
        }
    }

    private void CollectCoins(EasyButton button) {
        if (((TraderMenu)this.menu).isSingleTrader()) {
            CPacketCollectCoins.sendToServer();
        }
    }

    private void OpenTerminal(EasyButton button) {
        if (this.showTerminalButton()) {
            new CPacketOpenNetworkTerminal().send();
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.currentTab.blockInventoryClosing();
    }
}

