/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineLine;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderBlock;
import io.github.lightman314.lightmanscurrency.common.menus.slot_machine.ResultHolder;
import io.github.lightman314.lightmanscurrency.common.menus.slot_machine.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public final class SlotMachineRenderer
implements IEasyTickable {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/slot_machine_overlay.png");
    private final SlotMachineScreen screen;
    private final SlotMachineMenu menu;
    private int animationTick = 0;
    private int restTick = 0;
    public final NonNullList<SlotMachineLine> lines = NonNullList.create();
    private final List<SlotMachineRenderBlock> possibleBlocks = new ArrayList<SlotMachineRenderBlock>();
    private int totalWeight = 0;

    public Font getFont() {
        return this.screen.getFont();
    }

    private SlotMachineTraderData getTrader() {
        return this.menu.getTrader();
    }

    private RandomSource getRandom() {
        return this.menu.player.level().random;
    }

    public static int GetAnimationTime() {
        return Math.max((Integer)LCConfig.CLIENT.slotMachineAnimationTime.get(), 20);
    }

    public static int GetRestTime() {
        return Math.max((Integer)LCConfig.CLIENT.slotMachineAnimationRestTime.get(), 1);
    }

    public SlotMachineRenderer(SlotMachineScreen screen) {
        this.screen = screen;
        this.menu = (SlotMachineMenu)this.screen.getMenu();
        this.recollectPossibleBlocks();
        this.initializeLines();
    }

    public SlotMachineRenderBlock getRandomBlock() {
        if (this.totalWeight <= 0) {
            return SlotMachineRenderBlock.empty();
        }
        int rand = this.getRandom().nextInt(this.totalWeight) + 1;
        for (SlotMachineRenderBlock block : this.possibleBlocks) {
            if ((rand -= block.weight) > 0) continue;
            return block;
        }
        return SlotMachineRenderBlock.empty();
    }

    private void recollectPossibleBlocks() {
        SlotMachineTraderData trader = this.getTrader();
        this.possibleBlocks.clear();
        this.totalWeight = 0;
        if (trader != null) {
            for (SlotMachineEntry entry : trader.getValidEntries()) {
                for (ItemStack item : entry.items) {
                    this.possibleBlocks.add(SlotMachineRenderBlock.forItem(entry.getWeight(), item));
                    this.totalWeight += entry.getWeight();
                }
            }
        }
        if (this.possibleBlocks.isEmpty()) {
            this.possibleBlocks.add(SlotMachineRenderBlock.empty());
        }
    }

    private void initializeLines() {
        while (this.lines.size() < 4) {
            this.lines.add((Object)new SlotMachineLine(this));
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            List<ItemStack> previousRewards = SlotMachineEntry.splitDisplayItems(trader.getLastRewards());
            for (int i = 0; i < 4; ++i) {
                if (i < previousRewards.size()) {
                    ((SlotMachineLine)this.lines.get(i)).initialize(SlotMachineRenderBlock.forItem(0, previousRewards.get(i)));
                    continue;
                }
                ((SlotMachineLine)this.lines.get(i)).initialize();
            }
        } else {
            for (SlotMachineLine line : this.lines) {
                line.initialize();
            }
        }
    }

    @Override
    public void tick() {
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null && trader.areEntriesChanged()) {
            this.recollectPossibleBlocks();
        }
        if (this.menu.hasPendingReward() && this.animationTick == 0) {
            this.startAnimation();
            ++this.animationTick;
        } else if (this.animationTick > 0) {
            if (this.animationTick >= SlotMachineRenderer.GetAnimationTime()) {
                ++this.restTick;
                if (this.restTick >= SlotMachineRenderer.GetRestTime()) {
                    this.animationTick = 0;
                    this.restTick = 0;
                    if (!this.menu.hasPendingReward()) {
                        this.menu.SendMessageToServer(this.menu.builder().setBoolean("AnimationsCompleted", true));
                    }
                }
            } else {
                this.animationTick();
            }
        }
    }

    private void animationTick() {
        ++this.animationTick;
        for (SlotMachineLine line : this.lines) {
            line.animationTick();
        }
        if (this.animationTick >= SlotMachineRenderer.GetAnimationTime()) {
            this.menu.getAndRemoveNextReward();
            this.menu.SendMessageToServer(this.menu.builder().setBoolean("GiveNextReward", true));
        }
    }

    private void startAnimation() {
        ResultHolder pendingReward = this.menu.getNextReward();
        ArrayList<SlotMachineRenderBlock> resultBlocks = new ArrayList<SlotMachineRenderBlock>(4);
        List<ItemStack> displayItems = SlotMachineEntry.splitDisplayItems(pendingReward.getDisplayItems());
        for (int i = 0; i < 4; ++i) {
            if (i < displayItems.size()) {
                ItemStack item = displayItems.get(i);
                if (item.isEmpty()) {
                    resultBlocks.add(SlotMachineRenderBlock.empty());
                    continue;
                }
                resultBlocks.add(SlotMachineRenderBlock.forItem(0, item));
                continue;
            }
            resultBlocks.add(SlotMachineRenderBlock.empty());
        }
        for (SlotMachineLine line : this.lines) {
            line.unlock();
        }
        RandomSource rand = this.getRandom();
        ArrayList<SlotMachineLine> randomLines = new ArrayList<SlotMachineLine>((Collection<SlotMachineLine>)this.lines);
        ArrayList lockDelay = Lists.newArrayList((Object[])new Integer[]{SlotMachineRenderer.GetAnimationTime() - 1});
        while (lockDelay.size() < randomLines.size()) {
            lockDelay.add(rand.nextInt(SlotMachineRenderer.GetAnimationTime() - 11, SlotMachineRenderer.GetAnimationTime() - 1));
        }
        while (!randomLines.isEmpty()) {
            SlotMachineLine line = randomLines.size() > 1 ? (SlotMachineLine)randomLines.remove(rand.nextInt(randomLines.size())) : (SlotMachineLine)randomLines.removeFirst();
            line.lockAtResult((SlotMachineRenderBlock)resultBlocks.removeFirst(), (Integer)lockDelay.removeFirst());
        }
    }

    public void render(@Nonnull EasyGuiGraphics gui) {
        gui.blit(GUI_TEXTURE, 0, 0, 0, 0, this.screen.getXSize(), this.screen.getYSize());
        int startX = 53;
        int y = 11;
        for (int i = 0; i < 4; ++i) {
            ((SlotMachineLine)this.lines.get(i)).render(gui, startX, y);
            startX += SlotMachineLine.BLOCK_SIZE;
        }
    }
}

