/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamSalarySettingsTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class TeamSalarySettingsClientTab
extends TeamManagementClientTab<TeamSalarySettingsTab> {
    EasyButton toggleLoginRequirementButton;
    EasyButton toggleAutoSalaryButton;
    PlainButton toggleSalaryNotificationButton;
    TimeInputWidget salaryDelayInput;
    EasyButton manualTriggerButton;

    public TeamSalarySettingsClientTab(@Nonnull Object screen, @Nonnull TeamSalarySettingsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(IconUtil.ICON_SETTINGS, IconData.of(ModBlocks.ATM));
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TEAM_SALARY_SETTINGS.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        this.toggleAutoSalaryButton = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 10))).width(screenArea.width - 40)).text(this::getToggleButtonText).pressAction(this::ToggleAutoSalary)).build());
        this.toggleLoginRequirementButton = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, 38))).pressAction(this::ToggleLoginRequirement)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::isLoginRequired)).build());
        this.toggleSalaryNotificationButton = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, 50))).pressAction(this::ToggleSalaryNotification)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::isSalaryNotificationEnabled)).build());
        this.salaryDelayInput = this.addChild(((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(20, 80))).spacing(20).unitRange(TimeUtil.TimeUnit.HOUR, TimeUtil.TimeUnit.DAY).handler(this::SetSalaryDelay).startTime(team == null ? 0L : team.getSalaryDelay()).build());
        this.manualTriggerButton = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 150))).width(screenArea.width - 40)).text(LCText.BUTTON_TEAM_SALARY_SETTINGS_TRIGGER_SALARY).pressAction(((TeamSalarySettingsTab)this.commonTab)::ManuallyTriggerSalary)).build());
    }

    private boolean isAutoSalaryEnabled() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team != null && team.isAutoSalaryEnabled();
    }

    private boolean isLoginRequired() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team != null && team.getLoginRequiredForSalary();
    }

    private boolean isSalaryNotificationEnabled() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team != null && team.getSalaryNotification();
    }

    private Component getToggleButtonText() {
        return this.isAutoSalaryEnabled() ? LCText.BUTTON_TEAM_SALARY_SETTINGS_DISABLE.get(new Object[0]) : LCText.BUTTON_TEAM_SALARY_SETTINGS_ENABLE.get(new Object[0]);
    }

    @Override
    public void tick() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return;
        }
        boolean salaryPossible = !team.getMemberSalary().isEmpty() || team.isAdminSalarySeperate() && !team.getAdminSalary().isEmpty();
        this.toggleAutoSalaryButton.active = team.getSalaryDelay() > 0L && salaryPossible || this.isAutoSalaryEnabled();
        this.manualTriggerButton.active = salaryPossible;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return;
        }
        gui.drawString((Component)LCText.GUI_TEAM_SALARY_SETTINGS_REQUIRE_LOGIN.get(new Object[0]), 32, 39, 0x404040);
        gui.drawString((Component)LCText.GUI_TEAM_SALARY_SETTINGS_NOTIFICATION.get(new Object[0]), 32, 51, 0x404040);
        gui.drawString((Component)LCText.GUI_TEAM_SALARY_SETTINGS_DELAY.get(new Object[0]), 20, 65, 0x404040);
        TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_TEAM_SALARY_INFO_DELAY.get(new TimeUtil.TimeData(team.getSalaryDelay()).getString()), 10, ((TeamManagerScreen)this.screen).getXSize() - 20, 120, 0x404040);
    }

    private void ToggleAutoSalary() {
        ((TeamSalarySettingsTab)this.commonTab).SetAutoSalary(!this.isAutoSalaryEnabled());
    }

    private void ToggleLoginRequirement() {
        ((TeamSalarySettingsTab)this.commonTab).SetSalaryLoginRequirement(!this.isLoginRequired());
    }

    private void ToggleSalaryNotification(@Nonnull EasyButton button) {
        ((TeamSalarySettingsTab)this.commonTab).SetSalaryNotification(!this.isSalaryNotificationEnabled());
    }

    private void SetSalaryDelay(@Nonnull TimeUtil.TimeData data) {
        ((TeamSalarySettingsTab)this.commonTab).SetSalaryDelay(data.miliseconds);
    }
}

