/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SlotMachineEntryDisplayWidget
extends EasyWidget
implements ITooltipSource {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 46;
    public final Supplier<SlotMachineTraderData> trader;
    public final Supplier<Integer> index;
    private static final int ITEM_POSY = 22;

    private SlotMachineEntryDisplayWidget(@Nonnull Builder builder) {
        super(builder);
        this.trader = builder.trader;
        this.index = builder.index;
    }

    @Nullable
    private SlotMachineEntry getEntry() {
        SlotMachineTraderData trader = this.trader.get();
        if (trader != null) {
            int index = this.index.get();
            List<SlotMachineEntry> entries = trader.getValidEntries();
            if (index >= 0 && index < entries.size()) {
                return entries.get(index);
            }
        }
        return null;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        SlotMachineEntry entry = this.getEntry();
        SlotMachineTraderData trader = this.trader.get();
        if (trader != null && entry != null) {
            gui.drawString((Component)LCText.GUI_TRADER_SLOT_MACHINE_ENTRY_LABEL.get(this.index.get() + 1), 0, 0, 0x404040);
            gui.drawString((Component)LCText.GUI_TRADER_SLOT_MACHINE_ODDS_LABEL.get(trader.getOdds(entry.getWeight())), 0, 12, 0x404040);
            for (int i = 0; i < 4; ++i) {
                if (i >= entry.items.size() || entry.items.get(i).isEmpty()) continue;
                gui.renderItem(entry.items.get(i), 18 * i, 22);
            }
        }
    }

    private int getItemSlotIndex(double mouseX) {
        int x = (int)mouseX - this.getX();
        if (x < 0) {
            return -1;
        }
        int result = x / 18;
        return result >= 4 ? -1 : result;
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        int itemIndex;
        if (!this.isVisible()) {
            return null;
        }
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && mouseY >= this.getY() + 22 && mouseY < this.getY() + 22 + 16 && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0 && itemIndex < entry.items.size()) {
            if (entry.isMoney()) {
                return ImmutableList.of((Object)LCText.TOOLTIP_SLOT_MACHINE_MONEY.get(entry.getMoneyValue().getText()));
            }
            ItemStack item = entry.items.get(itemIndex);
            if (!item.isEmpty()) {
                return EasyScreenHelper.getTooltipFromItem(item);
            }
        }
        return null;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private Supplier<SlotMachineTraderData> trader = () -> null;
        private Supplier<Integer> index = () -> 0;

        private Builder() {
            super(80, 46);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder trader(Supplier<SlotMachineTraderData> trader) {
            this.trader = trader;
            return this;
        }

        public Builder index(Supplier<Integer> index) {
            this.index = index;
            return this;
        }

        public SlotMachineEntryDisplayWidget build() {
            return new SlotMachineEntryDisplayWidget(this);
        }
    }
}

