/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.items.GachaBallItem;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaStorage;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class GachaMachineBlockEntityRenderer
implements BlockEntityRenderer<GachaMachineBlockEntity> {
    public static final int HEIGHT = 3;
    public static final int WIDTH = 5;
    public static final int MAX_DISPLAY_COUNT = 75;
    private final ItemRenderer itemRenderer;

    private GachaMachineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public static GachaMachineBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new GachaMachineBlockEntityRenderer(context);
    }

    public void render(GachaMachineBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        GachaTrader trader = (GachaTrader)be.getTraderData();
        if (trader == null) {
            return;
        }
        RandomSource random = RandomSource.create((long)Objects.hash(be.getLevel().dimension().location(), be.getBlockPos()));
        GachaStorage storage = trader.getStorage();
        int itemsToDraw = Math.min(75, (Integer)LCConfig.CLIENT.itemRenderLimit.get());
        if (itemsToDraw <= 0) {
            return;
        }
        List<ItemStack> contents = storage.getRandomizedContents();
        int i = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (i >= contents.size()) {
                        return;
                    }
                    ItemStack ball = contents.get(i++);
                    if (!((Boolean)LCConfig.CLIENT.drawGachaMachineItems.get()).booleanValue()) {
                        ball = GachaBallItem.makeEmptyCopy(ball);
                    }
                    pose.pushPose();
                    pose.translate((3.5 + (double)x * 2.3) / 16.0, (8.33 + 2.66 * (double)y) / 16.0, (3.5 + (double)z * 2.3) / 16.0);
                    pose.scale(0.375f, 0.375f, 0.375f);
                    this.itemRenderer.renderStatic(ball, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, pose, bufferSource, null, packedOverlay);
                    pose.popPose();
                }
            }
        }
    }
}

