/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.client.config.CustomItemScaleData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT})
public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    private static long rotationTime = 0L;

    private ItemTraderBlockEntityRenderer() {
    }

    public static ItemTraderBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new ItemTraderBlockEntityRenderer();
    }

    public void render(@Nonnull ItemTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, pose, buffer, lightLevel, id);
    }

    public static List<ItemStack> GetRenderItems(ItemTradeData trade) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getSellItem(i);
            if (item.isEmpty()) continue;
            result.add(item);
        }
        return result;
    }

    public static void renderItems(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int overlay) {
        try {
            TraderData rawTrader = blockEntity.getRawTraderData();
            if (!(rawTrader instanceof ItemTraderData)) {
                return;
            }
            ItemTraderData trader = (ItemTraderData)rawTrader;
            ItemPositionData positionData = blockEntity.GetRenderData();
            ModelVariant variant = ModelVariantDataManager.getVariant(blockEntity.getCurrentVariant());
            if (variant != null && variant.has(VariantProperties.ITEM_POSITION_DATA)) {
                positionData = Objects.requireNonNullElse(variant.get(VariantProperties.ITEM_POSITION_DATA).get(), positionData);
            }
            if (positionData.isEmpty()) {
                return;
            }
            int maxIndex = positionData.getEntryCount();
            int renderLimit = (Integer)LCConfig.CLIENT.itemRenderLimit.get();
            BlockState state = blockEntity.getBlockState();
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            Level level = blockEntity.getLevel();
            BlockPos blockPos = blockEntity.getBlockPos();
            int skyLight = level.getBrightness(LightLayer.SKY, blockPos);
            for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < maxIndex; ++tradeSlot) {
                ItemTradeData trade = trader.getTrade(tradeSlot);
                List<ItemStack> renderItems = ItemTraderBlockEntityRenderer.GetRenderItems(trade);
                if (renderItems.isEmpty()) continue;
                List<Vector3f> positions = positionData.getPositions(state, tradeSlot);
                List<Quaternionf> rotation = positionData.getRotation(state, tradeSlot, partialTicks);
                int minLight = positionData.getMinLight(tradeSlot);
                int itemLight = lightLevel;
                if (level.getBrightness(LightLayer.BLOCK, blockPos) < minLight) {
                    itemLight = LightTexture.pack((int)Math.min(minLight, level.getMaxLightLevel()), (int)skyLight);
                }
                float scale = positionData.getScale(tradeSlot);
                for (int pos = 0; pos < renderLimit && pos < positions.size() && pos < trader.getTradeStock(tradeSlot); ++pos) {
                    pose.pushPose();
                    Vector3f position = positions.get(pos);
                    pose.translate(position.x(), position.y(), position.z());
                    for (Quaternionf rot : rotation) {
                        pose.mulPose(rot);
                    }
                    pose.scale(scale, scale, scale);
                    if (renderItems.size() > 1) {
                        pose.pushPose();
                        pose.translate(0.25, 0.25, 0.0);
                        pose.scale(0.5f, 0.5f, 0.5f);
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.getFirst(), itemLight, pose, buffer, overlay);
                        pose.popPose();
                        pose.pushPose();
                        pose.translate(-0.25, -0.25, 0.001);
                        pose.scale(0.5f, 0.5f, 0.5f);
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.get(1), itemLight, pose, buffer, overlay);
                        pose.popPose();
                    } else {
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.getFirst(), itemLight, pose, buffer, overlay);
                    }
                    pose.popPose();
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering an Item Trader!", t);
        }
    }

    private static void renderItem(ItemTraderBlockEntity be, ItemRenderer renderer, ItemStack item, int lightLevel, PoseStack pose, MultiBufferSource buffer, int id) {
        float scale = ((CustomItemScaleData)LCConfig.CLIENT.itemScaleOverrides.get()).getCustomScale(item);
        pose.scale(scale, scale, scale);
        ModelResourceLocation customModel = CustomModelDataManager.getCustomModel(be, item);
        if (customModel == null) {
            renderer.renderStatic(item, ItemDisplayContext.FIXED, lightLevel, OverlayTexture.NO_OVERLAY, pose, buffer, be.getLevel(), id);
        } else {
            BakedModel model = Minecraft.getInstance().getModelManager().getModel(customModel);
            renderer.render(item, ItemDisplayContext.FIXED, false, pose, buffer, lightLevel, OverlayTexture.NO_OVERLAY, model);
        }
    }

    public static long getRotationTime() {
        return rotationTime;
    }

    public static Quaternionf getRotation(float partialTicks) {
        return new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), ((float)ItemTraderBlockEntityRenderer.getRotationTime() + partialTicks) * 2.0f);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        ++rotationTime;
    }

    @Nonnull
    public AABB getRenderBoundingBox(@Nonnull ItemTraderBlockEntity blockEntity) {
        AABB result = TraderBlockEntity.getRenderBoundingBox(blockEntity);
        return result != null ? result : super.getRenderBoundingBox((BlockEntity)blockEntity);
    }
}

